/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.Request;
import com.applitools.connectivity.api.Response;
import com.applitools.connectivity.api.ResponseImpl;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;

public class RequestImpl
extends Request {
    Invocation.Builder request;

    RequestImpl(Invocation.Builder request, Logger logger) {
        super(logger);
        this.request = request;
    }

    public Request header(String name, String value) {
        ArgumentGuard.notNullOrEmpty((String)name, (String)"name");
        if (value == null) {
            this.logger.verbose(String.format("Called header %s with null value", name));
        }
        this.request = this.request.header(name, (Object)value);
        return this;
    }

    protected Response methodInner(String method, Object data, String contentType) {
        ArgumentGuard.notNullOrEmpty((String)method, (String)"method");
        if (data == null) {
            return new ResponseImpl(this.request.method(method), this.logger);
        }
        if (contentType == null) {
            throw new IllegalArgumentException("Content type can't be null");
        }
        return new ResponseImpl(this.request.method(method, Entity.entity((Object)data, (String)contentType)), this.logger);
    }
}

