/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.ConnectivityTarget;
import com.applitools.connectivity.api.ConnectivityTargetImpl;
import com.applitools.connectivity.api.HttpClient;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.Logger;
import com.applitools.utils.NetworkUtils;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class HttpClientImpl
extends HttpClient {
    private final Client client;

    public HttpClientImpl(Logger logger, int timeout, AbstractProxySettings abstractProxySettings) {
        super(logger, timeout, abstractProxySettings);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)timeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)timeout);
        if (abstractProxySettings != null) {
            clientConfig = clientConfig.property("jersey.config.client.proxy.uri", (Object)abstractProxySettings.getUri());
            if (abstractProxySettings.getUsername() != null) {
                clientConfig = clientConfig.property("jersey.config.client.proxy.username", (Object)abstractProxySettings.getUsername());
            }
            if (abstractProxySettings.getPassword() != null) {
                clientConfig = clientConfig.property("jersey.config.client.proxy.password", (Object)abstractProxySettings.getPassword());
            }
        }
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig);
        try {
            SSLContext sslContext = NetworkUtils.getDisabledSSLContext();
            builder.sslContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        this.client = builder.build();
    }

    public ConnectivityTarget target(URI baseUrl) {
        return new ConnectivityTargetImpl(this.client.target(baseUrl), this.logger);
    }

    public ConnectivityTarget target(String path) {
        return new ConnectivityTargetImpl(this.client.target(path), this.logger);
    }

    public void close() {
        this.client.close();
        this.isClosed = true;
    }
}

