/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity.api;

import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestImpl;
import com.applitools.connectivity.api.ConnectivityTarget;
import com.applitools.connectivity.api.Request;
import com.applitools.connectivity.api.RequestImpl;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.WebResource;

public class ConnectivityTargetImpl
extends ConnectivityTarget {
    WebResource target;
    AsyncWebResource asyncTarget;

    ConnectivityTargetImpl(WebResource target, AsyncWebResource asyncTarget, Logger logger) {
        super(logger);
        this.target = target;
        this.asyncTarget = asyncTarget;
    }

    public ConnectivityTarget path(String path) {
        ArgumentGuard.notNull((Object)path, (String)"path");
        this.target = this.target.path(path);
        this.asyncTarget = this.asyncTarget.path(path);
        return this;
    }

    public ConnectivityTarget queryParam(String name, String value) {
        ArgumentGuard.notNullOrEmpty((String)name, (String)"name");
        ArgumentGuard.notNullOrEmpty((String)value, (String)name);
        this.target = this.target.queryParam(name, value);
        this.asyncTarget = this.asyncTarget.queryParam(name, value);
        return this;
    }

    public Request request(String ... acceptableResponseTypes) {
        return new RequestImpl(this.target.accept(acceptableResponseTypes), this.logger);
    }

    public AsyncRequest asyncRequest(String ... acceptableResponseTypes) {
        return new AsyncRequestImpl(this.asyncTarget.accept(acceptableResponseTypes), this.logger);
    }
}

