/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.NullLogHandler;

public class Logger {
    private LogHandler logHandler = new NullLogHandler();
    private String sessionId = "";

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public void setLogHandler(LogHandler handler) {
        this.logHandler = handler == null ? NullLogHandler.instance : handler;
    }

    private String getPrefix() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String prefix = "{" + this.sessionId + "} ";
        if (stackTraceElements.length >= 4) {
            prefix = prefix + stackTraceElements[3].getClassName() + "." + stackTraceElements[3].getMethodName() + "(): ";
        }
        return prefix;
    }

    public void verbose(String message) {
        this.logHandler.onMessage(true, "[VERBOSE] " + this.getPrefix() + message);
    }

    public void log(String message) {
        this.logHandler.onMessage(false, "[LOG    ] " + this.getPrefix() + message);
    }
}

