/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.LogHandler;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;

public class FileLogger
implements LogHandler {
    private final boolean isVerbose;
    private final String filename;
    private final boolean append;
    private BufferedWriter fileWriter;

    public FileLogger(String filename, boolean append, boolean isVerbose) {
        ArgumentGuard.notNullOrEmpty(filename, "filename");
        this.filename = filename;
        this.append = append;
        this.isVerbose = isVerbose;
        this.fileWriter = null;
    }

    public FileLogger(boolean isVerbose) {
        this("eyes.log", true, isVerbose);
    }

    @Override
    public void open() {
        try {
            File file;
            File path;
            if (this.fileWriter != null) {
                try {
                    this.fileWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(path = (file = new File(this.filename)).getParentFile()).exists()) {
                System.out.println("No Folder");
                boolean success = path.mkdirs();
                System.out.println("Folder created");
            }
            this.fileWriter = new BufferedWriter(new FileWriter(file, this.append));
        }
        catch (IOException e) {
            throw new EyesException("Failed to create log file!", e);
        }
    }

    @Override
    public void onMessage(boolean verbose, String logString) {
        if (this.fileWriter != null && (!verbose || this.isVerbose)) {
            String currentTime = GeneralUtils.toISO8601DateTime(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            try {
                this.fileWriter.write(currentTime + " Eyes: " + logString);
                this.fileWriter.newLine();
                this.fileWriter.flush();
            }
            catch (IOException e) {
                throw new EyesException("Failed to write log to file!", e);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileWriter = null;
    }
}

