/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.Location;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.awt.image.BufferedImage;

public abstract class EyesScreenshot {
    protected BufferedImage image;

    public EyesScreenshot(BufferedImage image) {
        ArgumentGuard.notNull(image, "image");
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public abstract EyesScreenshot getSubScreenshot(Region var1, boolean var2);

    public abstract Location convertLocation(Location var1, CoordinatesType var2, CoordinatesType var3);

    public abstract Location getLocationInScreenshot(Location var1, CoordinatesType var2) throws OutOfBoundsException;

    public abstract Region getIntersectedRegion(Region var1, CoordinatesType var2, CoordinatesType var3);

    public Region getIntersectedRegion(Region region, CoordinatesType coordinatesType) {
        return this.getIntersectedRegion(region, coordinatesType, coordinatesType);
    }

    public Region convertRegionLocation(Region region, CoordinatesType from, CoordinatesType to) {
        ArgumentGuard.notNull(region, "region");
        if (region.isEmpty()) {
            return new Region(region);
        }
        ArgumentGuard.notNull((Object)from, "from");
        ArgumentGuard.notNull((Object)to, "to");
        Location updatedLocation = this.convertLocation(region.getLocation(), from, to);
        return new Region(updatedLocation, region.getSize());
    }
}

