/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.Logger;

public class EyesSyncObject {
    private static final int WAIT_TIMEOUT = 60000;
    private boolean isNotified = false;
    private final Logger logger;
    private String id;
    private int timeWaited = 0;

    public EyesSyncObject(Logger logger, String id) {
        this.logger = logger;
        this.id = id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isNotified() {
        return this.isNotified;
    }

    public void waitForNotify() throws InterruptedException {
        if (this.isNotified) {
            return;
        }
        while (true) {
            this.wait(60000L);
            if (this.isNotified) {
                return;
            }
            this.timeWaited += 60000;
            String message = String.format("WARNING: Waiting for %dms on object %s", this.timeWaited, this.id);
            if (this.logger != null) {
                this.logger.log(message);
                continue;
            }
            System.out.println(message);
        }
    }

    public void notifyObject() {
        this.isNotified = true;
        this.notifyAll();
    }
}

