/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.logging.TraceLevel;

public abstract class LogHandler {
    private final boolean isVerbose;

    protected LogHandler(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public abstract void open();

    public void onMessage(TraceLevel level, String message) {
        if (level == null) {
            level = TraceLevel.Notice;
        }
        if (level.isHigherThan(TraceLevel.Notice) || this.isVerbose) {
            this.onMessage(String.format("[%s]\t%s", level.name(), message));
        }
    }

    public abstract void onMessage(String var1);

    public abstract void close();

    public abstract boolean isOpen();
}

