/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.eyes.IPutFuture;
import com.applitools.eyes.Logger;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.visualgrid.model.BlobData;
import com.applitools.eyes.visualgrid.model.CdtData;
import com.applitools.eyes.visualgrid.model.CompletableTask;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IResourceFuture;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.IHasCSSDeclarations;
import com.helger.css.reader.CSSReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class RenderingTask
implements Callable<RenderStatusResults>,
CompletableTask {
    private static final int MAX_FETCH_FAILS = 62;
    public static final String CDT = "x-applitools-html/cdt";
    public static final String FULLPAGE = "full-page";
    public static final String VIEWPORT = "viewport";
    public static final int HOUR = 3600000;
    public static final String TEXT_CSS = "text/css";
    public static final String IMAGE_SVG_XML = "image/svg+xml";
    private final List<RenderTaskListener> listeners = new ArrayList<RenderTaskListener>();
    private IEyesConnector eyesConnector;
    private ICheckSettings checkSettings;
    private List<VisualGridTask> visualGridTaskList;
    private List<VisualGridTask> openVisualGridTaskList;
    private RenderingInfo renderingInfo;
    private UserAgent userAgent;
    private final Map<String, IResourceFuture> fetchedCacheMap;
    private final Map<String, IPutFuture> putResourceCache;
    private Logger logger;
    private AtomicBoolean isTaskComplete = new AtomicBoolean(false);
    private AtomicBoolean isForcePutNeeded;
    private final List<VisualGridSelector[]> regionSelectors;
    private IDebugResourceWriter debugResourceWriter;
    private FrameData result = null;
    private AtomicInteger framesLevel = new AtomicInteger();
    private RGridDom dom = null;
    private Timer timer = new Timer("VG_StopWatch", true);
    private AtomicBoolean isTimeElapsed = new AtomicBoolean(false);
    private boolean isTaskStarted = false;
    private boolean isTaskCompleted = false;
    private boolean isTaskInException = false;

    public RenderingTask(IEyesConnector eyesConnector, FrameData scriptResult, ICheckSettings checkSettings, List<VisualGridTask> visualGridTaskList, List<VisualGridTask> openVisualGridTasks, VisualGridRunner renderingGridManager, IDebugResourceWriter debugResourceWriter, RenderTaskListener listener, UserAgent userAgent, List<VisualGridSelector[]> regionSelectors) {
        this.eyesConnector = eyesConnector;
        this.result = scriptResult;
        this.checkSettings = checkSettings;
        this.visualGridTaskList = visualGridTaskList;
        this.openVisualGridTaskList = openVisualGridTasks;
        this.renderingInfo = renderingGridManager.getRenderingInfo();
        this.fetchedCacheMap = renderingGridManager.getCachedResources();
        this.putResourceCache = renderingGridManager.getPutResourceCache();
        this.logger = renderingGridManager.getLogger();
        this.debugResourceWriter = debugResourceWriter;
        this.userAgent = userAgent;
        this.regionSelectors = regionSelectors;
        this.listeners.add(listener);
        String renderingGridForcePut = GeneralUtils.getEnvString("APPLITOOLS_RENDERING_GRID_FORCE_PUT");
        this.isForcePutNeeded = new AtomicBoolean(renderingGridForcePut != null && renderingGridForcePut.equalsIgnoreCase("true"));
    }

    @Override
    public RenderStatusResults call() {
        try {
            this.isTaskStarted = true;
            this.addRenderingTaskToOpenTasks();
            this.logger.verbose("enter");
            boolean isSecondRequestAlreadyHappened = false;
            this.logger.verbose("step 1");
            RenderRequest[] requests = this.prepareDataForRG(this.result);
            this.logger.verbose("step 2");
            boolean stillRunning = true;
            int fetchFails = 0;
            boolean isForcePutAlreadyDone = false;
            List<RunningRender> runningRenders = null;
            do {
                try {
                    runningRenders = this.eyesConnector.render(requests);
                }
                catch (Exception e) {
                    Thread.sleep(1500L);
                    this.logger.verbose("/render throws exception... sleeping for 1.5s");
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                    if (e.getMessage().contains("Second request, yet still some resources were not PUT in renderId")) {
                        if (isSecondRequestAlreadyHappened) {
                            this.logger.verbose("Second request already happened");
                        }
                        isSecondRequestAlreadyHappened = true;
                    }
                    this.logger.verbose("ERROR " + e.getMessage());
                    ++fetchFails;
                }
                this.logger.verbose("step 3.1");
                if (runningRenders == null) {
                    this.logger.verbose("ERROR - runningRenders is null.");
                    continue;
                }
                for (int i = 0; i < requests.length; ++i) {
                    RenderRequest request = requests[i];
                    request.setRenderId(runningRenders.get(i).getRenderId());
                }
                this.logger.verbose("step 3.2");
                RunningRender runningRender = runningRenders.get(0);
                RenderStatus worstStatus = runningRender.getRenderStatus();
                worstStatus = this.calcWorstStatus(runningRenders, worstStatus);
                boolean isNeedMoreDom = runningRender.isNeedMoreDom();
                if (this.isForcePutNeeded.get() && !isForcePutAlreadyDone) {
                    this.forcePutAllResources(requests[0].getResources(), requests[0].getDom(), runningRender);
                    isForcePutAlreadyDone = true;
                }
                this.logger.verbose("step 3.3");
                boolean bl = stillRunning = worstStatus == RenderStatus.NEED_MORE_RESOURCE || isNeedMoreDom || fetchFails > 62;
                if (stillRunning) {
                    this.sendMissingResources(runningRenders, requests[0].getDom(), requests[0].getResources(), isNeedMoreDom);
                }
                this.logger.verbose("step 3.4");
            } while (stillRunning);
            Map<RunningRender, RenderRequest> mapping = this.mapRequestToRunningRender(runningRenders, requests);
            this.logger.verbose("step 4");
            this.pollRenderingStatus(mapping);
            this.isTaskCompleted = true;
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
            for (VisualGridTask visualGridTask : this.visualGridTaskList) {
                visualGridTask.setExceptionAndAbort(e);
            }
        }
        this.logger.verbose("Finished rendering task - exit");
        return null;
    }

    private void addRenderingTaskToOpenTasks() {
        if (this.openVisualGridTaskList != null) {
            for (VisualGridTask visualGridTask : this.openVisualGridTaskList) {
                visualGridTask.setRenderingTask(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcePutAllResources(Map<String, RGridResource> resources, RGridDom dom, RunningRender runningRender) {
        ArrayList<IPutFuture> allPuts = new ArrayList<IPutFuture>();
        Set<String> strings = resources.keySet();
        try {
            allPuts.add(this.eyesConnector.renderPutResource(runningRender, dom.asResource(), this.userAgent.getOriginalUserAgentString()));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        for (String url : strings) {
            try {
                RGridResource resource;
                this.logger.verbose("trying to get url from map - " + url);
                IResourceFuture resourceFuture = this.fetchedCacheMap.get(url);
                if (resourceFuture == null) {
                    this.logger.verbose("fetchedCacheMap.get(url) == null trying dom");
                    if (url.equals(this.dom.getUrl())) {
                        resource = this.dom.asResource();
                        continue;
                    }
                    this.logger.verbose("Resource not found Exiting...");
                    return;
                }
                resource = resourceFuture.get();
                IPutFuture future = this.eyesConnector.renderPutResource(runningRender, resource, this.userAgent.getOriginalUserAgentString());
                this.logger.verbose("locking putResourceCache");
                Map<String, IPutFuture> map = this.putResourceCache;
                synchronized (map) {
                    String contentType = resource.getContentType();
                    if (contentType != null && !contentType.equalsIgnoreCase(CDT)) {
                        this.putResourceCache.put(this.dom.getUrl(), future);
                    }
                    allPuts.add(future);
                }
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        for (IPutFuture put : allPuts) {
            try {
                put.get();
            }
            catch (InterruptedException | ExecutionException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
    }

    private void notifySuccessAllListeners() {
        for (RenderTaskListener listener : this.listeners) {
            listener.onRenderSuccess();
        }
    }

    private Map<RunningRender, RenderRequest> mapRequestToRunningRender(List<RunningRender> runningRenders, RenderRequest[] requests) {
        HashMap<RunningRender, RenderRequest> mapping = new HashMap<RunningRender, RenderRequest>();
        for (int i = 0; i < requests.length; ++i) {
            RenderRequest request = requests[i];
            RunningRender runningRender = runningRenders.get(i);
            mapping.put(runningRender, request);
        }
        return mapping;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RenderStatus calcWorstStatus(List<RunningRender> runningRenders, RenderStatus worstStatus) {
        Iterator<RunningRender> iterator = runningRenders.iterator();
        while (iterator.hasNext()) {
            RunningRender runningRender = iterator.next();
            switch (runningRender.getRenderStatus()) {
                case NEED_MORE_RESOURCE: {
                    if (worstStatus != RenderStatus.RENDERED && worstStatus != RenderStatus.RENDERING) break;
                    worstStatus = RenderStatus.NEED_MORE_RESOURCE;
                    break;
                }
                case ERROR: {
                    return RenderStatus.ERROR;
                }
            }
        }
        return worstStatus;
    }

    private List<String> getRenderIds(Collection<RunningRender> runningRenders) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RunningRender runningRender : runningRenders) {
            ids.add(runningRender.getRenderId());
        }
        return ids;
    }

    private void sendMissingResources(List<RunningRender> runningRenders, RGridDom dom, Map<String, RGridResource> resources, boolean isNeedMoreDom) {
        this.logger.verbose("enter");
        ArrayList<IPutFuture> allPuts = new ArrayList<IPutFuture>();
        if (isNeedMoreDom) {
            RunningRender runningRender = runningRenders.get(0);
            IPutFuture future = null;
            try {
                future = this.eyesConnector.renderPutResource(runningRender, dom.asResource(), this.userAgent.getOriginalUserAgentString());
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
            this.logger.verbose("locking putResourceCache");
            allPuts.add(future);
            this.logger.verbose("releasing putResourceCache");
        }
        this.logger.verbose("creating PutFutures for " + runningRenders.size() + " runningRenders");
        for (RunningRender runningRender : runningRenders) {
            this.createPutFutures(allPuts, runningRender, resources);
        }
        this.logger.verbose("calling future.get on " + allPuts.size() + " PutFutures");
        for (IPutFuture future : allPuts) {
            this.logger.verbose("calling future.get on " + future.toString());
            try {
                future.get(2L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPutFutures(List<IPutFuture> allPuts, RunningRender runningRender, Map<String, RGridResource> resources) {
        List<String> needMoreResources = runningRender.getNeedMoreResources();
        for (String url : needMoreResources) {
            RGridResource resource;
            if (this.putResourceCache.containsKey(url)) {
                IPutFuture putFuture = this.putResourceCache.get(url);
                if (allPuts.contains(putFuture)) continue;
                allPuts.add(putFuture);
                continue;
            }
            IResourceFuture resourceFuture = this.fetchedCacheMap.get(url);
            if (resourceFuture == null) {
                this.logger.verbose("fetchedCacheMap.get(url) == null - " + url);
                this.logger.verbose("Resource put requested but never downloaded(maybe a Frame)");
                resource = resources.get(url);
            } else {
                try {
                    resource = resourceFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                    continue;
                }
            }
            this.logger.verbose("resource(" + resource.getUrl() + ") hash : " + resource.getSha256());
            IPutFuture future = this.eyesConnector.renderPutResource(runningRender, resource, this.userAgent.getOriginalUserAgentString());
            String contentType = resource.getContentType();
            if (!this.putResourceCache.containsKey(url) && contentType != null && !contentType.equalsIgnoreCase(CDT)) {
                Map<String, IPutFuture> map = this.putResourceCache;
                synchronized (map) {
                    this.putResourceCache.put(url, future);
                }
            }
            allPuts.add(future);
        }
    }

    private RenderRequest[] prepareDataForRG(FrameData result) {
        Map<String, RGridResource> allBlobs = Collections.synchronizedMap(new HashMap());
        HashSet<URL> resourceUrls = new HashSet<URL>();
        this.parseScriptResult(result, allBlobs, resourceUrls);
        this.logger.verbose("fetching " + resourceUrls.size() + " resources...");
        this.fetchAllResources(allBlobs, resourceUrls, result);
        if (!resourceUrls.isEmpty()) {
            this.logger.verbose("ERROR resourceUrl is not empty!!!!!***************************");
        }
        this.logger.verbose("done fetching resources.");
        List<RGridResource> unparsedResources = this.addBlobsToCache(allBlobs);
        this.parseAndCollectExternalResources(unparsedResources, result.getUrl(), resourceUrls);
        HashMap<String, RGridResource> resourceMapping = new HashMap<String, RGridResource>();
        for (String url : allBlobs.keySet()) {
            try {
                RGridResource value;
                this.logger.verbose("trying to fetch - " + url);
                IResourceFuture iResourceFuture = this.fetchedCacheMap.get(url);
                if (iResourceFuture == null || (value = iResourceFuture.get()).getContent() == null) continue;
                resourceMapping.put(url, value);
            }
            catch (Exception e) {
                this.logger.verbose("Couldn't download url = " + url);
            }
        }
        this.buildAllRGDoms(resourceMapping, result);
        List<RenderRequest> allRequestsForRG = this.buildRenderRequests(result, resourceMapping);
        RenderRequest[] asArray = allRequestsForRG.toArray(new RenderRequest[0]);
        if (this.debugResourceWriter != null && !(this.debugResourceWriter instanceof NullDebugResourceWriter)) {
            for (RenderRequest renderRequest : asArray) {
                try {
                    this.debugResourceWriter.write(renderRequest.getDom().asResource());
                }
                catch (JsonProcessingException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
                for (RGridResource value : renderRequest.getResources().values()) {
                    this.debugResourceWriter.write(value);
                }
            }
        }
        this.logger.verbose("exit - returning renderRequest array of length: " + asArray.length);
        return asArray;
    }

    private void buildAllRGDoms(Map<String, RGridResource> resourceMapping, FrameData result) {
        URL baseUrl = null;
        try {
            baseUrl = new URL(result.getUrl());
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        this.logger.verbose("baseUrl: " + baseUrl);
        List<FrameData> allFrame = result.getFrames();
        HashMap<String, RGridResource> mapping = new HashMap<String, RGridResource>();
        for (FrameData frameObj : allFrame) {
            List<BlobData> allFramesBlobs = frameObj.getBlobs();
            List<String> allResourceUrls = frameObj.getResourceUrls();
            URL frameUrl = null;
            try {
                frameUrl = new URL(baseUrl, frameObj.getUrl());
            }
            catch (MalformedURLException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
                continue;
            }
            for (BlobData blob : allFramesBlobs) {
                String blobUrl = blob.getUrl();
                RGridResource rGridResource = resourceMapping.get(blobUrl);
                mapping.put(blobUrl, rGridResource);
            }
            for (String resourceUrl : allResourceUrls) {
                RGridResource rGridResource = resourceMapping.get(resourceUrl);
                mapping.put(resourceUrl, rGridResource);
            }
            List<CdtData> cdt = frameObj.getCdt();
            RGridDom rGridDom = new RGridDom(cdt, mapping, frameUrl.toString(), this.logger, "buildAllRGDoms");
            try {
                resourceMapping.put(frameUrl.toString(), rGridDom.asResource());
                this.buildAllRGDoms(resourceMapping, frameObj);
            }
            catch (JsonProcessingException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
    }

    private void parseScriptResult(FrameData result, Map<String, RGridResource> allBlobs, Set<URL> resourceUrls) {
        Base64 codec = new Base64();
        String baseUrlStr = result.getUrl();
        this.logger.verbose("baseUrl: " + baseUrlStr);
        URL baseUrl = null;
        try {
            baseUrl = new URL(baseUrlStr);
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        this.parseBlobs(allBlobs, codec, baseUrl, result.getBlobs());
        this.parseResourceUrls(result, resourceUrls, baseUrl);
        this.parseFrames(result, allBlobs, resourceUrls);
        List<RGridResource> unparsedResources = this.addBlobsToCache(allBlobs);
        String baseUrlAsString = null;
        if (baseUrl != null) {
            baseUrlAsString = baseUrl.toString();
        }
        this.parseAndCollectExternalResources(unparsedResources, baseUrlAsString, resourceUrls);
    }

    private void parseFrames(FrameData result, Map<String, RGridResource> allBlobs, Set<URL> resourceUrls) {
        this.logger.verbose("handling 'frames' key (level: " + this.framesLevel.incrementAndGet() + ")");
        for (FrameData frameObj : result.getFrames()) {
            this.parseScriptResult(frameObj, allBlobs, resourceUrls);
        }
        this.logger.verbose("done handling 'frames' key (level: " + this.framesLevel.getAndDecrement() + ")");
    }

    private void parseResourceUrls(FrameData result, Set<URL> resourceUrls, URL baseUrl) {
        List<String> list = result.getResourceUrls();
        for (String url : list) {
            try {
                resourceUrls.add(new URL(baseUrl, url));
            }
            catch (MalformedURLException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        this.logger.verbose("exit");
    }

    private void parseBlobs(Map<String, RGridResource> allBlobs, Base64 codec, URL baseUrl, List<BlobData> value) {
        List<BlobData> listOfBlobs = value;
        for (BlobData blob : listOfBlobs) {
            RGridResource resource = this.parseBlobToGridResource(codec, baseUrl, blob);
            if (allBlobs.containsKey(resource.getUrl())) continue;
            allBlobs.put(resource.getUrl(), resource);
        }
    }

    private List<RenderRequest> buildRenderRequests(FrameData result, Map<String, RGridResource> resourceMapping) {
        RGridDom dom;
        this.dom = dom = new RGridDom(result.getCdt(), resourceMapping, result.getUrl(), this.logger, "buildRenderRequests");
        ArrayList<RenderRequest> allRequestsForRG = new ArrayList<RenderRequest>();
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)((Object)this.checkSettings);
        ArrayList<VisualGridSelector> regionSelectorsList = new ArrayList<VisualGridSelector>();
        for (VisualGridSelector[] regionSelector : this.regionSelectors) {
            regionSelectorsList.addAll(Arrays.asList(regionSelector));
        }
        for (VisualGridTask visualGridTask : this.visualGridTaskList) {
            RenderBrowserInfo browserInfo = visualGridTask.getBrowserInfo();
            String sizeMode = checkSettingsInternal.getSizeMode();
            if (sizeMode.equalsIgnoreCase(VIEWPORT) && checkSettingsInternal.isStitchContent().booleanValue()) {
                sizeMode = FULLPAGE;
            }
            RenderInfo renderInfo = new RenderInfo(browserInfo.getWidth(), browserInfo.getHeight(), sizeMode, checkSettingsInternal.getRegion(), checkSettingsInternal.getVGTargetSelector(), browserInfo.getEmulationInfo());
            RenderRequest request = new RenderRequest(this.renderingInfo.getResultsUrl(), result.getUrl(), dom, resourceMapping, renderInfo, browserInfo.getPlatform(), browserInfo.getBrowserType(), checkSettingsInternal.getScriptHooks(), regionSelectorsList, checkSettingsInternal.isSendDom(), visualGridTask);
            allRequestsForRG.add(request);
        }
        return allRequestsForRG;
    }

    private RGridResource parseBlobToGridResource(Base64 codec, URL baseUrl, BlobData blobAsMap) {
        String contentAsString = blobAsMap.getValue();
        byte[] content = codec.decode(contentAsString);
        String urlAsString = blobAsMap.getUrl();
        try {
            URL url = new URL(baseUrl, urlAsString);
            urlAsString = url.toString();
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        RGridResource resource = new RGridResource(urlAsString, blobAsMap.getType(), content, this.logger, "parseBlobToGridResource");
        return resource;
    }

    private void parseAndCollectExternalResources(List<RGridResource> allBlobs, String baseUrl, Set<URL> resourceUrls) {
        for (RGridResource blob : allBlobs) {
            this.getAndParseResource(blob, baseUrl, resourceUrls);
        }
    }

    private void getAndParseResource(RGridResource blob, String baseUrl, Set<URL> resourceUrls) {
        TextualDataResource tdr = this.tryGetTextualData(blob, baseUrl);
        if (tdr == null) {
            return;
        }
        switch (tdr.mimeType) {
            case "text/css": {
                this.parseCSS(tdr, resourceUrls);
                break;
            }
            case "image/svg+xml": {
                this.parseSVG(tdr, resourceUrls);
            }
        }
    }

    private void parseSVG(TextualDataResource tdr, Set<URL> allResourceUris) {
        try {
            Document doc = Jsoup.parse((String)new String(tdr.originalData), (String)tdr.uri.toString(), (Parser)Parser.xmlParser());
            Elements links = doc.select("[href]");
            links.addAll((Collection)doc.select("[xlink:href]"));
            for (Element element : links) {
                String href = element.attr("href");
                if (href.isEmpty() && (href = element.attr("xlink:href")).startsWith("#")) continue;
                this.CreateUriAndAddToList(allResourceUris, tdr.uri, href);
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    private TextualDataResource tryGetTextualData(RGridResource blob, String baseUrl) {
        byte[] contentBytes = blob.getContent();
        String contentTypeStr = blob.getContentType();
        if (contentTypeStr == null) {
            return null;
        }
        if (contentBytes.length == 0) {
            return null;
        }
        String[] parts = contentTypeStr.split(";");
        TextualDataResource tdr = new TextualDataResource();
        if (parts.length > 0) {
            tdr.mimeType = parts[0].toLowerCase();
        }
        String charset = "UTF-8";
        if (parts.length > 1) {
            String[] keyVal = parts[1].split("=");
            String key = keyVal[0].trim();
            String val = keyVal[1].trim();
            if (key.equalsIgnoreCase("charset")) {
                charset = val.toUpperCase();
            }
        }
        if ((charset = charset.replaceAll("\"", "")) != null) {
            try {
                tdr.data = new String(contentBytes, charset);
            }
            catch (UnsupportedEncodingException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        try {
            URL uri = new URL(GeneralUtils.sanitizeURL(blob.getUrl(), this.logger));
            tdr.uri = new URL(new URL(baseUrl), uri.toString());
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        tdr.originalData = blob.getContent();
        this.logger.verbose("exit");
        return tdr;
    }

    private void parseCSS(TextualDataResource css, Set<URL> resourceUrls) {
        CascadingStyleSheet cascadingStyleSheet = null;
        try {
            String data = css.data;
            if (data == null) {
                return;
            }
            cascadingStyleSheet = CSSReader.readFromString((String)data, (ECSSVersion)ECSSVersion.CSS30);
            if (cascadingStyleSheet == null) {
                this.logger.verbose("exit - failed to read CSS String");
                return;
            }
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        this.collectAllImportUris(cascadingStyleSheet, resourceUrls, css.uri);
        this.collectAllFontFaceUris(cascadingStyleSheet, resourceUrls, css.uri);
        this.collectAllBackgroundImageUris(cascadingStyleSheet, resourceUrls, css.uri);
    }

    private void collectAllFontFaceUris(CascadingStyleSheet cascadingStyleSheet, Set<URL> allResourceUris, URL baseUrl) {
        this.logger.verbose("enter");
        ICommonsList allFontFaceRules = cascadingStyleSheet.getAllFontFaceRules();
        for (CSSFontFaceRule fontFaceRule : allFontFaceRules) {
            this.getAllResourcesUrisFromDeclarations(allResourceUris, (IHasCSSDeclarations)fontFaceRule, "src", baseUrl);
        }
        this.logger.verbose("exit");
    }

    private void collectAllBackgroundImageUris(CascadingStyleSheet cascadingStyleSheet, Set<URL> allResourceUris, URL baseUrl) {
        this.logger.verbose("enter");
        ICommonsList allStyleRules = cascadingStyleSheet.getAllStyleRules();
        for (CSSStyleRule styleRule : allStyleRules) {
            this.getAllResourcesUrisFromDeclarations(allResourceUris, (IHasCSSDeclarations)styleRule, "background", baseUrl);
            this.getAllResourcesUrisFromDeclarations(allResourceUris, (IHasCSSDeclarations)styleRule, "background-image", baseUrl);
        }
        this.logger.verbose("exit");
    }

    private void collectAllImportUris(CascadingStyleSheet cascadingStyleSheet, Set<URL> allResourceUris, URL baseUrl) {
        this.logger.verbose("enter");
        ICommonsList allImportRules = cascadingStyleSheet.getAllImportRules();
        for (CSSImportRule importRule : allImportRules) {
            String uri = importRule.getLocation().getURI();
            this.CreateUriAndAddToList(allResourceUris, baseUrl, uri);
        }
        this.logger.verbose("exit");
    }

    private void CreateUriAndAddToList(Set<URL> allResourceUris, URL baseUrl, String uri) {
        if (uri.toLowerCase().startsWith("data:")) {
            return;
        }
        try {
            URL url = new URL(baseUrl, uri);
            allResourceUris.add(url);
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    private <T extends IHasCSSDeclarations<T>> void getAllResourcesUrisFromDeclarations(Set<URL> allResourceUris, IHasCSSDeclarations<T> rule, String propertyName, URL baseUrl) {
        ICommonsList sourcesList = rule.getAllDeclarationsOfPropertyName(propertyName);
        for (CSSDeclaration cssDeclaration : sourcesList) {
            CSSExpression cssDeclarationExpression = cssDeclaration.getExpression();
            ICommonsList allExpressionMembers = cssDeclarationExpression.getAllMembers();
            ICommonsList allUriExpressions = allExpressionMembers.getAllInstanceOf(CSSExpressionMemberTermURI.class);
            for (CSSExpressionMemberTermURI uriExpression : allUriExpressions) {
                String uri = uriExpression.getURIString();
                this.CreateUriAndAddToList(allResourceUris, baseUrl, uri);
            }
        }
    }

    private List<RGridResource> addBlobsToCache(Map<String, RGridResource> allBlobs) {
        this.logger.verbose(String.format("trying to add %d blobs to cache", allBlobs.size()));
        this.logger.verbose(String.format("current fetchedCacheMap size: %d", this.fetchedCacheMap.size()));
        ArrayList<RGridResource> unparsedResources = new ArrayList<RGridResource>();
        for (RGridResource blob : allBlobs.values()) {
            String url = blob.getUrl();
            String contentType = blob.getContentType();
            try {
                if (contentType == null || !contentType.equalsIgnoreCase(CDT)) {
                    IResourceFuture resourceFuture = this.eyesConnector.createResourceFuture(blob);
                    this.fetchedCacheMap.put(url, resourceFuture);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            unparsedResources.add(blob);
        }
        return unparsedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAllResources(Map<String, RGridResource> allBlobs, Set<URL> resourceUrls, FrameData result) {
        this.logger.verbose("enter");
        if (resourceUrls.isEmpty()) {
            return;
        }
        ArrayList<IResourceFuture> allFetches = new ArrayList<IResourceFuture>();
        Iterator<URL> iterator = resourceUrls.iterator();
        while (iterator.hasNext()) {
            URL link = iterator.next();
            String url = link.toString();
            url = GeneralUtils.sanitizeURL(url, this.logger);
            Map<String, IResourceFuture> map = this.fetchedCacheMap;
            synchronized (map) {
                IResourceFuture fetch = this.fetchedCacheMap.get(url);
                if (fetch != null) {
                    this.logger.verbose("cache hit for url " + url);
                    allFetches.add(fetch);
                    continue;
                }
                IEyesConnector eyesConnector = this.visualGridTaskList.get(0).getEyesConnector();
                IResourceFuture future = null;
                try {
                    future = eyesConnector.getResource(link, this.userAgent.getOriginalUserAgentString());
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                    iterator.remove();
                    continue;
                }
                if (!this.fetchedCacheMap.containsKey(url)) {
                    this.fetchedCacheMap.put(url, future);
                    allFetches.add(future);
                    this.logger.verbose("this.fetchedCacheMap.put(" + url + ")");
                } else {
                    this.logger.verbose("this.fetchedCacheMap.containsKey(" + url + ")");
                }
            }
        }
        this.logger.verbose("starting to fetch( " + allFetches.size() + ") fetched resources");
        for (IResourceFuture future : allFetches) {
            try {
                String url = future.getUrl();
                this.logger.verbose("trying future.get() for resource " + url + " ...");
                RGridResource resource = future.get();
                this.logger.verbose("finishing future.get() for resource " + url + " ...");
                this.logger.verbose("done getting resource " + url);
                try {
                    this.debugResourceWriter.write(resource);
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
                this.logger.verbose("done writing to debugWriter");
                if (resource == null) {
                    this.logger.verbose("Resource is null (" + url + ") ");
                    continue;
                }
                if (resource.isResourceParsed()) continue;
                this.removeUrlFromList(url, resourceUrls);
                allBlobs.put(resource.getUrl(), resource);
                String contentType = resource.getContentType();
                this.logger.verbose("handling " + contentType + " resource from URL: " + url);
                HashSet<URL> newResourceUrls = new HashSet<URL>();
                this.getAndParseResource(resource, result.getUrl(), newResourceUrls);
                resource.setIsResourceParsed(true);
                this.fetchAllResources(allBlobs, newResourceUrls, result);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.logger.verbose("finished fetching(" + allFetches.size() + ")");
        this.logger.verbose("exit");
    }

    private void removeUrlFromList(String url, Set<URL> resourceUrls) {
        Iterator<URL> iterator = resourceUrls.iterator();
        while (iterator.hasNext()) {
            URL resourceUrl = iterator.next();
            if (!resourceUrl.toString().equalsIgnoreCase(url)) continue;
            iterator.remove();
        }
    }

    private void pollRenderingStatus(Map<RunningRender, RenderRequest> runningRenders) {
        this.logger.verbose("enter");
        List<String> ids = this.getRenderIds(runningRenders.keySet());
        this.logger.verbose("render ids : " + ids);
        List<RenderStatusResults> renderStatusResultsList = null;
        this.timer.schedule((TimerTask)new TimeoutTask(), 3600000L);
        do {
            try {
                renderStatusResultsList = this.eyesConnector.renderStatusById(ids.toArray(new String[0]));
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
                continue;
            }
            if (renderStatusResultsList == null || renderStatusResultsList.isEmpty() || renderStatusResultsList.get(0) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
                continue;
            }
            this.sampleRenderingStatus(runningRenders, ids, renderStatusResultsList);
            if (ids.size() <= 0) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        } while (!ids.isEmpty() && !this.isTimeElapsed.get());
        if (!ids.isEmpty()) {
            this.logger.verbose("Render ids that didn't complete in time : ");
            this.logger.verbose(ids.toString());
        }
        block7: for (String id : ids) {
            for (RunningRender renderedRender : runningRenders.keySet()) {
                String renderId = renderedRender.getRenderId();
                if (!renderId.equalsIgnoreCase(id)) continue;
                this.logger.verbose("removing failed render id: " + id);
                VisualGridTask visualGridTask = runningRenders.get(renderedRender).getVisualGridTask();
                visualGridTask.setRenderError(id, "too long rendering(rendering exceeded 150 sec)");
                continue block7;
            }
        }
        ICheckSettingsInternal rcInternal = (ICheckSettingsInternal)((Object)this.checkSettings);
        this.logger.verbose("marking task as complete: " + rcInternal.getName());
        this.isTaskComplete.set(true);
        this.notifySuccessAllListeners();
        this.logger.verbose("exit");
    }

    private void sampleRenderingStatus(Map<RunningRender, RenderRequest> runningRenders, List<String> ids, List<RenderStatusResults> renderStatusResultsList) {
        this.logger.verbose("enter - renderStatusResultsList.size: " + renderStatusResultsList.size());
        int j = 0;
        block0: for (int i = 0; i < renderStatusResultsList.size(); ++i) {
            RenderStatusResults renderStatusResults = renderStatusResultsList.get(i);
            if (renderStatusResults == null) continue;
            RenderStatus renderStatus = renderStatusResults.getStatus();
            boolean isRenderedStatus = renderStatus == RenderStatus.RENDERED;
            boolean isErrorStatus = renderStatus == RenderStatus.ERROR;
            this.logger.verbose("renderStatusResults - " + renderStatusResults);
            if (isRenderedStatus || isErrorStatus) {
                String removedId = ids.remove(j);
                for (RunningRender renderedRender : runningRenders.keySet()) {
                    String renderId = renderedRender.getRenderId();
                    if (!renderId.equalsIgnoreCase(removedId)) continue;
                    VisualGridTask visualGridTask = runningRenders.get(renderedRender).getVisualGridTask();
                    Iterator<VisualGridTask> iterator = this.openVisualGridTaskList.iterator();
                    while (iterator.hasNext()) {
                        VisualGridTask openVisualGridTask = iterator.next();
                        if (openVisualGridTask.getRunningTest() != visualGridTask.getRunningTest()) continue;
                        if (isRenderedStatus) {
                            this.logger.verbose("setting openVisualGridTask " + openVisualGridTask + " render result: " + renderStatusResults + " to url " + this.result.getUrl());
                            openVisualGridTask.setRenderResult(renderStatusResults);
                        } else {
                            this.logger.verbose("setting openVisualGridTask " + openVisualGridTask + " render error: " + removedId + " to url " + this.result.getUrl());
                            openVisualGridTask.setRenderError(removedId, renderStatusResults.getError());
                        }
                        iterator.remove();
                    }
                    this.logger.verbose("setting visualGridTask " + visualGridTask + " render result: " + renderStatusResults + " to url " + this.result.getUrl());
                    String error = renderStatusResults.getError();
                    if (error != null) {
                        GeneralUtils.logExceptionStackTrace(this.logger, new Exception(error));
                        visualGridTask.setRenderError(renderId, error);
                    }
                    visualGridTask.setRenderResult(renderStatusResults);
                    continue block0;
                }
                continue;
            }
            ++j;
        }
        this.logger.verbose("exit");
    }

    @Override
    public boolean getIsTaskComplete() {
        return this.isTaskComplete.get();
    }

    public void addListener(RenderTaskListener listener) {
        this.listeners.add(listener);
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            RenderingTask.this.logger.verbose("VG is Timed out!");
            RenderingTask.this.isTimeElapsed.set(true);
        }
    }

    class TextualDataResource {
        String mimeType;
        URL uri;
        String data;
        byte[] originalData;

        TextualDataResource() {
        }
    }

    public static interface RenderTaskListener {
        public void onRenderSuccess();

        public void onRenderFailed(Exception var1);
    }
}

