/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.config;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AccessibilityLevel;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.config.IConfigurationGetter;
import com.applitools.eyes.config.IConfigurationSetter;
import com.applitools.utils.GeneralUtils;
import java.net.URI;

public class Configuration
implements IConfigurationSetter,
IConfigurationGetter {
    private static final int DEFAULT_MATCH_TIMEOUT = 2000;
    private String branchName = GeneralUtils.getEnvString("APPLITOOLS_BRANCH");
    private String parentBranchName = GeneralUtils.getEnvString("APPLITOOLS_PARENT_BRANCH");
    private String baselineBranchName = GeneralUtils.getEnvString("APPLITOOLS_BASELINE_BRANCH");
    private String agentId;
    private String environmentName;
    private Boolean saveDiffs;
    private SessionType sessionType;
    protected BatchInfo batch = new BatchInfo(null);
    protected String baselineEnvName;
    protected String appName;
    protected String testName;
    protected RectangleSize viewportSize;
    protected boolean ignoreDisplacements = false;
    protected ImageMatchSettings defaultMatchSettings = new ImageMatchSettings();
    private int matchTimeout = 2000;
    private String hostApp;
    private String hostOS;
    private boolean saveNewTests;
    private boolean saveFailedTests;
    private int stitchOverlap = 10;
    private Boolean isSendDom = true;
    private String apiKey = null;
    private String serverUrl = null;
    private AbstractProxySettings proxy = null;
    private FailureReports failureReports = FailureReports.ON_CLOSE;
    private AccessibilityLevel accessibilityValidation;

    public Configuration(IConfigurationGetter other) {
        this.branchName = other.getBranchName();
        this.parentBranchName = other.getParentBranchName();
        this.baselineBranchName = other.getBaselineBranchName();
        this.agentId = other.getAgentId();
        this.environmentName = other.getEnvironmentName();
        this.saveDiffs = other.getSaveDiffs();
        this.sessionType = other.getSessionType();
        this.batch = other.getBatch();
        this.baselineEnvName = other.getBaselineEnvName();
        this.appName = other.getAppName();
        this.testName = other.getTestName();
        this.viewportSize = other.getViewportSize();
        this.defaultMatchSettings = other.getDefaultMatchSettings();
        this.matchTimeout = other.getMatchTimeout();
        this.hostApp = other.getHostApp();
        this.hostOS = other.getHostOS();
        this.saveNewTests = other.getSaveNewTests();
        this.saveFailedTests = other.getSaveFailedTests();
        this.stitchOverlap = other.getStitchOverlap();
        this.isSendDom = other.isSendDom();
        this.apiKey = other.getApiKey();
        URI serverUrl = other.getServerUrl();
        if (serverUrl != null) {
            this.serverUrl = serverUrl.toString();
        }
        this.failureReports = other.getFailureReports();
        this.proxy = other.getProxy();
        if (other.getMatchLevel() != null) {
            this.defaultMatchSettings.setMatchLevel(other.getMatchLevel());
        }
        this.ignoreDisplacements = other.getIgnoreDisplacements();
        this.accessibilityValidation = other.getAccessibilityValidation();
    }

    public Configuration() {
        this.defaultMatchSettings.setIgnoreCaret(true);
        this.agentId = null;
        this.saveNewTests = true;
        this.saveFailedTests = false;
    }

    @Override
    public boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    @Override
    public IConfigurationSetter setSaveNewTests(boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
        return this;
    }

    @Override
    public boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    @Override
    public IConfigurationSetter setSaveFailedTests(boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
        return this;
    }

    @Override
    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    @Override
    public IConfigurationSetter setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.defaultMatchSettings = defaultMatchSettings;
        return this;
    }

    @Override
    public int getMatchTimeout() {
        return this.matchTimeout;
    }

    @Override
    public IConfigurationSetter setMatchTimeout(int matchTimeout) {
        this.matchTimeout = matchTimeout;
        return this;
    }

    @Override
    public String getHostApp() {
        return this.hostApp;
    }

    @Override
    public IConfigurationSetter setHostApp(String hostApp) {
        this.hostApp = hostApp;
        return this;
    }

    @Override
    public String getHostOS() {
        return this.hostOS;
    }

    @Override
    public IConfigurationSetter setHostOS(String hostOS) {
        this.hostOS = hostOS;
        return this;
    }

    @Override
    public int getStitchOverlap() {
        return this.stitchOverlap;
    }

    @Override
    public IConfigurationSetter setStitchOverlap(int stitchOverlap) {
        this.stitchOverlap = stitchOverlap;
        return this;
    }

    @Override
    public IConfigurationSetter setBatch(BatchInfo batch) {
        this.batch = batch;
        return this;
    }

    @Override
    public BatchInfo getBatch() {
        return this.batch;
    }

    @Override
    public IConfigurationSetter setBranchName(String branchName) {
        this.branchName = branchName;
        return this;
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public IConfigurationSetter setAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @Override
    public String getParentBranchName() {
        return this.parentBranchName;
    }

    @Override
    public IConfigurationSetter setParentBranchName(String parentBranchName) {
        this.parentBranchName = parentBranchName;
        return this;
    }

    @Override
    public String getBaselineBranchName() {
        return this.baselineBranchName;
    }

    @Override
    public IConfigurationSetter setBaselineBranchName(String baselineBranchName) {
        this.baselineBranchName = baselineBranchName;
        return this;
    }

    @Override
    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    @Override
    public IConfigurationSetter setBaselineEnvName(String baselineEnvName) {
        this.baselineEnvName = baselineEnvName;
        return this;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public IConfigurationSetter setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public Boolean getSaveDiffs() {
        return this.saveDiffs;
    }

    @Override
    public IConfigurationSetter setSaveDiffs(Boolean saveDiffs) {
        this.saveDiffs = saveDiffs;
        return this;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public IConfigurationSetter setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public IConfigurationSetter setTestName(String testName) {
        this.testName = testName;
        return this;
    }

    @Override
    public RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    @Override
    public IConfigurationSetter setViewportSize(RectangleSize viewportSize) {
        this.viewportSize = viewportSize;
        return this;
    }

    @Override
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Override
    public IConfigurationSetter setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    public Configuration cloneConfig() {
        return new Configuration(this);
    }

    @Override
    public IConfigurationSetter setFailureReports(FailureReports failureReports) {
        this.failureReports = failureReports;
        return this;
    }

    @Override
    public FailureReports getFailureReports() {
        return this.failureReports;
    }

    public String toString() {
        return super.toString() + "\n\tbatch = " + this.batch + "\n\tbranchName = " + this.branchName + "\n\tparentBranchName = " + this.parentBranchName + "\n\tagentId = " + this.agentId + "\n\tbaselineEnvName = " + this.baselineEnvName + "\n\tenvironmentName = " + this.environmentName + "\n\tsaveDiffs = " + this.saveDiffs + "\n\tappName = " + this.appName + "\n\ttestName = " + this.testName + "\n\tviewportSize = " + this.viewportSize + "\n\tsessionType = " + (Object)((Object)this.sessionType);
    }

    @Override
    public Boolean isSendDom() {
        return this.isSendDom;
    }

    @Override
    public IConfigurationSetter setSendDom(boolean sendDom) {
        this.isSendDom = sendDom;
        return this;
    }

    @Override
    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.getDefaultMatchSettings().getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    @Override
    public IConfigurationSetter setIgnoreCaret(boolean value) {
        this.defaultMatchSettings.setIgnoreCaret(value);
        return this;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public IConfigurationSetter setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public URI getServerUrl() {
        if (this.serverUrl != null) {
            return URI.create(this.serverUrl);
        }
        return null;
    }

    @Override
    public IConfigurationSetter setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @Override
    public AbstractProxySettings getProxy() {
        return this.proxy;
    }

    @Override
    public IConfigurationSetter setProxy(AbstractProxySettings proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.defaultMatchSettings.getMatchLevel();
    }

    @Override
    public boolean getIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public IConfigurationSetter setMatchLevel(MatchLevel matchLevel) {
        this.defaultMatchSettings.setMatchLevel(matchLevel);
        return this;
    }

    @Override
    public IConfigurationSetter setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.ignoreDisplacements = isIgnoreDisplacements;
        return this;
    }

    @Override
    public AccessibilityLevel getAccessibilityValidation() {
        AccessibilityLevel level = this.getDefaultMatchSettings().getAccessibilityLevel();
        return level;
    }

    @Override
    public Configuration setAccessibilityValidation(AccessibilityLevel accessibilityValidation) {
        this.getDefaultMatchSettings().setAccessibilityLevel(accessibilityValidation);
        return this;
    }
}

