/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import java.io.File;
import java.nio.file.Files;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;

public class ValidateConfigAction
implements Action<Task> {
    private final Provider<File> configFile;

    public ValidateConfigAction(Provider<File> configFile) {
        this.configFile = configFile;
    }

    public void execute(Task task) {
        if (!this.isConfigFileValid()) {
            throw new GradleException("Config file " + ((File)this.configFile.get()).getPath() + " not found or not readable.");
        }
    }

    protected boolean isConfigFileValid() {
        return ((File)this.configFile.get()).exists() && Files.isReadable(((File)this.configFile.get()).toPath());
    }
}

