/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import java.io.File;
import java.nio.file.Files;
import java.util.logging.Logger;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;

public class AppmapPluginExtension {
    public static final String DEFAULT_OUTPUT_DIRECTORY = "build/appmap";
    protected final Project project;
    private final Logger logger = Logger.getLogger("com.appland.appmap");
    private final Configuration agentConf;
    private RegularFileProperty configFile;
    private DirectoryProperty outputDirectory;
    private boolean skip = false;
    private String debug = "info";
    private RegularFileProperty debugFile;
    private int eventValueSize = 1024;

    public AppmapPluginExtension(Project project, Configuration agentConf) {
        this.project = project;
        this.agentConf = agentConf;
        this.configFile = project.getObjects().fileProperty().fileValue(new File("appmap.yml"));
        this.outputDirectory = project.getObjects().directoryProperty().fileValue(new File(DEFAULT_OUTPUT_DIRECTORY));
        this.debugFile = project.getObjects().fileProperty().fileValue(new File("build/appmap/agent.log"));
        this.logger.info("Appmap Plugin Initialized.");
    }

    public Configuration getAgentConf() {
        return this.agentConf;
    }

    @Input
    public boolean shouldSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public RegularFileProperty getDebugFile() {
        return this.debugFile;
    }

    public void setDebugFile(RegularFileProperty debugFile) {
        this.debugFile = debugFile;
    }

    public int getEventValueSize() {
        return this.eventValueSize;
    }

    public void setEventValueSize(int eventValueSize) {
        this.eventValueSize = eventValueSize;
    }

    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getOutputDirectoryAsString() {
        return this.outputDirectory.toString();
    }

    public RegularFileProperty getConfigFile() {
        return this.configFile;
    }

    public boolean isConfigFileValid() {
        return ((RegularFile)this.configFile.get()).getAsFile().exists() && Files.isReadable(((RegularFile)this.configFile.get()).getAsFile().toPath());
    }
}

