/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.CtClassUtil;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.appmap.transform.annotations.IgnoreChildren;
import com.appland.appmap.transform.annotations.Signature;
import com.appland.appmap.transform.annotations.Signatures;
import com.appland.appmap.transform.annotations.SourceMethodSystem;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HookClassSystem
extends SourceMethodSystem {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final Boolean IGNORE_CHILDREN_DEFAULT = false;
    private String targetClass = null;
    private String targetMethod = null;
    private Boolean ignoresChildren = IGNORE_CHILDREN_DEFAULT;
    private final Integer position;
    private static final Signatures SIGNATURE_DEFAULT = null;
    private List<Signature> signatures = null;

    private HookClassSystem(CtBehavior behavior, int position, List<Signature> signatures) {
        super(behavior, HookClass.class);
        this.position = position;
        this.signatures = signatures;
    }

    public static ISystem from(CtBehavior behavior) {
        try {
            HookClass hookClass = (HookClass)behavior.getAnnotation(HookClass.class);
            if (hookClass == null) {
                hookClass = (HookClass)behavior.getDeclaringClass().getAnnotation(HookClass.class);
            }
            if (hookClass == null) {
                return null;
            }
            if (hookClass.value() == null) {
                return null;
            }
            Boolean ignoresChildren = (Boolean)AnnotationUtil.getValue(behavior, IgnoreChildren.class, IGNORE_CHILDREN_DEFAULT);
            Integer position = AnnotationUtil.getPosition(behavior, HookClass.class, 0);
            Signature[] signatures = (Signature[])AnnotationUtil.getObject(behavior, Signatures.class, "value", SIGNATURE_DEFAULT);
            Signature signature = (Signature)behavior.getAnnotation(Signature.class);
            ArrayList<Signature> types = null;
            if (signatures != null || signature != null) {
                types = new ArrayList<Signature>();
                if (signatures != null) {
                    Collections.addAll(types, signatures);
                } else if (signature != null) {
                    types.add(signature);
                }
            }
            HookClassSystem system = new HookClassSystem(behavior, position, types);
            system.ignoresChildren = ignoresChildren;
            system.targetClass = hookClass.value();
            system.targetMethod = hookClass.method() == null || hookClass.method().isEmpty() ? behavior.getName() : hookClass.method();
            return system;
        }
        catch (Exception e) {
            Logger.println(e);
            return null;
        }
    }

    @Override
    public Boolean match(CtBehavior behavior, Map<String, Object> matchResult) {
        logger.trace(() -> behavior.getLongName());
        String behaviorClass = behavior.getDeclaringClass().getName();
        if (this.ignoresChildren != false ? !behaviorClass.equals(this.targetClass) : CtClassUtil.isChildOf(behavior.getDeclaringClass(), this.targetClass) == false) {
            return false;
        }
        logger.trace("behaviorClass {} isChildOf targetClass: {}", behaviorClass, this.targetClass);
        String behaviorName = behavior.getName();
        if (logger.isTraceEnabled()) {
            logger.trace("behavior: {} hookBehavior: {}", behavior.getLongName(), this.getHookBehavior().getLongName());
        }
        if (!behaviorName.equals(this.targetMethod)) {
            return false;
        }
        if (this.signatures != null) {
            try {
                for (Signature signature : this.signatures) {
                    if (!HookClassSystem.methodMatchesSignature(behavior, signature).booleanValue()) continue;
                    return true;
                }
                logger.trace("signatures didn't match");
                return false;
            }
            catch (NotFoundException e) {
                Logger.println("Failed to find type of parameters of " + behaviorClass + "." + behaviorName);
                Logger.println(e);
            }
        } else {
            logger.trace("no signatures");
        }
        return true;
    }

    @Override
    public String getKey() {
        return this.targetMethod;
    }

    @Override
    public Integer getHookPosition() {
        return this.position;
    }

    private static Boolean methodMatchesSignature(CtBehavior behavior, Signature signature) throws NotFoundException {
        List<CtClass> behaviorTypes = Arrays.asList(behavior.getParameterTypes());
        String[] types = signature.value();
        if (behaviorTypes.size() != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (CtClassUtil.isChildOf(behaviorTypes.get(i), types[i]).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

