/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.conditions.RecordCondition;
import com.appland.appmap.record.ActiveSessionException;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.Logger;
import com.appland.appmap.util.StringUtil;

public class ServletHooks {
    private static final Recorder recorder = Recorder.getInstance();
    private static final String JUNIT_NAME = "junit";
    private static final String TESTNG_NAME = "testng";
    private static final String TEST_RECORDER_TYPE = "tests";

    private static void startRecording(Event event, String recorderName, String recorderType) {
        Logger.printf("Recording started for %s\n", StringUtil.canonicalName(event));
        try {
            Recorder.Metadata metadata = new Recorder.Metadata(recorderName, recorderType);
            String feature = StringUtil.identifierToSentence(event.methodId);
            String featureGroup = StringUtil.identifierToSentence(event.definedClass);
            metadata.scenarioName = String.format("%s %s", featureGroup, StringUtil.decapitalize(feature));
            metadata.recordedClassName = event.definedClass;
            metadata.recordedMethodName = event.methodId;
            metadata.sourceLocation = String.join((CharSequence)":", event.path, String.valueOf(event.lineNumber));
            recorder.start(metadata);
        }
        catch (ActiveSessionException e) {
            Logger.printf("%s\n", e.getMessage());
        }
    }

    private static void stopRecording(Event event) {
        ServletHooks.stopRecording(event, null, null);
    }

    private static void stopRecording(Event event, boolean succeeded) {
        ServletHooks.stopRecording(event, succeeded, null);
    }

    private static void stopRecording(Event event, Boolean succeeded, Throwable exception) {
        Logger.printf("Recording stopped for %s\n", StringUtil.canonicalName(event));
        String filePath = Recorder.sanitizeFilename(String.join((CharSequence)"_", event.definedClass, event.methodId));
        filePath = filePath + ".appmap.json";
        if (succeeded != null) {
            ServletHooks.recorder.getMetadata().testSucceeded = succeeded;
        }
        if (exception != null) {
            ServletHooks.recorder.getMetadata().exception = exception;
        }
        Recording recording = recorder.stop();
        recording.moveTo(filePath);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test")
    public static void junit(Event event, Object[] args) {
        ServletHooks.startRecording(event, JUNIT_NAME, TEST_RECORDER_TYPE);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void junit(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void junit(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test")
    public static void junitJupiter(Event event, Object[] args) {
        ServletHooks.startRecording(event, JUNIT_NAME, TEST_RECORDER_TYPE);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void junitJupiter(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.junit.jupiter.api.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void junitJupiter(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Object[] args) {
        ServletHooks.startRecording(event, TESTNG_NAME, TEST_RECORDER_TYPE);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void testng(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event, true);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void testng(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, false, exception);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class)
    public static void record(Event event, Object[] args) {
        ServletHooks.startRecording(event, "record_process", "process");
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class, methodEvent=MethodEvent.METHOD_RETURN)
    public static void record(Event event, Object returnValue, Object[] args) {
        ServletHooks.stopRecording(event);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookCondition(value=RecordCondition.class, methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void record(Event event, Exception exception, Object[] args) {
        event.setException(exception);
        recorder.add(event);
        ServletHooks.stopRecording(event, null, exception);
    }
}

