/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.output.v1;

import com.appland.appmap.config.Properties;
import com.appland.appmap.util.Logger;
import com.appland.shade.com.alibaba.fastjson.annotation.JSONField;
import com.appland.shade.com.alibaba.fastjson.serializer.ToStringSerializer;
import com.appland.shade.org.apache.commons.lang3.StringUtils;

public class Value {
    public String kind;
    public String name;
    @JSONField(serializeUsing=ToStringSerializer.class)
    public Object value;
    @JSONField(name="class")
    public String classType;
    @JSONField(name="object_id")
    public Integer objectId;

    public void set(Object val) {
        if (val != null) {
            this.classType = val.getClass().getName();
            this.objectId = System.identityHashCode(val);
            this.value = val;
        } else {
            this.value = null;
            this.objectId = 0;
        }
    }

    public Value() {
    }

    public Value(Value master) {
        this.classType = master.classType;
        this.kind = master.kind;
        this.name = master.name;
    }

    public Value(Object val) {
        this.set(val);
    }

    public Value(Object val, String name) {
        this.name = name;
        this.kind = "req";
        this.set(val);
    }

    public Value setClassType(String classType) {
        this.classType = classType;
        return this;
    }

    public Value setName(String name) {
        this.name = name;
        return this;
    }

    public Value setKind(String kind) {
        this.kind = kind;
        return this;
    }

    public <T> T get() {
        return (T)this.value.getClass();
    }

    public Value freeze() {
        if (this.value != null) {
            try {
                this.value = this.value.toString();
                if (Properties.MaxValueSize > 0 && this.value != null) {
                    this.value = StringUtils.abbreviate((String)this.value, "...", (int)Properties.MaxValueSize);
                }
            }
            catch (Throwable e) {
                Logger.println("failed to resolve value of " + this.classType);
                Logger.println(e.getMessage());
                this.value = "< invalid >";
            }
        }
        return this;
    }
}

