/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.util.Logger;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.Function;

public class Properties {
    public static final String APPMAP_OUTPUT_DIRECTORY_KEY = "appmap.output.directory";
    public static final Boolean Debug = System.getProperty("appmap.debug") != null;
    public static final Boolean DebugHooks = Debug != false || System.getProperty("appmap.debug.hooks") != null;
    public static final Boolean DebugLocals = System.getProperty("appmap.debug.locals") != null;
    public static final Boolean DebugHttp = Debug != false || System.getProperty("appmap.debug.http") != null;
    public static final String DebugFile = Properties.resolveProperty("appmap.debug.file", (String)null);
    public static final Boolean RecordingAuto = Properties.resolveProperty("appmap.recording.auto", Boolean::valueOf, false);
    public static final String RecordingName = Properties.resolveProperty("appmap.recording.name", (String)null);
    public static final String RecordingFile = Properties.resolveProperty("appmap.recording.file", (String)null);
    public static final Boolean RecordingRemote = Properties.resolveProperty("appmap.recording.remote", Boolean::valueOf, true);
    public static final Boolean RecordingRequests = Properties.resolveProperty("appmap.recording.requests", Boolean::valueOf, true);
    private static Path OutputDirectory;
    public static final String DefaultConfigFile = "appmap.yml";
    public static final String ConfigFile;
    public static final Integer DefaultMaxValueSize;
    public static final Integer MaxValueSize;
    public static final String[] DefaultRecords;
    public static final String[] Records;
    public static final Boolean RecordPrivate;

    private static String resolveProperty(String propName, String defaultValue) {
        String value = defaultValue;
        try {
            String propValue = System.getProperty(propName);
            if (propValue != null) {
                value = propValue;
            }
        }
        catch (Exception e) {
            Logger.printf("failed to resolve %s, falling back to default\n", propName);
            Logger.println(e);
        }
        return value;
    }

    static Path ensureOutputDirectory(FileSystem fs) throws IOException {
        OutputDirectory = Properties.resolveProperty(APPMAP_OUTPUT_DIRECTORY_KEY, x$0 -> fs.getPath((String)x$0, new String[0]), Properties.findDefaultOutputDirectory(fs));
        return OutputDirectory;
    }

    public static Path getOutputDirectory() {
        return OutputDirectory;
    }

    private static <T> T resolveProperty(String propName, Function<String, T> resolvingFunc, T defaultValue) {
        T value = defaultValue;
        try {
            String propValue = System.getProperty(propName);
            if (propValue != null) {
                value = resolvingFunc.apply(propValue);
            }
        }
        catch (Exception e) {
            Logger.printf("failed to resolve %s, falling back to default\n", propName);
            Logger.println(e);
            value = defaultValue;
        }
        return value;
    }

    private static String[] resolveProperty(String propName, String[] defaultValue) {
        String[] value = defaultValue;
        try {
            String propValue = System.getProperty(propName);
            if (propValue != null) {
                value = propValue.split(",");
                assert (value.length < 2);
            }
        }
        catch (Exception e) {
            System.err.printf("failed to resolve %s, falling back to default\n", propName);
            e.printStackTrace(System.err);
        }
        return value;
    }

    public static String[] getRecords() {
        return Records;
    }

    private static Path findDefaultOutputDirectory(FileSystem fs) {
        long buildGradleLastModified = 0L;
        long pomXmlLastModified = 0L;
        try {
            buildGradleLastModified = Files.getLastModifiedTime(fs.getPath("build.gradle", new String[0]), new LinkOption[0]).toMillis();
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            pomXmlLastModified = Files.getLastModifiedTime(fs.getPath("pom.xml", new String[0]), new LinkOption[0]).toMillis();
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (buildGradleLastModified == 0L && pomXmlLastModified == 0L) {
            return fs.getPath("tmp/appmap", new String[0]);
        }
        String gradleDir = "build/tmp/appmap";
        String mavenDir = "target/tmp/appmap";
        if (buildGradleLastModified != 0L && pomXmlLastModified != 0L) {
            if (buildGradleLastModified > pomXmlLastModified) {
                return fs.getPath(gradleDir, new String[0]);
            }
            return fs.getPath(mavenDir, new String[0]);
        }
        if (buildGradleLastModified > 0L) {
            return fs.getPath(gradleDir, new String[0]);
        }
        return fs.getPath(mavenDir, new String[0]);
    }

    static {
        ConfigFile = Properties.resolveProperty("appmap.config.file", (String)null);
        DefaultMaxValueSize = 1024;
        MaxValueSize = Properties.resolveProperty("appmap.event.valueSize", Integer::valueOf, DefaultMaxValueSize);
        DefaultRecords = new String[0];
        Records = Properties.resolveProperty("appmap.record", DefaultRecords);
        RecordPrivate = Properties.resolveProperty("appmap.record.private", Boolean::valueOf, false);
    }
}

