/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.config;

import com.appland.appmap.util.FullyQualifiedName;
import com.appland.shade.com.fasterxml.jackson.annotation.JsonCreator;
import com.appland.shade.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.regex.Pattern;

public class AppMapPackage {
    public String path;
    public String[] exclude = new String[0];
    public boolean shallow = false;
    public Boolean allMethods = true;
    public LabelConfig[] methods = null;

    public LabelConfig find(FullyQualifiedName canonicalName) {
        if (this.path == null) {
            return null;
        }
        if (canonicalName == null) {
            return null;
        }
        if (this.methods == null) {
            if (!canonicalName.toString().startsWith(this.path)) {
                return null;
            }
            return this.excludes(canonicalName) != false ? null : new LabelConfig();
        }
        if (!canonicalName.packageName.equals(this.path)) {
            return null;
        }
        for (LabelConfig ls : this.methods) {
            if (!ls.matches(canonicalName)) continue;
            return ls;
        }
        return null;
    }

    public Boolean excludes(FullyQualifiedName canonicalName) {
        for (String exclusion : this.exclude) {
            if (!canonicalName.toString().startsWith(exclusion)) continue;
            return true;
        }
        return false;
    }

    public static class LabelConfig {
        private Pattern className = null;
        private Pattern name = null;
        private String[] labels = new String[0];

        public LabelConfig() {
        }

        @JsonCreator
        public LabelConfig(@JsonProperty(value="class") String className, @JsonProperty(value="name") String name, @JsonProperty(value="labels") String[] labels) {
            this.className = Pattern.compile("\\A(" + className + ")\\z");
            this.name = Pattern.compile("\\A(" + name + ")\\z");
            this.labels = labels;
        }

        public String[] getLabels() {
            return this.labels;
        }

        public boolean matches(FullyQualifiedName name) {
            return this.matches(name.className, name.methodName);
        }

        public boolean matches(String className, String methodName) {
            return this.className.matcher(className).matches() && this.name.matcher(methodName).matches();
        }
    }
}

