/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import com.android.billingclient.api.ProductDetails;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUserProperty;
import com.apphud.sdk.domain.AdjustInfo;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.ApphudPlacement;
import com.apphud.sdk.domain.ApphudUser;
import com.apphud.sdk.domain.AppsflyerInfo;
import com.apphud.sdk.domain.FacebookInfo;
import com.apphud.sdk.parser.GsonParser;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.SharedPreferencesStorage;
import com.apphud.sdk.storage.Storage;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u000b\b\u0000\u0018\u0000 k2\u00020\u0001:\u0001kB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010C\u001a\u00020)J\u000e\u0010S\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010T\u001a\u00020UJ\u0006\u0010V\u001a\u00020)J\b\u0010W\u001a\u00020UH\u0002J\u0010\u0010X\u001a\n\u0012\u0004\u0012\u00020Y\u0018\u00010DH\u0002J\u0010\u0010Z\u001a\n\u0012\u0004\u0012\u00020[\u0018\u00010DH\u0002J\b\u0010\\\u001a\u00020UH\u0002J\u0006\u0010`\u001a\u00020)J\u000e\u0010i\u001a\u00020)2\u0006\u0010j\u001a\u00020bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010 \u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R0\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140#2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020)8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R(\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u0013\u001a\u0004\u0018\u00010.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R(\u00104\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0017\"\u0004\b6\u0010\u0019R(\u00108\u001a\u0004\u0018\u0001072\b\u0010\u0013\u001a\u0004\u0018\u0001078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R(\u0010>\u001a\u0004\u0018\u00010=2\b\u0010\u0013\u001a\u0004\u0018\u00010=8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR4\u0010F\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010D2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010D8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR4\u0010K\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010D2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010D8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bL\u0010H\"\u0004\bM\u0010JR$\u0010N\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR(\u0010]\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010\u0017\"\u0004\b_\u0010\u0019Rd\u0010d\u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020b\u0018\u00010aj\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020b\u0018\u0001`c2&\u0010\u0013\u001a\"\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020b\u0018\u00010aj\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020b\u0018\u0001`c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\be\u0010f\"\u0004\bg\u0010h\u00a8\u0006l"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "Lcom/apphud/sdk/storage/Storage;", "applicationContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "cacheTimeout", "", "preferences", "Landroid/content/SharedPreferences;", "productDetailsExclusionStrategy", "com/apphud/sdk/storage/SharedPreferencesStorage$productDetailsExclusionStrategy$1", "Lcom/apphud/sdk/storage/SharedPreferencesStorage$productDetailsExclusionStrategy$1;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "parser", "Lcom/apphud/sdk/parser/Parser;", "value", "", "userId", "getUserId", "()Ljava/lang/String;", "setUserId", "(Ljava/lang/String;)V", "Lcom/apphud/sdk/domain/ApphudUser;", "apphudUser", "getApphudUser", "()Lcom/apphud/sdk/domain/ApphudUser;", "setApphudUser", "(Lcom/apphud/sdk/domain/ApphudUser;)V", "deviceId", "getDeviceId", "setDeviceId", "", "deviceIdentifiers", "getDeviceIdentifiers", "()[Ljava/lang/String;", "setDeviceIdentifiers", "([Ljava/lang/String;)V", "", "isNeedSync", "()Z", "setNeedSync", "(Z)V", "Lcom/apphud/sdk/domain/FacebookInfo;", "facebook", "getFacebook", "()Lcom/apphud/sdk/domain/FacebookInfo;", "setFacebook", "(Lcom/apphud/sdk/domain/FacebookInfo;)V", "firebase", "getFirebase", "setFirebase", "Lcom/apphud/sdk/domain/AppsflyerInfo;", "appsflyer", "getAppsflyer", "()Lcom/apphud/sdk/domain/AppsflyerInfo;", "setAppsflyer", "(Lcom/apphud/sdk/domain/AppsflyerInfo;)V", "Lcom/apphud/sdk/domain/AdjustInfo;", "adjust", "getAdjust", "()Lcom/apphud/sdk/domain/AdjustInfo;", "setAdjust", "(Lcom/apphud/sdk/domain/AdjustInfo;)V", "needUpdateProductGroups", "", "Lcom/apphud/sdk/domain/ApphudGroup;", "productGroups", "getProductGroups", "()Ljava/util/List;", "setProductGroups", "(Ljava/util/List;)V", "productDetails", "getProductDetails", "setProductDetails", "lastRegistration", "getLastRegistration", "()J", "setLastRegistration", "(J)V", "updateUser", "clean", "", "validateCaches", "migratePaywallsToUser", "readLegacyPaywalls", "Lcom/apphud/sdk/domain/ApphudPaywall;", "readLegacyPlacements", "Lcom/apphud/sdk/domain/ApphudPlacement;", "clearLegacyPaywallsCache", "cacheVersion", "getCacheVersion", "setCacheVersion", "cacheExpired", "Ljava/util/HashMap;", "Lcom/apphud/sdk/ApphudUserProperty;", "Lkotlin/collections/HashMap;", "properties", "getProperties", "()Ljava/util/HashMap;", "setProperties", "(Ljava/util/HashMap;)V", "needSendProperty", "property", "Companion", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nSharedPreferencesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedPreferencesStorage.kt\ncom/apphud/sdk/storage/SharedPreferencesStorage\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,403:1\n39#2,12:404\n39#2,12:416\n39#2,12:428\n39#2,12:442\n39#2,12:454\n39#2,12:466\n39#2,12:478\n39#2,12:490\n39#2,12:502\n39#2,12:514\n39#2,12:526\n39#2,12:538\n39#2,12:550\n39#2,12:562\n39#2,12:574\n37#3,2:440\n*S KotlinDebug\n*F\n+ 1 SharedPreferencesStorage.kt\ncom/apphud/sdk/storage/SharedPreferencesStorage\n*L\n55#1:404,12\n68#1:416,12\n76#1:428,12\n89#1:442,12\n97#1:454,12\n110#1:466,12\n118#1:478,12\n131#1:490,12\n144#1:502,12\n163#1:514,12\n183#1:526,12\n192#1:538,12\n288#1:550,12\n299#1:562,12\n325#1:574,12\n85#1:440,2\n*E\n"})
public final class SharedPreferencesStorage
implements Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long cacheTimeout;
    @NotNull
    private final SharedPreferences preferences;
    @NotNull
    private final productDetailsExclusionStrategy.1 productDetailsExclusionStrategy;
    private final Gson gson;
    @NotNull
    private final Parser parser;
    @NotNull
    private static final String NAME = "apphud_storage";
    @NotNull
    private static final String USER_ID_KEY = "userIdKey";
    @NotNull
    private static final String APPHUD_USER_KEY = "APPHUD_USER_KEY";
    @NotNull
    private static final String DEVICE_ID_KEY = "deviceIdKey";
    @NotNull
    private static final String DEVICE_IDENTIFIERS_KEY = "DEVICE_IDENTIFIERS_KEY";
    @NotNull
    private static final String NEED_RESTART_KEY = "needRestartKey";
    @NotNull
    private static final String PROPERTIES_KEY = "propertiesKey";
    @NotNull
    private static final String FACEBOOK_KEY = "facebookKey";
    @NotNull
    private static final String FIREBASE_KEY = "firebaseKey";
    @NotNull
    private static final String APPSFLYER_KEY = "appsflyerKey";
    @NotNull
    private static final String ADJUST_KEY = "adjustKey";
    @NotNull
    private static final String PAYWALLS_KEY = "PAYWALLS_KEY";
    @NotNull
    private static final String PAYWALLS_TIMESTAMP_KEY = "PAYWALLS_TIMESTAMP_KEY";
    @NotNull
    private static final String PLACEMENTS_KEY = "PLACEMENTS_KEY";
    @NotNull
    private static final String PLACEMENTS_TIMESTAMP_KEY = "PLACEMENTS_TIMESTAMP_KEY";
    @NotNull
    private static final String GROUP_KEY = "apphudGroupKey";
    @NotNull
    private static final String GROUP_TIMESTAMP_KEY = "apphudGroupTimestampKey";
    @NotNull
    private static final String SKU_KEY = "skuKey";
    @NotNull
    private static final String SKU_TIMESTAMP_KEY = "skuTimestampKey";
    @NotNull
    private static final String LAST_REGISTRATION_KEY = "lastRegistrationKey";
    @NotNull
    private static final String CURRENT_CACHE_VERSION = "3";

    public SharedPreferencesStorage(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.cacheTimeout = ApphudExtensionsKt.isDebuggable(applicationContext) ? 6L : 90000L;
        SharedPreferences sharedPreferences = applicationContext.getSharedPreferences(NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.preferences = sharedPreferences;
        this.productDetailsExclusionStrategy = new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                return Intrinsics.areEqual((Object)f.getDeclaredType(), ProductDetails.class);
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                return Intrinsics.areEqual(clazz, ProductDetails.class);
            }
        };
        Gson gson = this.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().addSerializationExclusionStrategy((ExclusionStrategy)this.productDetailsExclusionStrategy).addDeserializationExclusionStrategy((ExclusionStrategy)this.productDetailsExclusionStrategy).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
        this.parser = new GsonParser(gson);
    }

    @Override
    @Nullable
    public String getUserId() {
        return this.preferences.getString(USER_ID_KEY, null);
    }

    @Override
    public void setUserId(@Nullable String value) {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_userId__u24lambda_u240 = editor$iv;
        boolean bl = false;
        $this$_set_userId__u24lambda_u240.putString(USER_ID_KEY, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public ApphudUser getApphudUser() {
        String source = this.preferences.getString(APPHUD_USER_KEY, null);
        Type type2 = new TypeToken<ApphudUser>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (ApphudUser)this.parser.fromJson(source, type2);
    }

    @Override
    public void setApphudUser(@Nullable ApphudUser value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_apphudUser__u24lambda_u241 = editor$iv;
        boolean bl = false;
        $this$_set_apphudUser__u24lambda_u241.putString(APPHUD_USER_KEY, source);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public String getDeviceId() {
        return this.preferences.getString(DEVICE_ID_KEY, null);
    }

    @Override
    public void setDeviceId(@Nullable String value) {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_deviceId__u24lambda_u242 = editor$iv;
        boolean bl = false;
        $this$_set_deviceId__u24lambda_u242.putString(DEVICE_ID_KEY, value);
        editor$iv.apply();
    }

    @Override
    @NotNull
    public String[] getDeviceIdentifiers() {
        String[] stringArray;
        List ids;
        List list;
        String[] stringArray2;
        String string;
        String string2 = string = this.preferences.getString(DEVICE_IDENTIFIERS_KEY, null);
        if (string2 != null) {
            stringArray2 = new String[]{"|"};
            list = StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        } else {
            list = null;
        }
        List list2 = ids = list;
        boolean bl = list2 != null ? ((Collection)list2).size() == 3 : false;
        if (bl) {
            Collection $this$toTypedArray$iv = ids;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray2 = new String[]{"", "", ""};
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Override
    public void setDeviceIdentifiers(@NotNull String[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String idsString = ArraysKt.joinToString$default((Object[])value, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_deviceIdentifiers__u24lambda_u243 = editor$iv;
        boolean bl = false;
        $this$_set_deviceIdentifiers__u24lambda_u243.putString(DEVICE_IDENTIFIERS_KEY, idsString);
        editor$iv.apply();
    }

    @Override
    public boolean isNeedSync() {
        return this.preferences.getBoolean(NEED_RESTART_KEY, false);
    }

    @Override
    public void setNeedSync(boolean value) {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_isNeedSync__u24lambda_u244 = editor$iv;
        boolean bl = false;
        $this$_set_isNeedSync__u24lambda_u244.putBoolean(NEED_RESTART_KEY, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public FacebookInfo getFacebook() {
        String source = this.preferences.getString(FACEBOOK_KEY, null);
        Type type2 = new TypeToken<FacebookInfo>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (FacebookInfo)this.parser.fromJson(source, type2);
    }

    @Override
    public void setFacebook(@Nullable FacebookInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_facebook__u24lambda_u245 = editor$iv;
        boolean bl = false;
        $this$_set_facebook__u24lambda_u245.putString(FACEBOOK_KEY, source);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public String getFirebase() {
        return this.preferences.getString(FIREBASE_KEY, null);
    }

    @Override
    public void setFirebase(@Nullable String value) {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_firebase__u24lambda_u246 = editor$iv;
        boolean bl = false;
        $this$_set_firebase__u24lambda_u246.putString(FIREBASE_KEY, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public AppsflyerInfo getAppsflyer() {
        String source = this.preferences.getString(APPSFLYER_KEY, null);
        Type type2 = new TypeToken<AppsflyerInfo>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (AppsflyerInfo)this.parser.fromJson(source, type2);
    }

    @Override
    public void setAppsflyer(@Nullable AppsflyerInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_appsflyer__u24lambda_u247 = editor$iv;
        boolean bl = false;
        $this$_set_appsflyer__u24lambda_u247.putString(APPSFLYER_KEY, source);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public AdjustInfo getAdjust() {
        String source = this.preferences.getString(ADJUST_KEY, null);
        Type type2 = new TypeToken<AdjustInfo>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (AdjustInfo)this.parser.fromJson(source, type2);
    }

    @Override
    public void setAdjust(@Nullable AdjustInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_adjust__u24lambda_u248 = editor$iv;
        boolean bl = false;
        $this$_set_adjust__u24lambda_u248.putString(ADJUST_KEY, source);
        editor$iv.apply();
    }

    public final boolean needUpdateProductGroups() {
        long timestamp = this.preferences.getLong(GROUP_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        return currentTime >= timestamp;
    }

    @Override
    @Nullable
    public List<ApphudGroup> getProductGroups() {
        String source = this.preferences.getString(GROUP_KEY, null);
        Type type2 = new TypeToken<List<? extends ApphudGroup>>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (List)this.parser.fromJson(source, type2);
    }

    @Override
    public void setProductGroups(@Nullable List<ApphudGroup> value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_productGroups__u24lambda_u249 = editor$iv;
        boolean bl = false;
        $this$_set_productGroups__u24lambda_u249.putLong(GROUP_TIMESTAMP_KEY, System.currentTimeMillis());
        $this$_set_productGroups__u24lambda_u249.putString(GROUP_KEY, source);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public List<String> getProductDetails() {
        List list;
        long timestamp = this.preferences.getLong(SKU_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            String source = this.preferences.getString(SKU_KEY, null);
            Type type2 = new TypeToken<List<? extends String>>(){}.getType();
            Intrinsics.checkNotNull((Object)type2);
            list = (List)this.parser.fromJson(source, type2);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setProductDetails(@Nullable List<String> value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_productDetails__u24lambda_u2410 = editor$iv;
        boolean bl = false;
        $this$_set_productDetails__u24lambda_u2410.putLong(SKU_TIMESTAMP_KEY, System.currentTimeMillis());
        $this$_set_productDetails__u24lambda_u2410.putString(SKU_KEY, source);
        editor$iv.apply();
    }

    @Override
    public long getLastRegistration() {
        return this.preferences.getLong(LAST_REGISTRATION_KEY, 0L);
    }

    @Override
    public void setLastRegistration(long value) {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_lastRegistration__u24lambda_u2411 = editor$iv;
        boolean bl = false;
        $this$_set_lastRegistration__u24lambda_u2411.putLong(LAST_REGISTRATION_KEY, value);
        editor$iv.apply();
    }

    public final boolean updateUser(@NotNull ApphudUser apphudUser2) {
        Intrinsics.checkNotNullParameter((Object)apphudUser2, (String)"apphudUser");
        boolean userIdChanged = false;
        ApphudUser apphudUser3 = this.getApphudUser();
        if (apphudUser3 != null) {
            ApphudUser it = apphudUser3;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)apphudUser2.getUserId())) {
                userIdChanged = true;
            }
        }
        this.setApphudUser(apphudUser2);
        this.setUserId(apphudUser2.getUserId());
        return userIdChanged;
    }

    public final void clean() {
        this.setLastRegistration(0L);
        this.setApphudUser(null);
        this.setUserId(null);
        this.setDeviceId(null);
        String[] stringArray = new String[]{"", "", ""};
        this.setDeviceIdentifiers(stringArray);
        this.setNeedSync(false);
        this.setFacebook(null);
        this.setFirebase(null);
        this.setAppsflyer(null);
        this.setProductGroups(null);
        this.clearLegacyPaywallsCache();
        this.setProductDetails(null);
        this.setProperties(null);
        this.setAdjust(null);
    }

    public final boolean validateCaches() {
        String version = this.getCacheVersion();
        if (Intrinsics.areEqual((Object)version, (Object)"2")) {
            this.migratePaywallsToUser();
            this.setCacheVersion(CURRENT_CACHE_VERSION);
            return true;
        }
        CharSequence charSequence = version;
        if (charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)version, (Object)CURRENT_CACHE_VERSION)) {
            ApphudLog.INSTANCE.log("Invalid Cache Version. Clearing cached models.");
            this.setApphudUser(null);
            this.setProductGroups(null);
            this.clearLegacyPaywallsCache();
            this.setCacheVersion(CURRENT_CACHE_VERSION);
            return false;
        }
        return true;
    }

    private final void migratePaywallsToUser() {
        boolean needMigration;
        Collection collection2;
        ApphudUser apphudUser2 = this.getApphudUser();
        if (apphudUser2 == null) {
            SharedPreferencesStorage $this$migratePaywallsToUser_u24lambda_u2413 = this;
            boolean collection2 = false;
            $this$migratePaywallsToUser_u24lambda_u2413.clearLegacyPaywallsCache();
            return;
        }
        ApphudUser currentUser = apphudUser2;
        List<ApphudPaywall> legacyPaywalls = this.readLegacyPaywalls();
        List legacyPlacements = this.readLegacyPlacements();
        Collection $this$migratePaywallsToUser_u24lambda_u2413 = legacyPaywalls;
        if (($this$migratePaywallsToUser_u24lambda_u2413 == null || $this$migratePaywallsToUser_u24lambda_u2413.isEmpty()) && (($this$migratePaywallsToUser_u24lambda_u2413 = (Collection)legacyPlacements) == null || $this$migratePaywallsToUser_u24lambda_u2413.isEmpty())) {
            this.clearLegacyPaywallsCache();
            return;
        }
        boolean bl = currentUser.getPaywalls$sdk_release().isEmpty() && !((collection2 = (Collection)legacyPaywalls) == null || collection2.isEmpty()) ? true : (needMigration = false);
        if (needMigration) {
            List list = legacyPlacements;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            ApphudUser migratedUser = ApphudUser.copy$default(currentUser, null, null, null, null, null, legacyPaywalls, list, null, 159, null);
            this.setApphudUser(migratedUser);
            ApphudLog.INSTANCE.log("Migrated paywalls/placements to ApphudUser");
        }
        this.clearLegacyPaywallsCache();
    }

    private final List<ApphudPaywall> readLegacyPaywalls() {
        String string = this.preferences.getString(PAYWALLS_KEY, null);
        if (string == null) {
            return null;
        }
        String source = string;
        Type type2 = new TypeToken<List<? extends ApphudPaywall>>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (List)this.parser.fromJson(source, type2);
    }

    private final List<ApphudPlacement> readLegacyPlacements() {
        String string = this.preferences.getString(PLACEMENTS_KEY, null);
        if (string == null) {
            return null;
        }
        String source = string;
        Type type2 = new TypeToken<List<? extends ApphudPlacement>>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (List)this.parser.fromJson(source, type2);
    }

    private final void clearLegacyPaywallsCache() {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$clearLegacyPaywallsCache_u24lambda_u2414 = editor$iv;
        boolean bl = false;
        $this$clearLegacyPaywallsCache_u24lambda_u2414.remove(PAYWALLS_KEY);
        $this$clearLegacyPaywallsCache_u24lambda_u2414.remove(PAYWALLS_TIMESTAMP_KEY);
        $this$clearLegacyPaywallsCache_u24lambda_u2414.remove(PLACEMENTS_KEY);
        $this$clearLegacyPaywallsCache_u24lambda_u2414.remove(PLACEMENTS_TIMESTAMP_KEY);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public String getCacheVersion() {
        return this.preferences.getString("APPHUD_CACHE_VERSION", null);
    }

    @Override
    public void setCacheVersion(@Nullable String value) {
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_cacheVersion__u24lambda_u2415 = editor$iv;
        boolean bl = false;
        $this$_set_cacheVersion__u24lambda_u2415.putString("APPHUD_CACHE_VERSION", value);
        editor$iv.apply();
    }

    public final boolean cacheExpired() {
        boolean expired;
        long expirationTime = this.getLastRegistration() + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        boolean bl = expired = currentTime > expirationTime;
        if (expired) {
            ApphudLog.INSTANCE.logI("Cached ApphudUser found, but cache expired");
        } else {
            ApphudLog.INSTANCE.logI("Using cached ApphudUser");
        }
        return expired;
    }

    @Override
    @Nullable
    public HashMap<String, ApphudUserProperty> getProperties() {
        String source = this.preferences.getString(PROPERTIES_KEY, null);
        Type type2 = new TypeToken<HashMap<String, ApphudUserProperty>>(){}.getType();
        Intrinsics.checkNotNull((Object)type2);
        return (HashMap)this.parser.fromJson(source, type2);
    }

    @Override
    public void setProperties(@Nullable HashMap<String, ApphudUserProperty> value) {
        String source = this.parser.toJson(value);
        SharedPreferences $this$edit_u24default$iv = this.preferences;
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$_set_properties__u24lambda_u2416 = editor$iv;
        boolean bl = false;
        $this$_set_properties__u24lambda_u2416.putString(PROPERTIES_KEY, source);
        editor$iv.apply();
    }

    public final boolean needSendProperty(@NotNull ApphudUserProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        HashMap<String, ApphudUserProperty> hashMap = this.getProperties();
        if (hashMap == null) {
            hashMap = new HashMap<String, ApphudUserProperty>();
        }
        HashMap<String, ApphudUserProperty> currentProperties = hashMap;
        ApphudUserProperty existingProperty = (ApphudUserProperty)currentProperties.get(property.getKey());
        if (property.getValue() == null) {
            if (existingProperty == null) {
                return false;
            }
            currentProperties.remove(property.getKey());
            this.setProperties(currentProperties);
            return true;
        }
        if (property.getIncrement()) {
            if (existingProperty != null) {
                if (existingProperty.getSetOnce()) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. The property was previously specified as not updatable";
                    ApphudLog.INSTANCE.logI(message);
                    return false;
                }
                currentProperties.remove(property.getKey());
                this.setProperties(currentProperties);
            }
            return true;
        }
        if (existingProperty != null) {
            if (existingProperty.getSetOnce()) {
                String message = "Sending a property with key '" + property.getKey() + "' is skipped. The property was previously specified as not updatable";
                ApphudLog.INSTANCE.logI(message);
                return false;
            }
            if (Intrinsics.areEqual((Object)existingProperty.getValue$sdk_release(), (Object)property.getValue$sdk_release())) {
                String message = "Sending a property with key '" + property.getKey() + "' is skipped. Property value was not changed";
                ApphudLog.INSTANCE.logI(message);
                return false;
            }
        }
        ((Map)currentProperties).put(property.getKey(), property);
        this.setProperties(currentProperties);
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage$Companion;", "", "<init>", "()V", "NAME", "", "USER_ID_KEY", "APPHUD_USER_KEY", "DEVICE_ID_KEY", "DEVICE_IDENTIFIERS_KEY", "NEED_RESTART_KEY", "PROPERTIES_KEY", "FACEBOOK_KEY", "FIREBASE_KEY", "APPSFLYER_KEY", "ADJUST_KEY", "PAYWALLS_KEY", "PAYWALLS_TIMESTAMP_KEY", "PLACEMENTS_KEY", "PLACEMENTS_TIMESTAMP_KEY", "GROUP_KEY", "GROUP_TIMESTAMP_KEY", "SKU_KEY", "SKU_TIMESTAMP_KEY", "LAST_REGISTRATION_KEY", "CURRENT_CACHE_VERSION", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

