/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data.network;

import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUtils;
import com.apphud.sdk.internal.data.network.PrettyJsonFormatter;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apphud/sdk/internal/data/network/PrettyHttpLoggingInterceptor;", "Lokhttp3/Interceptor;", "prettyJsonFormatter", "Lcom/apphud/sdk/internal/data/network/PrettyJsonFormatter;", "<init>", "(Lcom/apphud/sdk/internal/data/network/PrettyJsonFormatter;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "logRequestStart", "", "request", "Lokhttp3/Request;", "traceId", "", "logResponse", "response", "sdk_release"})
public final class PrettyHttpLoggingInterceptor
implements Interceptor {
    @NotNull
    private final PrettyJsonFormatter prettyJsonFormatter;

    public PrettyHttpLoggingInterceptor(@NotNull PrettyJsonFormatter prettyJsonFormatter) {
        Intrinsics.checkNotNullParameter((Object)prettyJsonFormatter, (String)"prettyJsonFormatter");
        this.prettyJsonFormatter = prettyJsonFormatter;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        if (!ApphudUtils.INSTANCE.getHttpLogging()) {
            return chain.proceed(request);
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String traceId = StringsKt.take((String)string, (int)8);
        this.logRequestStart(request, traceId);
        Response response = chain.proceed(request);
        return this.logResponse(request, response, traceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logRequestStart(Request request, String traceId) {
        String prettyBody;
        String string;
        String method = request.method();
        HttpUrl url = request.url();
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            Closeable closeable = (Closeable)new Buffer();
            Throwable throwable = null;
            try {
                Buffer buffer = (Buffer)closeable;
                boolean bl = false;
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                String string2 = buffer.readString(charset);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string = null;
        }
        String bodyString = string;
        String string3 = prettyBody = this.prettyJsonFormatter.format(bodyString);
        Object bodyPart = string3 != null ? " with params:\n" + string3 : "";
        ApphudLog.INSTANCE.logI("[" + traceId + "] Start " + method + " request " + url + (String)bodyPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response logResponse(Request request, Response response, String traceId) {
        String prettyBody;
        String string;
        BufferedSource bufferedSource;
        BufferedSource source;
        ResponseBody responseBody;
        String method = request.method();
        HttpUrl url = request.url();
        int code = response.code();
        ResponseBody responseBody2 = responseBody = response.body();
        BufferedSource bufferedSource2 = source = responseBody2 != null ? responseBody2.source() : null;
        if (bufferedSource2 != null) {
            bufferedSource2.request(Long.MAX_VALUE);
        }
        if ((bufferedSource = source) != null && (bufferedSource = bufferedSource.getBuffer()) != null && (bufferedSource = bufferedSource.clone()) != null) {
            Closeable closeable = (Closeable)bufferedSource;
            Throwable throwable = null;
            try {
                Buffer clonedBuffer = (Buffer)closeable;
                boolean bl = false;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                String string2 = clonedBuffer.readString(charset);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string = null;
        }
        String bodyString = string;
        String string3 = prettyBody = this.prettyJsonFormatter.format(bodyString);
        Object bodyPart = string3 != null ? "\n" + string3 : "";
        ApphudLog.INSTANCE.logI("[" + traceId + "] Finished " + method + " request " + url + " with response: " + code + (String)bodyPart);
        return response;
    }
}

