/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data;

import com.apphud.sdk.domain.ApphudUser;
import com.apphud.sdk.storage.SharedPreferencesStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apphud/sdk/internal/data/UserDataSource;", "", "storage", "Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "<init>", "(Lcom/apphud/sdk/storage/SharedPreferencesStorage;)V", "getCachedUser", "Lcom/apphud/sdk/domain/ApphudUser;", "saveUser", "", "user", "clearUser", "", "getUserId", "", "saveUserId", "userId", "getDeviceId", "saveDeviceId", "deviceId", "isCacheExpired", "updateLastRegistrationTime", "timestamp", "", "sdk_release"})
public final class UserDataSource {
    @NotNull
    private final SharedPreferencesStorage storage;

    public UserDataSource(@NotNull SharedPreferencesStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    @Nullable
    public final ApphudUser getCachedUser() {
        return this.storage.getApphudUser();
    }

    public final boolean saveUser(@NotNull ApphudUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return this.storage.updateUser(user);
    }

    public final void clearUser() {
        this.storage.setApphudUser(null);
        this.storage.setUserId(null);
    }

    @Nullable
    public final String getUserId() {
        return this.storage.getUserId();
    }

    public final void saveUserId(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.storage.setUserId(userId);
    }

    @Nullable
    public final String getDeviceId() {
        return this.storage.getDeviceId();
    }

    public final void saveDeviceId(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.storage.setDeviceId(deviceId);
    }

    public final boolean isCacheExpired() {
        return this.storage.cacheExpired();
    }

    public final void updateLastRegistrationTime(long timestamp) {
        this.storage.setLastRegistration(timestamp);
    }
}

