/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.presentation.figma;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import com.apphud.sdk.Apphud;
import com.apphud.sdk.ApphudError;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudPurchaseResult;
import com.apphud.sdk.ApphudPurchasesRestoreResult;
import com.apphud.sdk.ApphudRuleCallback;
import com.apphud.sdk.domain.ApphudNonRenewingPurchase;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.ApphudPaywallScreen;
import com.apphud.sdk.domain.ApphudPaywallScreenShowResult;
import com.apphud.sdk.domain.ApphudProduct;
import com.apphud.sdk.domain.ApphudSubscription;
import com.apphud.sdk.domain.PaywallEvent;
import com.apphud.sdk.internal.PaywallEventManager;
import com.apphud.sdk.internal.ServiceLocator;
import com.apphud.sdk.internal.data.local.PaywallRepository;
import com.apphud.sdk.internal.presentation.figma.WebViewEvent;
import com.apphud.sdk.internal.presentation.figma.WebViewState;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 92\u00020\u0001:\u00019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010\u001e\u001a\u00020\u0019J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0019J\u000e\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0019J\u000e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001cJ\b\u0010,\u001a\u0004\u0018\u00010\u001cJ\b\u0010-\u001a\u00020\u0019H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u001c2\u0006\u0010/\u001a\u000200H\u0002J\u0014\u00101\u001a\u0004\u0018\u00010\u001c2\b\u00102\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006:"}, d2={"Lcom/apphud/sdk/internal/presentation/figma/FigmaViewViewModel;", "Landroidx/lifecycle/ViewModel;", "paywallRepository", "Lcom/apphud/sdk/internal/data/local/PaywallRepository;", "ruleCallback", "Lcom/apphud/sdk/ApphudRuleCallback;", "eventManager", "Lcom/apphud/sdk/internal/PaywallEventManager;", "<init>", "(Lcom/apphud/sdk/internal/data/local/PaywallRepository;Lcom/apphud/sdk/ApphudRuleCallback;Lcom/apphud/sdk/internal/PaywallEventManager;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/apphud/sdk/internal/presentation/figma/WebViewState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "_events", "Lkotlinx/coroutines/channels/Channel;", "Lcom/apphud/sdk/internal/presentation/figma/WebViewEvent;", "events", "Lkotlinx/coroutines/flow/Flow;", "getEvents", "()Lkotlinx/coroutines/flow/Flow;", "onCleared", "", "init", "ruleId", "", "renderItemsJson", "processDismiss", "processPurchase", "product", "Lcom/apphud/sdk/domain/ApphudProduct;", "onPurchaseResult", "result", "Lcom/apphud/sdk/ApphudPurchaseResult;", "processRestore", "processPurchaseByIndex", "index", "", "processBackPressed", "processWebViewError", "errorMessage", "getCurrentRenderItemsJson", "hidePurchaseLoader", "getUrlForPaywall", "paywall", "Lcom/apphud/sdk/domain/ApphudPaywall;", "addLiveParameter", "url", "loadContent", "emitPaywallEvent", "event", "Lcom/apphud/sdk/domain/PaywallEvent;", "emitTransactionCompleted", "purchaseResult", "Companion", "sdk_release"})
public final class FigmaViewViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaywallRepository paywallRepository;
    @NotNull
    private final ApphudRuleCallback ruleCallback;
    @NotNull
    private final PaywallEventManager eventManager;
    @NotNull
    private final MutableStateFlow<WebViewState> _state;
    @NotNull
    private final StateFlow<WebViewState> state;
    @NotNull
    private final Channel<WebViewEvent> _events;
    @NotNull
    private final Flow<WebViewEvent> events;
    @NotNull
    private static final ViewModelProvider.Factory factory = new ViewModelProvider.Factory(){

        public <T extends ViewModel> T create(Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            ServiceLocator serviceLocator = ServiceLocator.Companion.getInstance();
            return (T)((Object)new FigmaViewViewModel(serviceLocator.getPaywallRepository(), serviceLocator.getRuleCallback(), serviceLocator.getPaywallEventManager()));
        }
    };

    public FigmaViewViewModel(@NotNull PaywallRepository paywallRepository, @NotNull ApphudRuleCallback ruleCallback, @NotNull PaywallEventManager eventManager) {
        Intrinsics.checkNotNullParameter((Object)paywallRepository, (String)"paywallRepository");
        Intrinsics.checkNotNullParameter((Object)ruleCallback, (String)"ruleCallback");
        Intrinsics.checkNotNullParameter((Object)eventManager, (String)"eventManager");
        this.paywallRepository = paywallRepository;
        this.ruleCallback = ruleCallback;
        this.eventManager = eventManager;
        this._state = StateFlowKt.MutableStateFlow((Object)WebViewState.Loading.INSTANCE);
        this.state = (StateFlow)this._state;
        this._events = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        this.events = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._events));
        this.eventManager.activate();
    }

    @NotNull
    public final StateFlow<WebViewState> getState() {
        return this.state;
    }

    @NotNull
    public final Flow<WebViewEvent> getEvents() {
        return this.events;
    }

    protected void onCleared() {
        super.onCleared();
        this.eventManager.deactivate();
    }

    public final void init(@Nullable String ruleId, @Nullable String renderItemsJson) {
        ApphudLog.INSTANCE.log("[WebViewViewModel] Initializing with ruleId: " + ruleId);
        if (ruleId == null) {
            ApphudLog.INSTANCE.logE("[WebViewViewModel] Rule ID is null");
            this._state.setValue((Object)WebViewState.Error.INSTANCE);
            ApphudError error = new ApphudError("Rule ID is null", null, null, null, 14, null);
            this.emitPaywallEvent(new PaywallEvent.ScreenError(error));
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ FigmaViewViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        if (renderItemsJson == null) {
            ApphudLog.INSTANCE.logE("[WebViewViewModel] renderItemsJson is null");
            this._state.setValue((Object)WebViewState.Error.INSTANCE);
            ApphudError error = new ApphudError("renderItemsJson is null", null, null, null, 14, null);
            this.emitPaywallEvent(new PaywallEvent.ScreenError(error));
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ FigmaViewViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        WebViewState currentState = (WebViewState)this._state.getValue();
        WebViewState webViewState = currentState;
        if (webViewState instanceof WebViewState.Content ? Intrinsics.areEqual((Object)((WebViewState.Content)currentState).getPaywall().getIdentifier(), (Object)ruleId) && Intrinsics.areEqual((Object)((WebViewState.Content)currentState).getRenderItemsJson(), (Object)renderItemsJson) : webViewState instanceof WebViewState.ContentWithPurchaseLoading && Intrinsics.areEqual((Object)((WebViewState.ContentWithPurchaseLoading)currentState).getPaywall().getIdentifier(), (Object)ruleId) && Intrinsics.areEqual((Object)((WebViewState.ContentWithPurchaseLoading)currentState).getRenderItemsJson(), (Object)renderItemsJson)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ruleId, renderItemsJson, null){
            int label;
            final /* synthetic */ FigmaViewViewModel this$0;
            final /* synthetic */ String $ruleId;
            final /* synthetic */ String $renderItemsJson;
            {
                this.this$0 = $receiver;
                this.$ruleId = $ruleId;
                this.$renderItemsJson = $renderItemsJson;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        ResultKt.throwOnFailure((Object)object);
                        Object object4 = FigmaViewViewModel.access$getPaywallRepository$p(this.this$0).getPaywallById-IoAF18A(this.$ruleId);
                        FigmaViewViewModel figmaViewViewModel = this.this$0;
                        String string = this.$renderItemsJson;
                        FigmaViewViewModel figmaViewViewModel2 = this.this$0;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
                        if (throwable == null) {
                            ApphudPaywall paywall = (ApphudPaywall)object4;
                            boolean bl = false;
                            ApphudLog.INSTANCE.log("[WebViewViewModel] Paywall found: " + paywall.getName());
                            FigmaViewViewModel.access$loadContent(figmaViewViewModel, paywall, string);
                            return Unit.INSTANCE;
                        } else {
                            Throwable error = throwable;
                            boolean bl = false;
                            ApphudLog.INSTANCE.logE("[WebViewViewModel] Paywall not found or error: " + error.getMessage());
                            FigmaViewViewModel.access$get_state$p(figmaViewViewModel2).setValue((Object)WebViewState.Error.INSTANCE);
                            ApphudError apphudError = new ApphudError("Paywall not found: " + error.getMessage(), null, null, null, 14, null);
                            FigmaViewViewModel.access$emitPaywallEvent(figmaViewViewModel2, new PaywallEvent.ScreenError(apphudError));
                            this.label = 1;
                            object3 = FigmaViewViewModel.access$get_events$p(figmaViewViewModel2).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void processDismiss() {
        this.emitPaywallEvent(PaywallEvent.CloseButtonTapped.INSTANCE);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FigmaViewViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void processPurchase(ApphudProduct product) {
        WebViewState currentState = (WebViewState)this._state.getValue();
        if (!(currentState instanceof WebViewState.Content)) {
            return;
        }
        this._state.setValue((Object)new WebViewState.ContentWithPurchaseLoading(((WebViewState.Content)currentState).getPaywall(), ((WebViewState.Content)currentState).getRenderItemsJson(), ((WebViewState.Content)currentState).getUrl()));
        this.emitPaywallEvent(new PaywallEvent.TransactionStarted(product));
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, product, null){
            int label;
            final /* synthetic */ FigmaViewViewModel this$0;
            final /* synthetic */ ApphudProduct $product;
            {
                this.this$0 = $receiver;
                this.$product = $product;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)new WebViewEvent.StartPurchase(this.$product), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onPurchaseResult(@NotNull ApphudPurchaseResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, null){
            int label;
            final /* synthetic */ FigmaViewViewModel this$0;
            final /* synthetic */ ApphudPurchaseResult $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WebViewState currentState = (WebViewState)FigmaViewViewModel.access$get_state$p(this.this$0).getValue();
                        if (!(currentState instanceof WebViewState.ContentWithPurchaseLoading)) {
                            ApphudLog.INSTANCE.logE("[WebViewViewModel] onPurchaseResult called but not in purchase loading state");
                            return Unit.INSTANCE;
                        }
                        if (this.$result.getError() != null) {
                            ApphudLog.INSTANCE.logE("[WebViewViewModel] Purchase failed: " + this.$result.getError());
                            FigmaViewViewModel.access$hidePurchaseLoader(this.this$0);
                            FigmaViewViewModel.access$emitTransactionCompleted(this.this$0, this.$result);
                            return Unit.INSTANCE;
                        }
                        ApphudLog.INSTANCE.log("[WebViewViewModel] Purchase successful");
                        FigmaViewViewModel.access$emitTransactionCompleted(this.this$0, this.$result);
                        this.label = 1;
                        Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.PurchaseCompleted.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void processRestore() {
        ApphudLog.INSTANCE.log("[WebViewViewModel] Starting restore purchases");
        this.emitPaywallEvent(new PaywallEvent.TransactionStarted(null));
        Apphud.INSTANCE.restorePurchases((Function1<? super ApphudPurchasesRestoreResult, Unit>)((Function1)arg_0 -> FigmaViewViewModel.processRestore$lambda$0(this, arg_0)));
    }

    public final void processPurchaseByIndex(int index) {
        ApphudLog.INSTANCE.log("[WebViewViewModel] Processing purchase for index: " + index);
        WebViewState currentState = (WebViewState)this._state.getValue();
        if (currentState instanceof WebViewState.Content) {
            List<ApphudProduct> products = ((WebViewState.Content)currentState).getPaywall().getProducts();
            if (products != null && index >= 0 && index < products.size()) {
                ApphudProduct product = products.get(index);
                String productId = product.getProductId();
                ApphudLog.INSTANCE.log("[WebViewViewModel] Purchasing product: " + productId);
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ FigmaViewViewModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.ShowPurchaseLoader.INSTANCE, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                this.processPurchase(product);
                v0 = Unit.INSTANCE;
            } else {
                List<ApphudProduct> list = products;
                ApphudLog.INSTANCE.logE("[WebViewViewModel] Invalid product index: " + index + ", products size: " + (list != null ? list.size() : 0));
                List<ApphudProduct> list2 = products;
                ApphudError error = new ApphudError("Invalid product index: " + index + ", products size: " + (list2 != null ? list2.size() : 0), null, null, null, 14, null);
                this.emitPaywallEvent(new PaywallEvent.ScreenError(error));
                v0 = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ FigmaViewViewModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.InvalidPurchaseIndex.INSTANCE, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        } else {
            ApphudLog.INSTANCE.logE("[WebViewViewModel] Cannot process purchase - invalid state: " + currentState);
            ApphudError error = new ApphudError("Cannot process purchase - invalid state: " + currentState, null, null, null, 14, null);
            this.emitPaywallEvent(new PaywallEvent.ScreenError(error));
            v0 = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ FigmaViewViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.InvalidPurchaseIndex.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void processBackPressed() {
        WebViewState currentState = (WebViewState)this._state.getValue();
        if (currentState instanceof WebViewState.ContentWithPurchaseLoading) {
            return;
        }
        this.emitPaywallEvent(PaywallEvent.CloseButtonTapped.INSTANCE);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FigmaViewViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void processWebViewError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        ApphudLog.INSTANCE.logE("[WebViewViewModel] WebView load error: " + errorMessage);
        this._state.setValue((Object)WebViewState.WebViewLoadError.INSTANCE);
        ApphudError error = new ApphudError("WebView load error: " + errorMessage, null, null, null, 14, null);
        this.emitPaywallEvent(new PaywallEvent.ScreenError(error));
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FigmaViewViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final String getCurrentRenderItemsJson() {
        WebViewState currentState = (WebViewState)this._state.getValue();
        WebViewState webViewState = currentState;
        return webViewState instanceof WebViewState.Content ? ((WebViewState.Content)currentState).getRenderItemsJson() : (webViewState instanceof WebViewState.ContentWithPurchaseLoading ? ((WebViewState.ContentWithPurchaseLoading)currentState).getRenderItemsJson() : null);
    }

    private final void hidePurchaseLoader() {
        WebViewState currentState = (WebViewState)this._state.getValue();
        if (currentState instanceof WebViewState.ContentWithPurchaseLoading) {
            this._state.setValue((Object)new WebViewState.Content(((WebViewState.ContentWithPurchaseLoading)currentState).getPaywall(), ((WebViewState.ContentWithPurchaseLoading)currentState).getRenderItemsJson(), ((WebViewState.ContentWithPurchaseLoading)currentState).getUrl()));
        }
    }

    private final String getUrlForPaywall(ApphudPaywall paywall) {
        Object object = paywall.getScreen();
        if (object == null || (object = ((ApphudPaywallScreen)object).getUrls()) == null) {
            ApphudPaywallScreen apphudPaywallScreen = paywall.getScreen();
            return this.addLiveParameter(apphudPaywallScreen != null ? apphudPaywallScreen.getDefaultUrl() : null);
        }
        Object urls = object;
        if (urls.isEmpty()) {
            return this.addLiveParameter(paywall.getScreen().getDefaultUrl());
        }
        String currentLocale = Locale.getDefault().getLanguage();
        ApphudLog.INSTANCE.log("[WebViewViewModel] Current locale: " + currentLocale);
        String urlByLocale = (String)urls.get(currentLocale);
        if (urlByLocale != null) {
            ApphudLog.INSTANCE.log("[WebViewViewModel] Found URL for locale " + currentLocale + ": " + urlByLocale);
            return this.addLiveParameter(urlByLocale);
        }
        String englishUrl = (String)urls.get("en");
        if (englishUrl != null) {
            ApphudLog.INSTANCE.log("[WebViewViewModel] Using English fallback URL: " + englishUrl);
            return this.addLiveParameter(englishUrl);
        }
        String firstUrl = (String)CollectionsKt.firstOrNull((Iterable)urls.values());
        if (firstUrl != null) {
            ApphudLog.INSTANCE.log("[WebViewViewModel] Using first available URL: " + firstUrl);
            return this.addLiveParameter(firstUrl);
        }
        String defaultUrl = paywall.getScreen().getDefaultUrl();
        ApphudLog.INSTANCE.log("[WebViewViewModel] Using default URL: " + defaultUrl);
        return this.addLiveParameter(defaultUrl);
    }

    private final String addLiveParameter(String url) {
        if (url == null) {
            return null;
        }
        return StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null) ? url + "&live=true" : url + "?live=true";
    }

    private final void loadContent(ApphudPaywall paywall, String renderItemsJson) {
        ApphudLog.INSTANCE.log("[WebViewViewModel] Loading content for paywall: " + paywall.getName());
        String url = this.getUrlForPaywall(paywall);
        if (url == null) {
            ApphudLog.INSTANCE.logE("[WebViewViewModel] No URL found for paywall: " + paywall.getIdentifier());
            this._state.setValue((Object)WebViewState.Error.INSTANCE);
            ApphudError error = new ApphudError("No URL found for paywall: " + paywall.getIdentifier(), null, null, null, 14, null);
            this.emitPaywallEvent(new PaywallEvent.ScreenError(error));
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ FigmaViewViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)WebViewEvent.CloseScreen.INSTANCE, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        this._state.setValue((Object)new WebViewState.Content(paywall, renderItemsJson, url));
        this.emitPaywallEvent(PaywallEvent.ScreenShown.INSTANCE);
    }

    private final void emitPaywallEvent(PaywallEvent event) {
        this.eventManager.emitEvent(event);
    }

    private final void emitTransactionCompleted(ApphudPurchaseResult purchaseResult) {
        ApphudPaywallScreenShowResult apphudPaywallScreenShowResult;
        if (purchaseResult.getError() != null) {
            ApphudError apphudError = purchaseResult.getError();
            if (apphudError == null) {
                apphudError = new ApphudError("Unknown purchase error", null, null, null, 14, null);
            }
            apphudPaywallScreenShowResult = new ApphudPaywallScreenShowResult.TransactionError(apphudError);
        } else {
            apphudPaywallScreenShowResult = purchaseResult.getSubscription() != null ? (ApphudPaywallScreenShowResult)new ApphudPaywallScreenShowResult.SubscriptionResult(purchaseResult.getSubscription(), purchaseResult.getPurchase()) : (purchaseResult.getNonRenewingPurchase() != null ? (ApphudPaywallScreenShowResult)new ApphudPaywallScreenShowResult.NonRenewingResult(purchaseResult.getNonRenewingPurchase(), purchaseResult.getPurchase()) : (ApphudPaywallScreenShowResult)new ApphudPaywallScreenShowResult.TransactionError(new ApphudError("Unknown purchase error", null, null, null, 14, null)));
        }
        ApphudPaywallScreenShowResult paywallResult = apphudPaywallScreenShowResult;
        this.emitPaywallEvent(new PaywallEvent.TransactionCompleted(paywallResult));
    }

    private static final Unit processRestore$lambda$0(FigmaViewViewModel this$0, ApphudPurchasesRestoreResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(result, this$0, null){
            int label;
            final /* synthetic */ ApphudPurchasesRestoreResult $result;
            final /* synthetic */ FigmaViewViewModel this$0;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                block10: {
                    block11: {
                        void $result;
                        ApphudPurchasesRestoreResult apphudPurchasesRestoreResult;
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                apphudPurchasesRestoreResult = this.$result;
                                if (!(apphudPurchasesRestoreResult instanceof ApphudPurchasesRestoreResult.Success)) break;
                                ApphudLog.INSTANCE.log("[WebViewViewModel] Restore successful: " + ((ApphudPurchasesRestoreResult.Success)this.$result).getSubscriptions().size() + " subscriptions, " + ((ApphudPurchasesRestoreResult.Success)this.$result).getPurchases().size() + " purchases");
                                if (!((Collection)((ApphudPurchasesRestoreResult.Success)this.$result).getSubscriptions()).isEmpty()) {
                                    ApphudPaywallScreenShowResult.SubscriptionResult subscriptionResult = new ApphudPaywallScreenShowResult.SubscriptionResult((ApphudSubscription)CollectionsKt.firstOrNull(((ApphudPurchasesRestoreResult.Success)this.$result).getSubscriptions()), null);
                                    FigmaViewViewModel.access$emitPaywallEvent(this.this$0, new PaywallEvent.TransactionCompleted(subscriptionResult));
                                }
                                if (!((Collection)((ApphudPurchasesRestoreResult.Success)this.$result).getPurchases()).isEmpty()) {
                                    ApphudPaywallScreenShowResult.NonRenewingResult nonRenewingResult = new ApphudPaywallScreenShowResult.NonRenewingResult((ApphudNonRenewingPurchase)CollectionsKt.firstOrNull(((ApphudPurchasesRestoreResult.Success)this.$result).getPurchases()), null);
                                    FigmaViewViewModel.access$emitPaywallEvent(this.this$0, new PaywallEvent.TransactionCompleted(nonRenewingResult));
                                }
                                if (((ApphudPurchasesRestoreResult.Success)this.$result).getSubscriptions().isEmpty() && ((ApphudPurchasesRestoreResult.Success)this.$result).getPurchases().isEmpty()) {
                                    ApphudPaywallScreenShowResult.SubscriptionResult emptyResult = new ApphudPaywallScreenShowResult.SubscriptionResult(null, null);
                                    FigmaViewViewModel.access$emitPaywallEvent(this.this$0, new PaywallEvent.TransactionCompleted(emptyResult));
                                }
                                this.label = 1;
                                Object object3 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)new WebViewEvent.RestoreCompleted(true, "Purchases restored successfully"), (Continuation)this);
                                if (object3 == object2) {
                                    return object2;
                                }
                                break block10;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                break block10;
                            }
                        }
                        if (!(apphudPurchasesRestoreResult instanceof ApphudPurchasesRestoreResult.Error)) break block11;
                        ApphudLog.INSTANCE.logE("[WebViewViewModel] Restore failed: " + ((ApphudPurchasesRestoreResult.Error)this.$result).getError().getMessage());
                        ApphudPaywallScreenShowResult.TransactionError paywallResult = new ApphudPaywallScreenShowResult.TransactionError(((ApphudPurchasesRestoreResult.Error)this.$result).getError());
                        FigmaViewViewModel.access$emitPaywallEvent(this.this$0, new PaywallEvent.TransactionCompleted(paywallResult));
                        this.label = 2;
                        Object object4 = FigmaViewViewModel.access$get_events$p(this.this$0).send((Object)new WebViewEvent.RestoreCompleted(false, "Failed to restore purchases"), (Continuation)this);
                        if (object4 == object2) {
                            return object2;
                        }
                        break block10;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object4 = $result;
                                break block10;
                            }
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Channel access$get_events$p(FigmaViewViewModel $this) {
        return $this._events;
    }

    public static final /* synthetic */ PaywallRepository access$getPaywallRepository$p(FigmaViewViewModel $this) {
        return $this.paywallRepository;
    }

    public static final /* synthetic */ void access$loadContent(FigmaViewViewModel $this, ApphudPaywall paywall, String renderItemsJson) {
        $this.loadContent(paywall, renderItemsJson);
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(FigmaViewViewModel $this) {
        return $this._state;
    }

    public static final /* synthetic */ void access$emitPaywallEvent(FigmaViewViewModel $this, PaywallEvent event) {
        $this.emitPaywallEvent(event);
    }

    public static final /* synthetic */ void access$hidePurchaseLoader(FigmaViewViewModel $this) {
        $this.hidePurchaseLoader();
    }

    public static final /* synthetic */ void access$emitTransactionCompleted(FigmaViewViewModel $this, ApphudPurchaseResult purchaseResult) {
        $this.emitTransactionCompleted(purchaseResult);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/apphud/sdk/internal/presentation/figma/FigmaViewViewModel$Companion;", "", "<init>", "()V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "getFactory", "()Landroidx/lifecycle/ViewModelProvider$Factory;", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ViewModelProvider.Factory getFactory() {
            return factory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

