/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data.network;

import android.util.Log;
import com.apphud.sdk.internal.data.network.UrlProvider;
import java.io.Closeable;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apphud/sdk/internal/data/network/HostSwitcherInterceptor;", "Lokhttp3/Interceptor;", "dummyOkHttpClient", "Lokhttp3/OkHttpClient;", "urlProvider", "Lcom/apphud/sdk/internal/data/network/UrlProvider;", "<init>", "(Lokhttp3/OkHttpClient;Lcom/apphud/sdk/internal/data/network/UrlProvider;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "tryFallbackHost", "originalException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getFallbackHost", "", "Companion", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nHostSwitcherInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostSwitcherInterceptor.kt\ncom/apphud/sdk/internal/data/network/HostSwitcherInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class HostSwitcherInterceptor
implements Interceptor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient dummyOkHttpClient;
    @NotNull
    private final UrlProvider urlProvider;
    @Deprecated
    @NotNull
    public static final String FALLBACK_HOST_URL = "https://apphud.blob.core.windows.net/apphud-gateway/fallback.txt";

    public HostSwitcherInterceptor(@NotNull OkHttpClient dummyOkHttpClient, @NotNull UrlProvider urlProvider) {
        Intrinsics.checkNotNullParameter((Object)dummyOkHttpClient, (String)"dummyOkHttpClient");
        Intrinsics.checkNotNullParameter((Object)urlProvider, (String)"urlProvider");
        this.dummyOkHttpClient = dummyOkHttpClient;
        this.urlProvider = urlProvider;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        try {
            response = chain.proceed(request);
        }
        catch (UnknownHostException e) {
            response = this.tryFallbackHost(chain, e);
        }
        catch (SocketTimeoutException e) {
            response = this.tryFallbackHost(chain, e);
        }
        return response;
    }

    private final Response tryFallbackHost(Interceptor.Chain chain, Exception originalException) {
        String newHost = ((Object)StringsKt.trim((CharSequence)this.getFallbackHost())).toString();
        String newHostWithoutScheme = StringsKt.removePrefix((String)newHost, (CharSequence)"https://");
        String chainHost = chain.request().url().host();
        if (Intrinsics.areEqual((Object)chainHost, (Object)newHostWithoutScheme)) {
            if (originalException != null) {
                Exception it = originalException;
                boolean bl = false;
                throw it;
            }
            throw new IllegalStateException("Fallback host also failed".toString());
        }
        Log.e((String)"ApphudLogs", (String)("Exception " + originalException + ", url: " + chain.request().url()));
        HttpUrl originalUrl = chain.request().url();
        HttpUrl newUrl = originalUrl.newBuilder().host(newHostWithoutScheme).build();
        Request newRequest = chain.request().newBuilder().url(newUrl).build();
        Response response = chain.proceed(newRequest);
        if (response.isSuccessful()) {
            Log.d((String)"ApphudLogs", (String)("Switching to fallback host: " + newHost));
            this.urlProvider.updateBaseUrl(newHost);
        } else {
            Log.d((String)"ApphudLogs", (String)("Do not switch to fallback host " + newHost));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFallbackHost() {
        Closeable closeable = (Closeable)this.dummyOkHttpClient.newCall(new Request.Builder().url(FALLBACK_HOST_URL).build()).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new IllegalStateException("Get fallback hosts error: empty body".toString());
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/apphud/sdk/internal/data/network/HostSwitcherInterceptor$Companion;", "", "<init>", "()V", "FALLBACK_HOST_URL", "", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

