/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.managers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/apphud/sdk/managers/AdvertisingIdManager;", "", "<init>", "()V", "getAdvertisingIdInfo", "Lcom/apphud/sdk/managers/AdvertisingIdManager$AdInfo;", "context", "Landroid/content/Context;", "AdInfo", "AdvertisingConnection", "AdvertisingInterface", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nAdvertisingIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvertisingIdManager.kt\ncom/apphud/sdk/managers/AdvertisingIdManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class AdvertisingIdManager {
    @NotNull
    public static final AdvertisingIdManager INSTANCE = new AdvertisingIdManager();

    private AdvertisingIdManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AdInfo getAdvertisingIdInfo(@NotNull Context context) throws Exception {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper()))) {
            boolean $i$a$-check-AdvertisingIdManager$getAdvertisingIdInfo$22 = false;
            String $i$a$-check-AdvertisingIdManager$getAdvertisingIdInfo$22 = "Cannot be called from the main thread";
            throw new IllegalStateException($i$a$-check-AdvertisingIdManager$getAdvertisingIdInfo$22.toString());
        }
        PackageManager pm = context.getPackageManager();
        pm.getPackageInfo("com.android.vending", 0);
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            AdInfo adInfo;
            try {
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
            return adInfo;
        }
        throw new IOException("Google Play connection failed");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apphud/sdk/managers/AdvertisingIdManager$AdInfo;", "", "id", "", "isLimitAdTrackingEnabled", "", "<init>", "(Ljava/lang/String;Z)V", "getId", "()Ljava/lang/String;", "()Z", "sdk_release"})
    public static final class AdInfo {
        @Nullable
        private final String id;
        private final boolean isLimitAdTrackingEnabled;

        public AdInfo(@Nullable String id, boolean isLimitAdTrackingEnabled) {
            this.id = id;
            this.isLimitAdTrackingEnabled = isLimitAdTrackingEnabled;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.isLimitAdTrackingEnabled;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/apphud/sdk/managers/AdvertisingIdManager$AdvertisingConnection;", "Landroid/content/ServiceConnection;", "<init>", "()V", "retrieved", "", "getRetrieved", "()Z", "setRetrieved", "(Z)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Landroid/os/IBinder;", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "service", "onServiceDisconnected", "binder", "getBinder", "()Landroid/os/IBinder;", "sdk_release"})
    private static final class AdvertisingConnection
    implements ServiceConnection {
        private boolean retrieved;
        @NotNull
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        public final boolean getRetrieved() {
            return this.retrieved;
        }

        public final void setRetrieved(boolean bl) {
            this.retrieved = bl;
        }

        public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            try {
                this.queue.put(service);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        }

        @NotNull
        public final IBinder getBinder() throws InterruptedException {
            if (!(!this.retrieved)) {
                throw new IllegalStateException("Check failed.");
            }
            this.retrieved = true;
            IBinder iBinder = this.queue.take();
            Intrinsics.checkNotNull((Object)iBinder, (String)"null cannot be cast to non-null type android.os.IBinder");
            return iBinder;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/apphud/sdk/managers/AdvertisingIdManager$AdvertisingInterface;", "Landroid/os/IInterface;", "binder", "Landroid/os/IBinder;", "<init>", "(Landroid/os/IBinder;)V", "asBinder", "id", "", "getId", "()Ljava/lang/String;", "isLimitAdTrackingEnabled", "", "paramBoolean", "sdk_release"})
    private static final class AdvertisingInterface
    implements IInterface {
        @NotNull
        private final IBinder binder;

        public AdvertisingInterface(@NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            this.binder = binder;
        }

        @NotNull
        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final String getId() throws RemoteException {
            String string;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain(...)");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain(...)");
            Parcel reply = parcel2;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                string = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            String id = string;
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean bl;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain(...)");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain(...)");
            Parcel reply = parcel2;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                bl = reply.readInt() != 0;
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            boolean limitAdTracking = bl;
            return limitAdTracking;
        }
    }
}

