/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudInternal;
import com.apphud.sdk.ApphudListener;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUserProperty;
import com.apphud.sdk.domain.AdjustInfo;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.ApphudPlacement;
import com.apphud.sdk.domain.ApphudUser;
import com.apphud.sdk.domain.AppsflyerInfo;
import com.apphud.sdk.domain.FacebookInfo;
import com.apphud.sdk.parser.GsonParser;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.Storage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010u\u001a\u00020J2\u0006\u0010v\u001a\u00020 J\u0006\u0010w\u001a\u00020xJ\u000e\u0010y\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010z\u001a\u00020J2\u0006\u0010{\u001a\u00020kJ\u0006\u0010|\u001a\u00020JJ\u0018\u0010}\u001a\u00020x2\u0006\u0010!\u001a\u00020 2\b\u0010~\u001a\u0004\u0018\u00010\u007fJ\u0007\u0010\u0080\u0001\u001a\u00020xR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0019\u001a\u0004\u0018\u00010 8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010)\u001a\u0004\u0018\u00010(2\b\u0010\u0019\u001a\u0004\u0018\u00010(8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u00100\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R(\u00105\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00102\"\u0004\b7\u00104R0\u00109\u001a\b\u0012\u0004\u0012\u00020\u0004082\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u0004088V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R(\u0010?\u001a\u0004\u0018\u00010>2\b\u0010\u0019\u001a\u0004\u0018\u00010>8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR(\u0010D\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u00102\"\u0004\bF\u00104R\u0016\u0010G\u001a\n I*\u0004\u0018\u00010H0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010K\u001a\u00020J2\u0006\u0010\u0019\u001a\u00020J8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR$\u0010O\u001a\u00020/2\u0006\u0010\u0019\u001a\u00020/8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u000e\u0010T\u001a\u00020UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010X\u001a\n\u0012\u0004\u0012\u00020W\u0018\u00010V2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020W\u0018\u00010V8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R4\u0010^\u001a\n\u0012\u0004\u0012\u00020]\u0018\u00010V2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020]\u0018\u00010V8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b_\u0010Z\"\u0004\b`\u0010\\R\u000e\u0010a\u001a\u00020bX\u0082.\u00a2\u0006\u0002\n\u0000R4\u0010c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010V2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010V8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bd\u0010Z\"\u0004\be\u0010\\R4\u0010g\u001a\n\u0012\u0004\u0012\u00020f\u0018\u00010V2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020f\u0018\u00010V8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bh\u0010Z\"\u0004\bi\u0010\\Rd\u0010m\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020k\u0018\u00010jj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020k\u0018\u0001`l2&\u0010\u0019\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020k\u0018\u00010jj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020k\u0018\u0001`l8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bn\u0010o\"\u0004\bp\u0010qR(\u0010r\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bs\u00102\"\u0004\bt\u00104\u00a8\u0006\u0081\u0001"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "Lcom/apphud/sdk/storage/Storage;", "()V", "ADJUST_KEY", "", "APPHUD_USER_KEY", "APPSFLYER_KEY", "CURRENT_CACHE_VERSION", "DEVICE_IDENTIFIERS_KEY", "DEVICE_ID_KEY", "FACEBOOK_KEY", "FIREBASE_KEY", "GROUP_KEY", "GROUP_TIMESTAMP_KEY", "LAST_REGISTRATION_KEY", "NAME", "NEED_RESTART_KEY", "PAYWALLS_KEY", "PAYWALLS_TIMESTAMP_KEY", "PLACEMENTS_KEY", "PLACEMENTS_TIMESTAMP_KEY", "PROPERTIES_KEY", "SKU_KEY", "SKU_TIMESTAMP_KEY", "USER_ID_KEY", "value", "Lcom/apphud/sdk/domain/AdjustInfo;", "adjust", "getAdjust", "()Lcom/apphud/sdk/domain/AdjustInfo;", "setAdjust", "(Lcom/apphud/sdk/domain/AdjustInfo;)V", "Lcom/apphud/sdk/domain/ApphudUser;", "apphudUser", "getApphudUser", "()Lcom/apphud/sdk/domain/ApphudUser;", "setApphudUser", "(Lcom/apphud/sdk/domain/ApphudUser;)V", "applicationContext", "Landroid/content/Context;", "Lcom/apphud/sdk/domain/AppsflyerInfo;", "appsflyer", "getAppsflyer", "()Lcom/apphud/sdk/domain/AppsflyerInfo;", "setAppsflyer", "(Lcom/apphud/sdk/domain/AppsflyerInfo;)V", "cacheTimeout", "", "cacheVersion", "getCacheVersion", "()Ljava/lang/String;", "setCacheVersion", "(Ljava/lang/String;)V", "deviceId", "getDeviceId", "setDeviceId", "", "deviceIdentifiers", "getDeviceIdentifiers", "()[Ljava/lang/String;", "setDeviceIdentifiers", "([Ljava/lang/String;)V", "Lcom/apphud/sdk/domain/FacebookInfo;", "facebook", "getFacebook", "()Lcom/apphud/sdk/domain/FacebookInfo;", "setFacebook", "(Lcom/apphud/sdk/domain/FacebookInfo;)V", "firebase", "getFirebase", "setFirebase", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "", "isNeedSync", "()Z", "setNeedSync", "(Z)V", "lastRegistration", "getLastRegistration", "()J", "setLastRegistration", "(J)V", "parser", "Lcom/apphud/sdk/parser/Parser;", "", "Lcom/apphud/sdk/domain/ApphudPaywall;", "paywalls", "getPaywalls", "()Ljava/util/List;", "setPaywalls", "(Ljava/util/List;)V", "Lcom/apphud/sdk/domain/ApphudPlacement;", "placements", "getPlacements", "setPlacements", "preferences", "Landroid/content/SharedPreferences;", "productDetails", "getProductDetails", "setProductDetails", "Lcom/apphud/sdk/domain/ApphudGroup;", "productGroups", "getProductGroups", "setProductGroups", "Ljava/util/HashMap;", "Lcom/apphud/sdk/ApphudUserProperty;", "Lkotlin/collections/HashMap;", "properties", "getProperties", "()Ljava/util/HashMap;", "setProperties", "(Ljava/util/HashMap;)V", "userId", "getUserId", "setUserId", "cacheExpired", "user", "clean", "", "getInstance", "needSendProperty", "property", "needUpdateProductGroups", "updateCustomer", "apphudListener", "Lcom/apphud/sdk/ApphudListener;", "validateCaches", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nSharedPreferencesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedPreferencesStorage.kt\ncom/apphud/sdk/storage/SharedPreferencesStorage\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,372:1\n37#2,2:373\n*S KotlinDebug\n*F\n+ 1 SharedPreferencesStorage.kt\ncom/apphud/sdk/storage/SharedPreferencesStorage\n*L\n91#1:373,2\n*E\n"})
public final class SharedPreferencesStorage
implements Storage {
    @NotNull
    public static final SharedPreferencesStorage INSTANCE = new SharedPreferencesStorage();
    private static long cacheTimeout = 90000L;
    private static Context applicationContext;
    private static SharedPreferences preferences;
    @NotNull
    private static final String NAME = "apphud_storage";
    @NotNull
    private static final String USER_ID_KEY = "userIdKey";
    @NotNull
    private static final String APPHUD_USER_KEY = "APPHUD_USER_KEY";
    @NotNull
    private static final String DEVICE_ID_KEY = "deviceIdKey";
    @NotNull
    private static final String DEVICE_IDENTIFIERS_KEY = "DEVICE_IDENTIFIERS_KEY";
    @NotNull
    private static final String NEED_RESTART_KEY = "needRestartKey";
    @NotNull
    private static final String PROPERTIES_KEY = "propertiesKey";
    @NotNull
    private static final String FACEBOOK_KEY = "facebookKey";
    @NotNull
    private static final String FIREBASE_KEY = "firebaseKey";
    @NotNull
    private static final String APPSFLYER_KEY = "appsflyerKey";
    @NotNull
    private static final String ADJUST_KEY = "adjustKey";
    @NotNull
    private static final String PAYWALLS_KEY = "PAYWALLS_KEY";
    @NotNull
    private static final String PAYWALLS_TIMESTAMP_KEY = "PAYWALLS_TIMESTAMP_KEY";
    @NotNull
    private static final String PLACEMENTS_KEY = "PLACEMENTS_KEY";
    @NotNull
    private static final String PLACEMENTS_TIMESTAMP_KEY = "PLACEMENTS_TIMESTAMP_KEY";
    @NotNull
    private static final String GROUP_KEY = "apphudGroupKey";
    @NotNull
    private static final String GROUP_TIMESTAMP_KEY = "apphudGroupTimestampKey";
    @NotNull
    private static final String SKU_KEY = "skuKey";
    @NotNull
    private static final String SKU_TIMESTAMP_KEY = "skuTimestampKey";
    @NotNull
    private static final String LAST_REGISTRATION_KEY = "lastRegistrationKey";
    @NotNull
    private static final String CURRENT_CACHE_VERSION = "2";
    private static final Gson gson;
    @NotNull
    private static final Parser parser;

    private SharedPreferencesStorage() {
    }

    @NotNull
    public final SharedPreferencesStorage getInstance(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        SharedPreferencesStorage.applicationContext = applicationContext;
        Context context = SharedPreferencesStorage.applicationContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            context = null;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"applicationContext.getSh\u2026ME, Context.MODE_PRIVATE)");
        preferences = sharedPreferences;
        Context context2 = SharedPreferencesStorage.applicationContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            context2 = null;
        }
        cacheTimeout = ApphudExtensionsKt.isDebuggable(context2) ? 1L : 90000L;
        return this;
    }

    @Override
    @Nullable
    public String getUserId() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(USER_ID_KEY, null);
    }

    @Override
    public void setUserId(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(USER_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public ApphudUser getApphudUser() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(APPHUD_USER_KEY, null);
        Type type2 = new TypeToken<ApphudUser>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (ApphudUser)parser.fromJson(source, type2);
    }

    @Override
    public void setApphudUser(@Nullable ApphudUser value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(APPHUD_USER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getDeviceId() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(DEVICE_ID_KEY, null);
    }

    @Override
    public void setDeviceId(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(DEVICE_ID_KEY, value);
        editor.apply();
    }

    @Override
    @NotNull
    public String[] getDeviceIdentifiers() {
        String[] stringArray;
        List ids;
        List list;
        String[] stringArray2;
        String string;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String string2 = string = sharedPreferences.getString(DEVICE_IDENTIFIERS_KEY, null);
        if (string2 != null) {
            stringArray2 = new String[]{"|"};
            list = StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        } else {
            list = null;
        }
        List list2 = ids = list;
        boolean bl = list2 != null ? ((Collection)list2).size() == 3 : false;
        if (bl) {
            Collection $this$toTypedArray$iv = ids;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray2 = new String[]{"", "", ""};
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Override
    public void setDeviceIdentifiers(@NotNull String[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        String string = ArraysKt.joinToString$default((Object[])value, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
        if (string == null) {
            string = "";
        }
        String idsString = string;
        editor.putString(DEVICE_IDENTIFIERS_KEY, idsString);
        editor.apply();
    }

    @Override
    public boolean isNeedSync() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getBoolean(NEED_RESTART_KEY, false);
    }

    @Override
    public void setNeedSync(boolean value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(NEED_RESTART_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public FacebookInfo getFacebook() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(FACEBOOK_KEY, null);
        Type type2 = new TypeToken<FacebookInfo>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (FacebookInfo)parser.fromJson(source, type2);
    }

    @Override
    public void setFacebook(@Nullable FacebookInfo value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(FACEBOOK_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getFirebase() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(FIREBASE_KEY, null);
    }

    @Override
    public void setFirebase(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(FIREBASE_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public AppsflyerInfo getAppsflyer() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(APPSFLYER_KEY, null);
        Type type2 = new TypeToken<AppsflyerInfo>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (AppsflyerInfo)parser.fromJson(source, type2);
    }

    @Override
    public void setAppsflyer(@Nullable AppsflyerInfo value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(APPSFLYER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public AdjustInfo getAdjust() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(ADJUST_KEY, null);
        Type type2 = new TypeToken<AdjustInfo>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (AdjustInfo)parser.fromJson(source, type2);
    }

    @Override
    public void setAdjust(@Nullable AdjustInfo value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(ADJUST_KEY, source);
        editor.apply();
    }

    public final boolean needUpdateProductGroups() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        long timestamp = sharedPreferences.getLong(GROUP_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        return currentTime >= timestamp;
    }

    @Override
    @Nullable
    public List<ApphudGroup> getProductGroups() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(GROUP_KEY, null);
        Type type2 = new TypeToken<List<? extends ApphudGroup>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (List)parser.fromJson(source, type2);
    }

    @Override
    public void setProductGroups(@Nullable List<ApphudGroup> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(GROUP_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(GROUP_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<ApphudPaywall> getPaywalls() {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = preferences;
        if (sharedPreferences2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences2 = null;
        }
        long timestamp = sharedPreferences2.getLong(PAYWALLS_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp || ApphudInternal.INSTANCE.getFallbackMode$sdk_release()) {
            sharedPreferences = preferences;
            if (sharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
                sharedPreferences = null;
            }
        } else {
            ApphudLog.log$default(ApphudLog.INSTANCE, "Paywalls Cache Expired", false, 2, null);
            return null;
        }
        String source = sharedPreferences.getString(PAYWALLS_KEY, null);
        Type type2 = new TypeToken<List<? extends ApphudPaywall>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (List)parser.fromJson(source, type2);
    }

    @Override
    public void setPaywalls(@Nullable List<ApphudPaywall> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(PAYWALLS_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(PAYWALLS_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<ApphudPlacement> getPlacements() {
        List list;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        long timestamp = sharedPreferences.getLong(PLACEMENTS_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp || ApphudInternal.INSTANCE.getFallbackMode$sdk_release()) {
            SharedPreferences sharedPreferences2 = preferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
                sharedPreferences2 = null;
            }
            String source = sharedPreferences2.getString(PLACEMENTS_KEY, null);
            Type type2 = new TypeToken<List<? extends ApphudPlacement>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
            list = (List)parser.fromJson(source, type2);
        } else {
            ApphudLog.log$default(ApphudLog.INSTANCE, "Placements Cache Expired", false, 2, null);
            list = null;
        }
        return list;
    }

    @Override
    public void setPlacements(@Nullable List<ApphudPlacement> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(PLACEMENTS_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(PLACEMENTS_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<String> getProductDetails() {
        List list;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        long timestamp = sharedPreferences.getLong(SKU_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            SharedPreferences sharedPreferences2 = preferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
                sharedPreferences2 = null;
            }
            String source = sharedPreferences2.getString(SKU_KEY, null);
            Type type2 = new TypeToken<List<? extends String>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
            list = (List)parser.fromJson(source, type2);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setProductDetails(@Nullable List<String> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(SKU_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(SKU_KEY, source);
        editor.apply();
    }

    @Override
    public long getLastRegistration() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getLong(LAST_REGISTRATION_KEY, 0L);
    }

    @Override
    public void setLastRegistration(long value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(LAST_REGISTRATION_KEY, value);
        editor.apply();
    }

    public final void updateCustomer(@NotNull ApphudUser apphudUser2, @Nullable ApphudListener apphudListener) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)apphudUser2, (String)"apphudUser");
            boolean userIdChanged = false;
            ApphudUser apphudUser3 = this.getApphudUser();
            if (apphudUser3 != null) {
                ApphudUser it = apphudUser3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)apphudUser2.getUserId())) {
                    userIdChanged = true;
                }
            }
            this.setApphudUser(apphudUser2);
            this.setUserId(apphudUser2.getUserId());
            if (!userIdChanged) break block3;
            ApphudListener apphudListener2 = apphudListener;
            if (apphudListener2 != null) {
                ApphudListener it = apphudListener2;
                boolean bl = false;
                apphudListener.apphudDidChangeUserID(apphudUser2.getUserId());
            }
        }
    }

    public final void clean() {
        this.setLastRegistration(0L);
        this.setApphudUser(null);
        this.setUserId(null);
        this.setDeviceId(null);
        String[] stringArray = new String[]{"", "", ""};
        this.setDeviceIdentifiers(stringArray);
        this.setNeedSync(false);
        this.setFacebook(null);
        this.setFirebase(null);
        this.setAppsflyer(null);
        this.setProductGroups(null);
        this.setPaywalls(null);
        this.setPlacements(null);
        this.setProductDetails(null);
        this.setProperties(null);
        this.setAdjust(null);
    }

    public final void validateCaches() {
        CharSequence charSequence = this.getCacheVersion();
        if (charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)this.getCacheVersion(), (Object)CURRENT_CACHE_VERSION)) {
            ApphudLog.log$default(ApphudLog.INSTANCE, "Invalid Cache Version. Clearing cached models.", false, 2, null);
            this.setApphudUser(null);
            this.setProductGroups(null);
            this.setPaywalls(null);
            this.setPlacements(null);
            this.setCacheVersion(CURRENT_CACHE_VERSION);
        }
    }

    @Override
    @Nullable
    public String getCacheVersion() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString("APPHUD_CACHE_VERSION", null);
    }

    @Override
    public void setCacheVersion(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("APPHUD_CACHE_VERSION", value);
        editor.apply();
    }

    public final boolean cacheExpired(@NotNull ApphudUser user) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        long timestamp = this.getLastRegistration() + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        boolean bl = result = currentTime > timestamp;
        if (result) {
            ApphudLog.logI$default(ApphudLog.INSTANCE, "Cached ApphudUser found, but cache expired", false, 2, null);
        } else {
            long minutes = (timestamp - currentTime) / 60000L;
            long seconds = (timestamp - currentTime - minutes * 60000L) / 1000L;
            ApphudLog.logI$default(ApphudLog.INSTANCE, "Using cached ApphudUser", false, 2, null);
        }
        return result;
    }

    @Override
    @Nullable
    public HashMap<String, ApphudUserProperty> getProperties() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(PROPERTIES_KEY, null);
        Type type2 = new TypeToken<HashMap<String, ApphudUserProperty>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (HashMap)parser.fromJson(source, type2);
    }

    @Override
    public void setProperties(@Nullable HashMap<String, ApphudUserProperty> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PROPERTIES_KEY, source);
        editor.apply();
    }

    public final boolean needSendProperty(@NotNull ApphudUserProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, ApphudUserProperty>());
        }
        HashMap<String, ApphudUserProperty> hashMap = this.getProperties();
        if (hashMap != null) {
            HashMap<String, ApphudUserProperty> it = hashMap;
            boolean bl = false;
            if (property.getValue() == null) {
                if (it.containsKey(property.getKey())) {
                    it.remove(property.getKey());
                    INSTANCE.setProperties(it);
                }
                return true;
            }
            if (it.containsKey(property.getKey())) {
                ApphudUserProperty apphudUserProperty = it.get(property.getKey());
                boolean bl2 = apphudUserProperty != null ? apphudUserProperty.getSetOnce() : false;
                if (bl2) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. The property was previously specified as not updatable";
                    ApphudLog.logI$default(ApphudLog.INSTANCE, message, false, 2, null);
                    return false;
                }
                if (property.getIncrement()) {
                    if (it.containsKey(property.getKey())) {
                        it.remove(property.getKey());
                        INSTANCE.setProperties(it);
                    }
                    return true;
                }
                ApphudUserProperty apphudUserProperty2 = it.get(property.getKey());
                if (Intrinsics.areEqual((Object)(apphudUserProperty2 != null ? apphudUserProperty2.getValue$sdk_release() : null), (Object)property.getValue$sdk_release()) && !property.getSetOnce()) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. Property value was not changed";
                    ApphudLog.logI$default(ApphudLog.INSTANCE, message, false, 2, null);
                    return false;
                }
            }
        }
        return true;
    }

    static {
        Gson gson = SharedPreferencesStorage.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
        parser = new GsonParser(gson);
    }
}

