/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudListener;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.AppsflyerInfo;
import com.apphud.sdk.domain.Customer;
import com.apphud.sdk.domain.FacebookInfo;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.Storage;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 D2\u00020\u0001:\u0001DB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010@\u001a\u00020A2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010B\u001a\u0004\u0018\u00010CR(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0007\u001a\u0004\u0018\u00010\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u000b\"\u0004\b \u0010\rR(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0007\u001a\u0004\u0018\u00010!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R(\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\u000b\"\u0004\b)\u0010\rR$\u0010+\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u00101\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0016\u00106\u001a\n 8*\u0004\u0018\u00010707X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010:\u001a\n\u0012\u0004\u0012\u000209\u0018\u00010/2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u000209\u0018\u00010/8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b;\u00103\"\u0004\b<\u00105R(\u0010=\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010\u000b\"\u0004\b?\u0010\r\u00a8\u0006E"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "Lcom/apphud/sdk/storage/Storage;", "context", "Landroid/content/Context;", "parser", "Lcom/apphud/sdk/parser/Parser;", "(Landroid/content/Context;Lcom/apphud/sdk/parser/Parser;)V", "value", "", "advertisingId", "getAdvertisingId", "()Ljava/lang/String;", "setAdvertisingId", "(Ljava/lang/String;)V", "Lcom/apphud/sdk/domain/AppsflyerInfo;", "appsflyer", "getAppsflyer", "()Lcom/apphud/sdk/domain/AppsflyerInfo;", "setAppsflyer", "(Lcom/apphud/sdk/domain/AppsflyerInfo;)V", "cacheTimeout", "", "getCacheTimeout", "()J", "Lcom/apphud/sdk/domain/Customer;", "customer", "getCustomer", "()Lcom/apphud/sdk/domain/Customer;", "setCustomer", "(Lcom/apphud/sdk/domain/Customer;)V", "deviceId", "getDeviceId", "setDeviceId", "Lcom/apphud/sdk/domain/FacebookInfo;", "facebook", "getFacebook", "()Lcom/apphud/sdk/domain/FacebookInfo;", "setFacebook", "(Lcom/apphud/sdk/domain/FacebookInfo;)V", "firebase", "getFirebase", "setFirebase", "", "isNeedSync", "()Z", "setNeedSync", "(Z)V", "", "Lcom/apphud/sdk/domain/ApphudPaywall;", "paywalls", "getPaywalls", "()Ljava/util/List;", "setPaywalls", "(Ljava/util/List;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "Lcom/apphud/sdk/domain/ApphudGroup;", "productGroups", "getProductGroups", "setProductGroups", "userId", "getUserId", "setUserId", "updateCustomer", "", "apphudListener", "Lcom/apphud/sdk/ApphudListener;", "Companion", "sdk_release"})
public final class SharedPreferencesStorage
implements Storage {
    private final SharedPreferences preferences;
    private final long cacheTimeout;
    private final Parser parser;
    private static final String NAME = "apphud_storage";
    private static final int MODE = 0;
    private static final String USER_ID_KEY = "userIdKey";
    private static final String CUSTOMER_KEY = "customerKey";
    private static final String DEVICE_ID_KEY = "deviceIdKey";
    private static final String ADVERTISING_DI_KEY = "advertisingIdKey";
    private static final String NEED_RESTART_KEY = "needRestartKey";
    private static final String FACEBOOK_KEY = "facebookKey";
    private static final String FIREBASE_KEY = "firebaseKey";
    private static final String APPSFLYER_KEY = "appsflyerKey";
    private static final String PAYWALLS_KEY = "payWallsKey";
    private static final String PAYWALLS_TIMESTAMP_KEY = "payWallsTimestampKey";
    private static final String GROUP_KEY = "apphudGroupKey";
    private static final String GROUP_TIMESTAMP_KEY = "apphudGroupTimestampKey";
    public static final Companion Companion = new Companion(null);

    public final long getCacheTimeout() {
        return this.cacheTimeout;
    }

    @Override
    @Nullable
    public String getUserId() {
        return this.preferences.getString(USER_ID_KEY, null);
    }

    @Override
    public void setUserId(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(USER_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public Customer getCustomer() {
        Type type2;
        String source = this.preferences.getString(CUSTOMER_KEY, null);
        Type type3 = type2 = new TypeToken<Customer>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
        return (Customer)this.parser.fromJson(source, type3);
    }

    @Override
    public void setCustomer(@Nullable Customer value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(CUSTOMER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getDeviceId() {
        return this.preferences.getString(DEVICE_ID_KEY, null);
    }

    @Override
    public void setDeviceId(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(DEVICE_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public String getAdvertisingId() {
        return this.preferences.getString(ADVERTISING_DI_KEY, null);
    }

    @Override
    public void setAdvertisingId(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(ADVERTISING_DI_KEY, value);
        editor.apply();
    }

    @Override
    public boolean isNeedSync() {
        return this.preferences.getBoolean(NEED_RESTART_KEY, false);
    }

    @Override
    public void setNeedSync(boolean value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putBoolean(NEED_RESTART_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public FacebookInfo getFacebook() {
        Type type2;
        String source = this.preferences.getString(FACEBOOK_KEY, null);
        Type type3 = type2 = new TypeToken<FacebookInfo>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
        return (FacebookInfo)this.parser.fromJson(source, type3);
    }

    @Override
    public void setFacebook(@Nullable FacebookInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(FACEBOOK_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getFirebase() {
        return this.preferences.getString(FIREBASE_KEY, null);
    }

    @Override
    public void setFirebase(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(FIREBASE_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public AppsflyerInfo getAppsflyer() {
        Type type2;
        String source = this.preferences.getString(APPSFLYER_KEY, null);
        Type type3 = type2 = new TypeToken<AppsflyerInfo>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
        return (AppsflyerInfo)this.parser.fromJson(source, type3);
    }

    @Override
    public void setAppsflyer(@Nullable AppsflyerInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(APPSFLYER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<ApphudPaywall> getPaywalls() {
        List list;
        long timestamp = this.preferences.getLong(PAYWALLS_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            Type type2;
            String source = this.preferences.getString(PAYWALLS_KEY, null);
            Type type3 = type2 = new TypeToken<List<? extends ApphudPaywall>>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
            list = (List)this.parser.fromJson(source, type3);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setPaywalls(@Nullable List<ApphudPaywall> value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(PAYWALLS_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(PAYWALLS_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<ApphudGroup> getProductGroups() {
        long timestamp = this.preferences.getLong(GROUP_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            Type type2;
            String source = this.preferences.getString(GROUP_KEY, null);
            Type type3 = type2 = new TypeToken<List<? extends ApphudGroup>>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
            return (List)this.parser.fromJson(source, type3);
        }
        return null;
    }

    @Override
    public void setProductGroups(@Nullable List<ApphudGroup> value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(GROUP_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(GROUP_KEY, source);
        editor.apply();
    }

    public final void updateCustomer(@NotNull Customer customer2, @Nullable ApphudListener apphudListener) {
        block3: {
            Object it;
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)customer2, (String)"customer");
            boolean userIdChanged = false;
            Customer customer3 = this.getCustomer();
            if (customer3 != null) {
                object = customer3;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)((Customer)it).getUser().getUserId(), (Object)customer2.getUser().getUserId()) ^ true) {
                    userIdChanged = true;
                }
            }
            this.setCustomer(customer2);
            this.setUserId(customer2.getUser().getUserId());
            if (!userIdChanged) break block3;
            ApphudListener apphudListener2 = apphudListener;
            if (apphudListener2 != null) {
                object = apphudListener2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                apphudListener.apphudDidChangeUserID(customer2.getUser().getUserId());
            }
        }
    }

    public SharedPreferencesStorage(@NotNull Context context, @NotNull Parser parser) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        this.parser = parser;
        this.preferences = context.getSharedPreferences(NAME, 0);
        this.cacheTimeout = ApphudExtensionsKt.isDebuggable(context) ? 60L : 3600L;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage$Companion;", "", "()V", "ADVERTISING_DI_KEY", "", "APPSFLYER_KEY", "CUSTOMER_KEY", "DEVICE_ID_KEY", "FACEBOOK_KEY", "FIREBASE_KEY", "GROUP_KEY", "GROUP_TIMESTAMP_KEY", "MODE", "", "NAME", "NEED_RESTART_KEY", "PAYWALLS_KEY", "PAYWALLS_TIMESTAMP_KEY", "USER_ID_KEY", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

