/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.org.apache.http.impl.client;

import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HeaderElement;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpResponse;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.annotation.Immutable;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.message.BasicHeaderElementIterator;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.protocol.HttpContext;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

