/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.okhttp3.internal.http2;

import com.appdynamics.serverless.tracers.dependencies.okhttp3.Headers;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.internal.Util;
import com.appdynamics.serverless.tracers.dependencies.okio.ByteString;

public final class Header {
    public static final ByteString PSEUDO_PREFIX = ByteString.encodeUtf8(":");
    public static final String RESPONSE_STATUS_UTF8 = ":status";
    public static final String TARGET_METHOD_UTF8 = ":method";
    public static final String TARGET_PATH_UTF8 = ":path";
    public static final String TARGET_SCHEME_UTF8 = ":scheme";
    public static final String TARGET_AUTHORITY_UTF8 = ":authority";
    public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8(":status");
    public static final ByteString TARGET_METHOD = ByteString.encodeUtf8(":method");
    public static final ByteString TARGET_PATH = ByteString.encodeUtf8(":path");
    public static final ByteString TARGET_SCHEME = ByteString.encodeUtf8(":scheme");
    public static final ByteString TARGET_AUTHORITY = ByteString.encodeUtf8(":authority");
    public final ByteString name;
    public final ByteString value;
    final int hpackSize;

    public Header(String name, String value) {
        this(ByteString.encodeUtf8(name), ByteString.encodeUtf8(value));
    }

    public Header(ByteString name, String value) {
        this(name, ByteString.encodeUtf8(value));
    }

    public Header(ByteString name, ByteString value) {
        this.name = name;
        this.value = value;
        this.hpackSize = 32 + name.size() + value.size();
    }

    public boolean equals(Object other) {
        if (other instanceof Header) {
            Header that = (Header)other;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return Util.format("%s: %s", this.name.utf8(), this.value.utf8());
    }

    static interface Listener {
        public void onHeaders(Headers var1);
    }
}

