/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.google.gson.internal.bind;

import com.appdynamics.serverless.tracers.dependencies.com.google.gson.Gson;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.JsonSyntaxException;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.TypeAdapter;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.TypeAdapterFactory;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.internal.bind.util.ISO8601Utils;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.reflect.TypeToken;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.stream.JsonReader;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.stream.JsonToken;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public final class DateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new DateTypeAdapter() : null;
        }
    };
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat localFormat = DateFormat.getDateTimeInstance(2, 2);

    @Override
    public Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.deserializeToDate(in.nextString());
    }

    private synchronized Date deserializeToDate(String json) {
        try {
            return this.localFormat.parse(json);
        }
        catch (ParseException parseException) {
            try {
                return this.enUsFormat.parse(json);
            }
            catch (ParseException parseException2) {
                try {
                    return ISO8601Utils.parse(json, new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonSyntaxException(json, e);
                }
            }
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String dateFormatAsString = this.enUsFormat.format(value);
        out.value(dateFormatAsString);
    }
}

