/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.amazonaws.retry;

import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.AmazonClientException;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.AmazonWebServiceRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.ClientConfiguration;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.annotation.SdkInternalApi;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.retry.v2.RetryPolicy;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.retry.v2.RetryPolicyContext;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final com.appdynamics.serverless.tracers.dependencies.com.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(com.appdynamics.serverless.tracers.dependencies.com.amazonaws.retry.RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() >= this.getMaxErrorRetry()) {
            return false;
        }
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public com.appdynamics.serverless.tracers.dependencies.com.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }
}

