/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json;

import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.annotation.SdkProtectedApi;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.MarshallLocation;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.MarshallingType;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.OperationInfo;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.ProtocolRequestMarshaller;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json.StructuredJsonMarshaller;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json.internal.JsonProtocolMarshaller;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json.internal.MarshallerRegistry;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json.internal.NullAsEmptyBodyProtocolRequestMarshaller;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.protocol.json.internal.SimpleTypeJsonMarshallers;

@SdkProtectedApi
public class JsonProtocolMarshallerBuilder<T> {
    private StructuredJsonGenerator jsonGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private boolean sendExplicitNullForPayload;
    private T originalRequest;
    private MarshallerRegistry.Builder marshallerRegistry;

    public static <T> JsonProtocolMarshallerBuilder<T> standard() {
        return new JsonProtocolMarshallerBuilder<T>();
    }

    public JsonProtocolMarshallerBuilder<T> jsonGenerator(StructuredJsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        this.sendExplicitNullForPayload = sendExplicitNullForPayload;
        return this;
    }

    public JsonProtocolMarshallerBuilder<T> originalRequest(T originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    public <MarshallT> JsonProtocolMarshallerBuilder<T> marshallerOverride(MarshallLocation marshallLocation, MarshallingType<MarshallT> marshallingType, StructuredJsonMarshaller<MarshallT> marshaller) {
        if (this.marshallerRegistry == null) {
            this.marshallerRegistry = MarshallerRegistry.builder();
        }
        this.marshallerRegistry.addMarshaller(marshallLocation, marshallingType, SimpleTypeJsonMarshallers.adapt(marshaller));
        return this;
    }

    public ProtocolRequestMarshaller<T> build() {
        JsonProtocolMarshaller<T> protocolMarshaller = new JsonProtocolMarshaller<T>(this.jsonGenerator, this.contentType, this.operationInfo, this.originalRequest, this.marshallerRegistry);
        return this.sendExplicitNullForPayload ? protocolMarshaller : new NullAsEmptyBodyProtocolRequestMarshaller<T>(protocolMarshaller);
    }
}

