/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.com.amazonaws.internal;

import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.AmazonWebServiceRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.RequestClientOptions;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.RequestConfig;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.annotation.SdkInternalApi;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.auth.AWSCredentialsProvider;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.event.ProgressListener;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.metrics.RequestMetricCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public final class AmazonWebServiceRequestAdapter
extends RequestConfig {
    private final AmazonWebServiceRequest request;

    public AmazonWebServiceRequestAdapter(AmazonWebServiceRequest request) {
        this.request = request;
    }

    @Override
    public ProgressListener getProgressListener() {
        return this.request.getGeneralProgressListener();
    }

    @Override
    public RequestMetricCollector getRequestMetricsCollector() {
        return this.request.getRequestMetricCollector();
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider() {
        return this.request.getRequestCredentialsProvider();
    }

    @Override
    public Map<String, String> getCustomRequestHeaders() {
        return this.request.getCustomRequestHeaders() == null ? Collections.emptyMap() : this.request.getCustomRequestHeaders();
    }

    @Override
    public Map<String, List<String>> getCustomQueryParameters() {
        return this.request.getCustomQueryParameters() == null ? Collections.emptyMap() : this.request.getCustomQueryParameters();
    }

    @Override
    public Integer getRequestTimeout() {
        return this.request.getSdkRequestTimeout();
    }

    @Override
    public Integer getClientExecutionTimeout() {
        return this.request.getSdkClientExecutionTimeout();
    }

    @Override
    public RequestClientOptions getRequestClientOptions() {
        return this.request.getRequestClientOptions();
    }

    @Override
    public String getRequestType() {
        return this.request.getClass().getSimpleName();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }
}

