/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.utils;

import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadChainParserUtil {
    public static String encodeThreadChain(Map<Integer, String> exitCallPosVsLatestAsyncAddId) {
        StringBuilder sb = new StringBuilder();
        if (exitCallPosVsLatestAsyncAddId != null) {
            for (Integer exitCallPosition : exitCallPosVsLatestAsyncAddId.keySet()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(exitCallPosition).append(":");
                String linkLatestThreadAddId = exitCallPosVsLatestAsyncAddId.get(exitCallPosition);
                sb.append(linkLatestThreadAddId);
            }
        }
        return sb.toString();
    }

    public static Map<Integer, String> parseThreadChain(String headerAttribute) {
        List<String> threadChains = ThreadChainParserUtil.parseHeader(headerAttribute);
        HashMap<Integer, String> exitCallPositionVsLatestThreadAddId = new HashMap<Integer, String>(threadChains.size());
        for (String threadChain : threadChains) {
            String[] posAndIds = threadChain.split(":");
            String exitCallPosition = posAndIds[0];
            String threadAddIdString = posAndIds[1];
            String[] ids = threadAddIdString.split("-");
            exitCallPositionVsLatestThreadAddId.put(Integer.valueOf(exitCallPosition), ids[ids.length - 1]);
        }
        return exitCallPositionVsLatestThreadAddId;
    }

    private static List<String> parseHeader(String header) {
        return StringOperations.parseCommaSeparatedString(header);
    }
}

