/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.utils;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.logging.SysOutLogger;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamConverter {
    static AWSLambdaLogger logger = new SysOutLogger(AWSLambdaLogger.LogLevel.INFO);

    public static InputStream convertToMarkSupportedInputStream(InputStream inputStream) {
        if (inputStream == null) {
            logger.log(AWSLambdaLogger.LogLevel.WARN, "InputStream is null.", new Object[0]);
        } else if (!inputStream.markSupported()) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy(inputStream, outputStream);
                byte[] data = outputStream.toByteArray();
                return new ByteArrayInputStream(data);
            }
            catch (IOException e) {
                logger.log(AWSLambdaLogger.LogLevel.WARN, "InputStream conversion failed with exception: " + e.getMessage(), new Object[0]);
            }
        }
        return inputStream;
    }
}

