/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.transactions;

import com.appdynamics.serverless.tracers.aws.correlation.TransactionCorrelator;
import com.appdynamics.serverless.tracers.aws.errors.ErrorHelper;
import com.appdynamics.serverless.tracers.aws.exit.ExitCallIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.exit.RegisteredBackendInfo;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.publish.EventManager;
import com.appdynamics.serverless.tracers.aws.transactions.BTIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.transactions.RegisteredBT;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TransactionMonitoringContext {
    private String accountGUID;
    private String controllerGUID;
    private long tierId;
    private long applicationId;
    private String globalAccountName;
    private boolean useNewAsyncCorrelation = true;
    private boolean lagging;
    private long timeSkew;
    private String btName;
    private long btId;
    private int maxMetricNameLength = 750;
    private final ReadWriteLock readWriteLock;
    private final AWSLambdaLogger logger;
    private final EventManager eventManager;
    private final TransactionCorrelator txCorrelator;
    private final ErrorHelper errorHelper;
    private final Map<ExitCallIdentifyingInfo, RegisteredBackendInfo> exitCallInfoToRegisteredInfoCache;
    private final Map<BTIdentifyingInfo, RegisteredBT> btInfoToRegisteredInfoCache;
    private String defaultBtName;

    public TransactionMonitoringContext(EventManager eventManager, TransactionCorrelator txCorrelator, Map<ExitCallIdentifyingInfo, RegisteredBackendInfo> exitCallInfoToRegisteredInfoCache, Map<BTIdentifyingInfo, RegisteredBT> btInfoToRegisteredInfoCache, AWSLambdaLogger logger, ErrorHelper errorHelper) {
        this.eventManager = eventManager;
        this.txCorrelator = txCorrelator;
        this.exitCallInfoToRegisteredInfoCache = exitCallInfoToRegisteredInfoCache;
        this.btInfoToRegisteredInfoCache = btInfoToRegisteredInfoCache;
        this.logger = logger;
        this.errorHelper = errorHelper;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public AWSLambdaLogger getLogger() {
        return this.logger;
    }

    public ErrorHelper getErrorHelper() {
        return this.errorHelper;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public TransactionCorrelator getTxCorrelator() {
        return this.txCorrelator;
    }

    public Map<ExitCallIdentifyingInfo, RegisteredBackendInfo> getExitCallInfoToRegisteredInfoCache() {
        return this.exitCallInfoToRegisteredInfoCache;
    }

    public Map<BTIdentifyingInfo, RegisteredBT> getBtInfoToRegisteredInfoCache() {
        return this.btInfoToRegisteredInfoCache;
    }

    public int getMaxMetricNameLength() {
        return this.maxMetricNameLength;
    }

    public void setMaxMetricNameLength(int maxMetricNameLength) {
        this.maxMetricNameLength = maxMetricNameLength;
    }

    public long getBtId() {
        return this.btId;
    }

    public void setBtId(long btId) {
        this.btId = btId;
    }

    public String getBtName() {
        return this.btName;
    }

    public void setBtName(String btName) {
        this.btName = btName;
    }

    public String getAccountGUID() {
        return this.accountGUID;
    }

    public void setAccountGUID(String accountGUID) {
        this.accountGUID = accountGUID;
    }

    public String getControllerGUID() {
        return this.controllerGUID;
    }

    public void setControllerGUID(String controllerGUID) {
        this.controllerGUID = controllerGUID;
    }

    public long getTierId() {
        return this.tierId;
    }

    public void setTierId(long tierId) {
        this.tierId = tierId;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public String getGlobalAccountName() {
        return this.globalAccountName;
    }

    public void setGlobalAccountName(String globalAccountName) {
        this.globalAccountName = globalAccountName;
    }

    public boolean isUseNewAsyncCorrelation() {
        return this.useNewAsyncCorrelation;
    }

    public boolean isLagging() {
        return this.lagging;
    }

    public void setLagging(boolean lagging) {
        this.lagging = lagging;
    }

    public long getTimeSkew() {
        return this.timeSkew;
    }

    public void setTimeSkew(long timeSkew) {
        this.timeSkew = timeSkew;
    }

    public String getDefaultBtName() {
        return this.defaultBtName;
    }

    public void setDefaultBtName(String defaultBtName) {
        this.defaultBtName = defaultBtName;
    }
}

