/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.logging;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class LambdaLoggerWrapper
implements AWSLambdaLogger {
    private WeakReference<Object> lambdaLoggerObj;
    private Method method;
    private AWSLambdaLogger.LogLevel currentLogLevel;

    public LambdaLoggerWrapper(Object lambdaLogger) throws NoSuchMethodException {
        Class<?> cls = lambdaLogger.getClass();
        this.method = cls.getDeclaredMethod("log", String.class);
        this.method.setAccessible(true);
        this.lambdaLoggerObj = new WeakReference<Object>(lambdaLogger);
        this.currentLogLevel = AWSLambdaLogger.LogLevel.INFO;
    }

    @Override
    public void log(AWSLambdaLogger.LogLevel level, String format, Object ... args) {
        Object target;
        if (level.ordinal() >= this.currentLogLevel.ordinal() && null != (target = this.lambdaLoggerObj.get())) {
            try {
                this.method.invoke(target, String.format("[AppDynamics Tracer] [" + level.name() + "]: " + format + "%n", args));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setCurrentLogLevel(AWSLambdaLogger.LogLevel currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    @Override
    public AWSLambdaLogger.LogLevel getCurrentLogLevel() {
        return this.currentLogLevel;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.currentLogLevel.ordinal() == AWSLambdaLogger.LogLevel.DEBUG.ordinal();
    }

    @Override
    public void debug(String message) {
        this.log(AWSLambdaLogger.LogLevel.DEBUG, message, new Object[0]);
    }
}

