/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.logging;

import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.logging.LogEvent;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.AWSLogs;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.InputLogEvent;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.LogGroup;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.LogStream;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.appdynamics.serverless.tracers.dependencies.com.amazonaws.services.logs.model.PutLogEventsResult;
import java.time.Clock;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class AWSCloudWatchLogger
implements AWSLambdaLogger {
    private AWSLambdaLogger.LogLevel currentLogLevel;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final int DEFAULT_QUEUE_LENGTH = 1024;
    private static final int DEFAULT_MESSAGE_BATCH_SIZE = 128;
    private final String logGroupName;
    private final String logStreamName;
    private final AWSLogs awsLogs;
    private final AtomicReference<String> lastSequenceToken = new AtomicReference();
    private final BlockingQueue<LogEvent> logEventsQueue;
    private final int messagesBatchSize;
    private final ScheduledExecutorService messageSender;

    public AWSCloudWatchLogger(String logGroupName, String logStreamNamePrefix) {
        this(logGroupName, logStreamNamePrefix, AWSLogsClientBuilder.defaultClient(), Clock.systemUTC());
    }

    AWSCloudWatchLogger(String logGroupName, String logStreamNamePrefix, AWSLogs awsLogs, Clock clock) {
        this.currentLogLevel = AWSLambdaLogger.LogLevel.INFO;
        this.logGroupName = logGroupName;
        this.awsLogs = awsLogs;
        this.messagesBatchSize = 128;
        this.logEventsQueue = new ArrayBlockingQueue<LogEvent>(1024);
        this.logStreamName = this.buildLogStreamName(logStreamNamePrefix, clock);
        this.messageSender = Executors.newSingleThreadScheduledExecutor();
    }

    public void init() {
        this.messageSender.scheduleAtFixedRate(() -> {
            try {
                if (!this.logEventsQueue.isEmpty()) {
                    this.sendMessages();
                }
            }
            catch (Exception e) {
                this.debug("AWSCloudWatchLogger ERROR => ", e);
            }
        }, 20L, 20L, TimeUnit.MILLISECONDS);
        this.setupLogGroup();
        this.setupLogStream();
    }

    String buildLogStreamName(String logStreamNamePrefix, Clock clock) {
        String date = FORMATTER.format(LocalDate.now(clock));
        if (logStreamNamePrefix == null || logStreamNamePrefix.trim().isEmpty()) {
            return date;
        }
        return logStreamNamePrefix + "/" + date;
    }

    void sendMessages(List<InputLogEvent> inputLogEvents) {
        try {
            PutLogEventsRequest request = new PutLogEventsRequest(this.logGroupName, this.logStreamName, inputLogEvents).withSequenceToken(this.lastSequenceToken.get());
            this.send(request);
        }
        catch (Exception e) {
            this.debug("ERROR while sending logs:", e);
        }
    }

    void setupLogGroup() {
        Optional<LogGroup> existing;
        DescribeLogGroupsRequest request = new DescribeLogGroupsRequest().withLogGroupNamePrefix(this.logGroupName);
        DescribeLogGroupsResult groupsResult = this.awsLogs.describeLogGroups(request);
        if (groupsResult != null && !(existing = groupsResult.getLogGroups().stream().filter(logGroup -> logGroup.getLogGroupName().equalsIgnoreCase(this.logGroupName)).findFirst()).isPresent()) {
            this.debug("Creates LogGroup: " + this.logGroupName);
            this.awsLogs.createLogGroup(new CreateLogGroupRequest().withLogGroupName(this.logGroupName));
        }
    }

    void setupLogStream() {
        Optional<LogStream> existing;
        DescribeLogStreamsRequest request = new DescribeLogStreamsRequest().withLogGroupName(this.logGroupName).withLogStreamNamePrefix(this.logStreamName);
        DescribeLogStreamsResult streamsResult = this.awsLogs.describeLogStreams(request);
        if (streamsResult != null && !(existing = streamsResult.getLogStreams().stream().filter(logStream -> logStream.getLogStreamName().equalsIgnoreCase(this.logStreamName)).findFirst()).isPresent()) {
            this.debug("Creates LogStream: " + this.logStreamName + " in LogGroup: " + this.logGroupName);
            this.awsLogs.createLogStream(new CreateLogStreamRequest().withLogGroupName(this.logGroupName).withLogStreamName(this.logStreamName));
        }
    }

    void send(PutLogEventsRequest request) {
        try {
            PutLogEventsResult result = this.awsLogs.putLogEvents(request);
            this.lastSequenceToken.set(result.getNextSequenceToken());
        }
        catch (InvalidSequenceTokenException e) {
            this.debug("InvalidSequenceTokenException while sending logs", e);
            request.setSequenceToken(e.getExpectedSequenceToken());
            PutLogEventsResult result = this.awsLogs.putLogEvents(request);
            this.lastSequenceToken.set(result.getNextSequenceToken());
        }
    }

    @Override
    public void debug(String message) {
        this.log(AWSLambdaLogger.LogLevel.DEBUG, message, new Object[0]);
    }

    void debug(String message, Throwable throwable) {
        this.log(AWSLambdaLogger.LogLevel.DEBUG, "%s => %s", message, throwable.getMessage());
    }

    void sendMessages() {
        ArrayList<LogEvent> loggingEvents = new ArrayList<LogEvent>();
        LogEvent polledLoggingEvent = (LogEvent)this.logEventsQueue.poll();
        while (polledLoggingEvent != null && loggingEvents.size() <= this.messagesBatchSize) {
            loggingEvents.add(polledLoggingEvent);
            polledLoggingEvent = (LogEvent)this.logEventsQueue.poll();
        }
        List<InputLogEvent> inputLogEvents = loggingEvents.stream().map(event -> new InputLogEvent().withTimestamp(event.getTimestampInMs()).withMessage(event.getMessage())).collect(Collectors.toList());
        this.sendMessages(inputLogEvents);
    }

    @Override
    public void log(AWSLambdaLogger.LogLevel level, String format, Object ... args) {
        if (level.ordinal() >= this.currentLogLevel.ordinal()) {
            this.logEventsQueue.offer(new LogEvent(System.currentTimeMillis(), String.format("[AppDynamics Tracer] [" + level.name() + "]: " + format + "%n", args)));
        }
    }

    @Override
    public void setCurrentLogLevel(AWSLambdaLogger.LogLevel currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    @Override
    public AWSLambdaLogger.LogLevel getCurrentLogLevel() {
        return this.currentLogLevel;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.currentLogLevel.ordinal() == AWSLambdaLogger.LogLevel.DEBUG.ordinal();
    }
}

