/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.impl;

import com.appdynamics.serverless.tracers.aws.api.Tracer;
import com.appdynamics.serverless.tracers.aws.api.Transaction;
import com.appdynamics.serverless.tracers.aws.impl.TransactionImpl;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.transactions.TransactionMonitoringContext;
import com.appdynamics.serverless.tracers.aws.utils.AWSLambdaContextUtil;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.JsonObject;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.JsonParseException;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class TracerImpl
implements Tracer {
    private final String HTTP_HEADERS = "headers";
    private final int MB_TO_BYTES = 1000000;
    private TransactionMonitoringContext txContext;
    private AWSLambdaLogger logger;
    private int headerReadLimitInBytes;

    public TracerImpl(TransactionMonitoringContext txContext, int headerReadLimitInMb) {
        this.txContext = txContext;
        this.logger = txContext.getLogger();
        this.headerReadLimitInBytes = headerReadLimitInMb * 1000000;
    }

    @Override
    public Transaction createTransaction(String correlationHeader) {
        return new TransactionImpl(correlationHeader, this.txContext);
    }

    @Override
    public Transaction createTransaction(InputStream inputStream, Object context) {
        String correlationHeader = this.getCorrelationHeader(context, inputStream);
        return new TransactionImpl(correlationHeader, this.txContext);
    }

    @Override
    public Transaction createTransaction() {
        this.logger.log(AWSLambdaLogger.LogLevel.INFO, "Creating a transaction with a null correlation header will be left empty.", new Object[0]);
        return new TransactionImpl(null, this.txContext);
    }

    @Override
    public Transaction createNamedTransaction(String btName) {
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Will create a named transaction with named bt name = %s", btName);
        this.txContext.setBtName(btName);
        return new TransactionImpl(null, this.txContext);
    }

    private String getCorrelationHeader(Object context, InputStream inputStream) {
        Map<String, String> map;
        String correlationHeader = null;
        if (context != null && (map = AWSLambdaContextUtil.getClientContextEnvironment(context, this.logger)) != null && map.containsKey("singularityheader")) {
            correlationHeader = map.get("singularityheader");
        }
        JsonObject inputJsonObject = this.convertInputStreamToJson(inputStream);
        if (correlationHeader == null && inputJsonObject != null) {
            JsonObject httpHeaders;
            if (inputJsonObject.has("singularityheader")) {
                correlationHeader = inputJsonObject.get("singularityheader").getAsString();
            } else if (inputJsonObject.has("headers") && (httpHeaders = inputJsonObject.getAsJsonObject("headers")).has("singularityheader")) {
                correlationHeader = httpHeaders.get("singularityheader").getAsString();
            }
        }
        if (correlationHeader != null) {
            this.logger.log(AWSLambdaLogger.LogLevel.INFO, "Creating transaction with correlation header: '" + correlationHeader + "'.", new Object[0]);
        } else {
            this.logger.log(AWSLambdaLogger.LogLevel.INFO, "Could not find correlation header. Will continue with null correlation header.", new Object[0]);
        }
        return correlationHeader;
    }

    private JsonObject convertInputStreamToJson(InputStream inputStream) {
        if (inputStream == null) {
            this.logger.log(AWSLambdaLogger.LogLevel.WARN, "Input stream was null. Correlation header will be left empty.", new Object[0]);
        } else if (!inputStream.markSupported()) {
            this.logger.log(AWSLambdaLogger.LogLevel.WARN, "InputStream does not support mark() and reset(). Will not attempt to read InputStream for correlation header.", new Object[0]);
        } else {
            try {
                inputStream.mark(this.headerReadLimitInBytes);
                byte[] byteArray = new byte[this.headerReadLimitInBytes];
                int bytesRead = inputStream.read(byteArray);
                inputStream.reset();
                if (bytesRead > 0) {
                    String byteArrayToString = new String(byteArray, 0, bytesRead, StandardCharsets.UTF_8);
                    return new JsonParser().parse(byteArrayToString).getAsJsonObject();
                }
                this.logger.log(AWSLambdaLogger.LogLevel.INFO, "InputStream had no parsable content. Correlation header will be left empty.", new Object[0]);
            }
            catch (JsonParseException e) {
                this.logger.log(AWSLambdaLogger.LogLevel.WARN, "InputStream was not in parsable into JSON. Correlation header will be left empty.", new Object[0]);
            }
            catch (IOException e) {
                this.logger.log(AWSLambdaLogger.LogLevel.WARN, "Exception caught while trying to fetch correlation header from InputStream: " + e.getMessage(), new Object[0]);
            }
        }
        return null;
    }
}

