/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.impl;

import com.appdynamics.serverless.tracers.aws.api.ExitCall;
import com.appdynamics.serverless.tracers.aws.api.Transaction;
import com.appdynamics.serverless.tracers.aws.impl.NoOpExitCall;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NoOpTransaction
implements Transaction {
    private final ExitCall noOpExitCall = new NoOpExitCall();
    private final AWSLambdaLogger logger;

    public NoOpTransaction(AWSLambdaLogger logger) {
        this.logger = logger;
    }

    @Override
    public void start() {
        this.logger.debug("NoOpTransaction start() called. No action will be taken.");
    }

    @Override
    public void stop() {
        this.logger.debug("NoOpTransaction stop() called. No action will be taken.");
    }

    @Override
    public ExitCall createExitCall(String exitType, Map<String, String> identifyingProperties) {
        this.logger.debug("NoOpTransaction createExitCall() called with exitType '" + exitType + "'. No action will be taken.");
        return this.noOpExitCall;
    }

    @Override
    public ExitCall createExitCall(String exitType, String exitSubType, Map<String, String> identifyingProperties) {
        this.logger.debug("NoOpTransaction createExitCall() called with exitType '" + exitType + "', and subType '" + exitSubType + "'. No action will be taken.");
        return this.noOpExitCall;
    }

    @Override
    public List<String> getEumMetadata() {
        return new ArrayList<String>();
    }

    @Override
    public String identifier() {
        return null;
    }

    @Override
    public void reportError(Throwable throwable) {
        this.logger.debug("NoOpTransaction reportError() called. No action will be taken.");
    }

    @Override
    public void reportError(String errorName, String errorMessage) {
        this.logger.debug("NoOpTransaction reportError() called. No action will be taken.");
    }
}

