/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.exit;

import com.appdynamics.serverless.tracers.aws.events.ErrorEvent;
import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.events.ExitCallEvent;
import com.appdynamics.serverless.tracers.aws.exit.CurrentExitCall;
import com.appdynamics.serverless.tracers.aws.exit.ExitCallIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.exit.RegisteredBackendInfo;
import com.appdynamics.serverless.tracers.aws.impl.TransactionImpl;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.resolution.AExitComponent;
import com.appdynamics.serverless.tracers.aws.resolution.ExitComponent;
import com.appdynamics.serverless.tracers.aws.resolution.ExitFederatedAppComponent;
import com.appdynamics.serverless.tracers.aws.resolution.ExitForeignAppComponent;
import com.appdynamics.serverless.tracers.aws.resolution.UnresolvedExitComponent;
import com.appdynamics.serverless.tracers.aws.transactions.CurrentTransactionContext;
import com.appdynamics.serverless.tracers.aws.transactions.TransactionMonitoringContext;

public class RegisteredExitCall
implements CurrentExitCall {
    private ExitCallIdentifyingInfo exitCallIdentifyingInfo;
    private RegisteredBackendInfo registeredBackendInfo;
    private long startTimestampInMs;
    private AExitComponent exitComponent;
    private String correlationHeader;
    private TransactionImpl transactionImpl;
    private final TransactionMonitoringContext txContext;
    private byte state = 0;

    public RegisteredExitCall(ExitCallIdentifyingInfo exitCallIdentifyingInfo, RegisteredBackendInfo registeredBackendInfo, TransactionImpl transactionImpl, TransactionMonitoringContext txContext) {
        this.txContext = txContext;
        this.exitCallIdentifyingInfo = exitCallIdentifyingInfo;
        this.registeredBackendInfo = registeredBackendInfo;
        this.transactionImpl = transactionImpl;
        this.setupExitComponent(registeredBackendInfo);
    }

    @Override
    public String getExitType() {
        return this.registeredBackendInfo.getExitType();
    }

    @Override
    public String getExitSubtype() {
        return this.registeredBackendInfo.getExitSubType();
    }

    @Override
    public String getBackendId() {
        return this.exitComponent.getExitComponentAsStr();
    }

    @Override
    public AExitComponent getExitComponent() {
        return this.exitComponent;
    }

    @Override
    public long getExitId() {
        return this.exitComponent.getBackendId();
    }

    @Override
    public long getStartTimeInMs() {
        return this.startTimestampInMs;
    }

    public void setCorrelationHeader(String correlationHeader) {
        this.correlationHeader = correlationHeader;
    }

    @Override
    public void start() {
        if ((this.state & 1) == 1) {
            return;
        }
        this.startTimestampInMs = System.currentTimeMillis();
        this.state = (byte)(this.state | 1);
    }

    @Override
    public void stop() {
        if ((this.state & 1) != 1 || (this.state & 2) == 2) {
            return;
        }
        long endTimeInMs = System.currentTimeMillis();
        CurrentTransactionContext ctc = this.transactionImpl.getCurrentTransactionContext();
        if (null != ctc) {
            ExitCallEvent exitCallEvent = new ExitCallEvent(ctc.getAccountGUID(), Event.Type.EXIT_CALL.name(), ctc.getApplicationID(), ctc.getBtId(), ctc.getComponentID(), ctc.getCallerChainAsString(), ctc.getRequestGUID(), this.startTimestampInMs, endTimeInMs, "REGISTERED", this.getExitId(), "1");
            this.txContext.getEventManager().offer(exitCallEvent);
            this.transactionImpl.removeExitCall(this.correlationHeader);
        }
        this.state = (byte)(this.state | 2);
    }

    @Override
    public String getCorrelationHeader() {
        return this.correlationHeader;
    }

    @Override
    public void reportError(Throwable throwable) {
        this.reportHttpError(throwable, 0);
    }

    @Override
    public void reportError(String errorName, String errorMessage) {
        this.reportHttpError(errorName, errorMessage, 0);
    }

    @Override
    public void reportHttpError(Throwable throwable, int httpStatusCode) {
        CurrentTransactionContext ctc = this.transactionImpl.getCurrentTransactionContext();
        if (null == ctc) {
            this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "CTC is null. Ensure that the transaction is started", new Object[0]);
            return;
        }
        String errorName = this.txContext.getErrorHelper().generateDisplayName(throwable);
        String errorMessage = this.txContext.getErrorHelper().generateDetail(throwable);
        this.reportHttpError(errorName, errorMessage, httpStatusCode);
    }

    @Override
    public void reportHttpError(String errorName, String errorMessage, int httpStatusCode) {
        CurrentTransactionContext ctc = this.transactionImpl.getCurrentTransactionContext();
        if (null == ctc) {
            this.txContext.getLogger().log(AWSLambdaLogger.LogLevel.DEBUG, "CTC is null. Ensure that the transaction is started", new Object[0]);
            return;
        }
        long endTimeInMs = System.currentTimeMillis();
        ErrorEvent errorEvent = ctc.getBtId() != 0L ? new ErrorEvent(Event.Type.ERROR.name(), ctc.getBtId(), this.getExitComponent().getBackendId(), ctc.getCallerChainAsString(), errorName, errorMessage, "1", httpStatusCode, ctc.getStartTimeInMs(), endTimeInMs, ctc.getRequestGUID()) : new ErrorEvent(Event.Type.ERROR.name(), this.getExitComponent().getBackendId(), ctc.getCallerChainAsString(), errorName, errorMessage, "1", httpStatusCode, ctc.getStartTimeInMs(), endTimeInMs, ctc.getRequestGUID(), this.txContext.getBtName(), "POJO");
        this.txContext.getEventManager().offer(errorEvent);
    }

    private void setupExitComponent(RegisteredBackendInfo registeredBackendInfo) {
        switch (registeredBackendInfo.getResolvedToEntityType()) {
            case COMPONENT: {
                this.exitComponent = new ExitComponent(registeredBackendInfo.getResolvedToEntityId(), registeredBackendInfo.getBackendId());
                break;
            }
            case FOREIGN_APP: {
                this.exitComponent = new ExitForeignAppComponent(registeredBackendInfo.getResolvedToEntityId(), registeredBackendInfo.getBackendId());
                break;
            }
            case FEDERATED_APP: {
                this.exitComponent = new ExitFederatedAppComponent(registeredBackendInfo.getFederatedAccountGuid(), registeredBackendInfo.getFederatedAppId(), registeredBackendInfo.getBackendId());
                break;
            }
            case UNRESOLVED: {
                this.exitComponent = new UnresolvedExitComponent(registeredBackendInfo.getBackendId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown backend resolution type");
            }
        }
    }
}

