/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.events;

import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.annotations.SerializedName;
import java.util.Objects;

public class ErrorEvent
implements Event {
    @SerializedName(value="event_type")
    private String eventType;
    @SerializedName(value="bt_id")
    private long btId;
    @SerializedName(value="backend_id")
    private long backendId;
    @SerializedName(value="caller_chain")
    private String callerChain;
    @SerializedName(value="error_name")
    private String errorName;
    @SerializedName(value="error_message")
    private String errorMessage;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="http_status_code")
    private int httpStatusCode;
    @SerializedName(value="start_time")
    private long startTime;
    @SerializedName(value="end_time")
    private long endTime;
    @SerializedName(value="transaction_guid")
    private String transactionGuid;
    @SerializedName(value="entry_point_name")
    private String entryPointName;
    @SerializedName(value="entry_point_type")
    private String entryPointType;

    public ErrorEvent(String eventType, long btId, long backendId, String callerChain, String errorName, String errorMessage, String version, int httpStatusCode, long startTime, long endTime, String transactionGuid) {
        this(eventType, btId, backendId, callerChain, errorName, errorMessage, version, httpStatusCode, startTime, endTime, transactionGuid, null, null);
    }

    public ErrorEvent(String eventType, long backendId, String callerChain, String errorName, String errorMessage, String version, int httpStatusCode, long startTime, long endTime, String transactionGuid, String entryPointName, String entryPointType) {
        this(eventType, 0L, backendId, callerChain, errorName, errorMessage, version, httpStatusCode, startTime, endTime, transactionGuid, entryPointName, entryPointType);
    }

    private ErrorEvent(String eventType, long btId, long backendId, String callerChain, String errorName, String errorMessage, String version, int httpStatusCode, long startTime, long endTime, String transactionGuid, String entryPointName, String entryPointType) {
        this.eventType = eventType;
        this.btId = btId;
        this.backendId = backendId;
        this.callerChain = callerChain;
        this.errorName = errorName;
        this.errorMessage = errorMessage;
        this.version = version;
        this.httpStatusCode = httpStatusCode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.transactionGuid = transactionGuid;
        this.entryPointName = entryPointName;
        this.entryPointType = entryPointType;
    }

    public boolean testEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorEvent that = (ErrorEvent)o;
        return this.btId == that.btId && this.backendId == that.backendId && this.httpStatusCode == that.httpStatusCode && Objects.equals(this.eventType, that.eventType) && Objects.equals(this.callerChain, that.callerChain) && Objects.equals(this.errorName, that.errorName) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.version, that.version) && Objects.equals(this.transactionGuid, that.transactionGuid) && Objects.equals(this.entryPointName, that.entryPointName) && Objects.equals(this.entryPointType, that.entryPointType);
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getBtId() {
        return this.btId;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public String getCallerChain() {
        return this.callerChain;
    }

    public String getErrorName() {
        return this.errorName;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getVersion() {
        return this.version;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getTransactionGuid() {
        return this.transactionGuid;
    }

    public String getEntryPointName() {
        return this.entryPointName;
    }

    public String getEntryPointType() {
        return this.entryPointType;
    }

    @Override
    public boolean isColdStartEvent() {
        return this.btId == 0L && StringOperations.isNotEmpty(this.entryPointName) && StringOperations.isNotEmpty(this.entryPointType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorEvent that = (ErrorEvent)o;
        return this.btId == that.btId && this.backendId == that.backendId && this.httpStatusCode == that.httpStatusCode && Objects.equals(this.eventType, that.eventType) && Objects.equals(this.callerChain, that.callerChain) && Objects.equals(this.errorName, that.errorName) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.version, that.version) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.transactionGuid, that.transactionGuid) && Objects.equals(this.entryPointName, that.entryPointName) && Objects.equals(this.entryPointType, that.entryPointType);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.btId, this.backendId, this.callerChain, this.errorName, this.errorMessage, this.version, this.httpStatusCode, this.startTime, this.endTime, this.transactionGuid, this.entryPointName, this.entryPointType);
    }

    public String toString() {
        return "ErrorEvent{eventType='" + this.eventType + '\'' + ", btId=" + this.btId + ", backendId=" + this.backendId + ", callerChain='" + this.callerChain + '\'' + ", errorName='" + this.errorName + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", version='" + this.version + '\'' + ", httpStatusCode=" + this.httpStatusCode + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", transactionGuid=" + this.transactionGuid + ", entryPointName=" + this.entryPointName + ", entryPointType=" + this.entryPointType + '}';
    }
}

