/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.events;

import com.appdynamics.serverless.tracers.aws.events.Event;
import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.annotations.SerializedName;

public class BTEvent
implements Event {
    @SerializedName(value="event_type")
    private String eventType;
    @SerializedName(value="bt_id")
    private long btId;
    @SerializedName(value="transaction_guid")
    private String transactionGuid;
    @SerializedName(value="start_time")
    private long startTime;
    @SerializedName(value="end_time")
    private long endTime;
    @SerializedName(value="caller_chain")
    private String callerChain;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="entry_point_name")
    private String entryPointName;
    @SerializedName(value="entry_point_type")
    private String entryPointType;

    public BTEvent(String eventType, long btId, String transactionGuid, long startTime, long endTime, String callerChain, String version) {
        this(eventType, btId, transactionGuid, startTime, endTime, callerChain, version, null, null);
    }

    public BTEvent(String eventType, String transactionGuid, long startTime, long endTime, String callerChain, String version, String entryPointName, String entryPointType) {
        this(eventType, 0L, transactionGuid, startTime, endTime, callerChain, version, entryPointName, entryPointType);
    }

    private BTEvent(String eventType, long btId, String transactionGuid, long startTime, long endTime, String callerChain, String version, String entryPointName, String entryPointType) {
        this.eventType = eventType;
        this.btId = btId;
        this.transactionGuid = transactionGuid;
        this.startTime = startTime;
        this.endTime = endTime;
        this.callerChain = callerChain != null ? callerChain : "";
        this.version = version;
        this.entryPointName = entryPointName;
        this.entryPointType = entryPointType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getBtId() {
        return this.btId;
    }

    public String getTransactionGuid() {
        return this.transactionGuid;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getCallerChain() {
        return this.callerChain;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEntryPointName() {
        return this.entryPointName;
    }

    public String getEntryPointType() {
        return this.entryPointType;
    }

    @Override
    public boolean isColdStartEvent() {
        return this.btId == 0L && StringOperations.isNotEmpty(this.entryPointName) && StringOperations.isNotEmpty(this.entryPointType);
    }

    public String toString() {
        return "BTEvent{eventType='" + this.eventType + '\'' + ", btId=" + this.btId + ", transactionGuid='" + this.transactionGuid + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", callerChain='" + this.callerChain + '\'' + ", version='" + this.version + '\'' + ", entryPointName='" + this.entryPointName + '\'' + ", entryPointType='" + this.entryPointType + '\'' + '}';
    }
}

