/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.errors;

import com.appdynamics.serverless.tracers.aws.errors.ErrorDetail;
import com.appdynamics.serverless.tracers.aws.errors.ExceptionOperations;
import com.appdynamics.serverless.tracers.aws.errors.LightWeightThrowable;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;

public class ErrorHelper {
    public static final int DEFAULT_STACKTRACE_LINE_LIMIT = 200;
    public static final int DEFAULT_TOTAL_STACKTRACE_CHARACTER_COUNT_LIMIT = 4500;
    public static final int DEFAULT_STACKTRACE_DEPTH = 5000;
    private static final String KEY_SEPARATOR = ":";
    private static final char NEW_LINE = '\n';
    private final AWSLambdaLogger logger;
    private final ExceptionOperations exceptionOperations;
    private final int stackTraceLineLimitPerThrowable;
    private final int totalStackTraceCharacterCountLimit;

    public ErrorHelper(AWSLambdaLogger logger, ExceptionOperations exceptionOperations, int stackTraceLineLimitPerThrowable, int totalStackTraceCharacterCountLimit) {
        this.logger = logger;
        this.exceptionOperations = exceptionOperations;
        this.stackTraceLineLimitPerThrowable = stackTraceLineLimitPerThrowable;
        this.totalStackTraceCharacterCountLimit = totalStackTraceCharacterCountLimit <= 4500 ? totalStackTraceCharacterCountLimit : 4500;
    }

    public ErrorHelper(AWSLambdaLogger logger, ExceptionOperations exceptionOperations) {
        this(logger, exceptionOperations, 200, 4500);
    }

    public int getTotalStackTraceCharacterCountLimit() {
        return this.totalStackTraceCharacterCountLimit;
    }

    public String generateDisplayName(Throwable t) {
        StringBuilder sb = new StringBuilder();
        for (Throwable current = t; current != null; current = current.getCause()) {
            if (sb.length() > 0) {
                sb.append(KEY_SEPARATOR);
            }
            sb.append(current.getClass().getSimpleName());
        }
        return sb.toString();
    }

    public String generateDetail(Throwable t) {
        ErrorDetail errorDetail = new ErrorDetail(this.totalStackTraceCharacterCountLimit);
        this.fillInStackTrace(errorDetail, new LightWeightThrowable(t, this.logger, this.exceptionOperations), t.getStackTrace(), false);
        return errorDetail.getDetail();
    }

    public String generateDetailTruncated(Throwable t) {
        ErrorDetail errorDetail = new ErrorDetail(this.totalStackTraceCharacterCountLimit);
        this.fillInStackTrace(errorDetail, new LightWeightThrowable(t, this.logger, this.exceptionOperations), t.getStackTrace(), true);
        return errorDetail.toString();
    }

    void fillInStackTrace(ErrorDetail errorDetail, LightWeightThrowable t, StackTraceElement[] trace, boolean truncated) {
        LightWeightThrowable ourCause;
        int traceLength = truncated ? 2 : trace.length;
        errorDetail.append(t.getFullyQualifiedName()).append('\n');
        try {
            errorDetail.append(t.getMessage()).append('\n');
        }
        catch (Throwable e) {
            errorDetail.append("Failed to get error message");
        }
        if (trace.length < traceLength) {
            traceLength = trace.length;
        }
        int count = 0;
        for (int i = 0; i < traceLength; ++i) {
            errorDetail.append('\t').append("at ");
            this.appendTraceElement(trace[i], errorDetail);
            if (count++ >= this.stackTraceLineLimitPerThrowable) {
                this.appendStackLinesLimitReached(errorDetail, traceLength - 1);
                break;
            }
            if (!errorDetail.isLimitReached()) continue;
            this.appendTotalStackTraceLimitReached(errorDetail);
            return;
        }
        if ((ourCause = t.getCause()) != null) {
            this.printStackTraceAsCause(errorDetail, trace, ourCause, traceLength, truncated);
        }
    }

    private void printStackTraceAsCause(ErrorDetail errorDetail, StackTraceElement[] causedTrace, LightWeightThrowable me, int traceLength, boolean truncated) {
        LightWeightThrowable ourCause;
        StackTraceElement[] ourTrace = me.getTrace();
        int m = ourTrace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && ourTrace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = ourTrace.length - 1 - m;
        errorDetail.append("Caused by: ").append(me.toString()).append('\n');
        if (truncated && m > traceLength) {
            m = traceLength - 1;
        }
        int count = 0;
        for (int i = 0; i <= m; ++i) {
            errorDetail.append('\t').append("at ");
            this.appendTraceElement(ourTrace[i], errorDetail);
            if (count++ >= this.stackTraceLineLimitPerThrowable) {
                this.appendStackLinesLimitReached(errorDetail, m - 1);
                break;
            }
            if (!errorDetail.isLimitReached()) continue;
            this.appendTotalStackTraceLimitReached(errorDetail);
            return;
        }
        if (framesInCommon != 0) {
            errorDetail.append("\t... ").append(Integer.toString(framesInCommon)).append(" more").append('\n');
        }
        if ((ourCause = me.getCause()) != null) {
            this.printStackTraceAsCause(errorDetail, ourTrace, ourCause, traceLength, truncated);
        }
    }

    private void appendStackLinesLimitReached(ErrorDetail errorDetail, int remaining) {
        errorDetail.forceappend('\n').forceappend(Integer.toString(remaining)).forceappend(" more lines truncated. ").forceappend("stack-trace-line-limit (").forceappend(Integer.toString(this.stackTraceLineLimitPerThrowable)).forceappend(") reached.").forceappend('\n');
    }

    private void appendTotalStackTraceLimitReached(ErrorDetail errorDetail) {
        errorDetail.forceappend('\n').forceappend(" All lines after this truncated as total-stack-trace-character-count-limit (").forceappend(Integer.toString(this.totalStackTraceCharacterCountLimit)).forceappend(") reached.").forceappend('\n');
    }

    private void appendTraceElement(StackTraceElement te, ErrorDetail errorDetail) {
        String fileName = te.getFileName();
        int lineNumber = te.getLineNumber();
        errorDetail.append(te.getClassName()).append('.').append(te.getMethodName()).append(te.isNativeMethod() ? "(Native Method)" : (fileName != null && lineNumber >= 0 ? "(" + fileName + KEY_SEPARATOR + lineNumber + ")" : (fileName != null ? "(" + fileName + ")" : "(Unknown Source)"))).append('\n');
    }
}

