/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.correlation;

import com.appdynamics.serverless.tracers.aws.correlation.EumSubCookie;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EumMetadataCollector {
    private Map<String, String> subCookies = new LinkedHashMap<String, String>();

    public EumMetadataCollector(String guid, String globalAcctName) {
        this.subCookies.put(EumSubCookie.CLIENT_REQUEST_GUID.toString(), guid);
        this.subCookies.put(EumSubCookie.GLOBAL_ACCOUNT_KEY.toString(), globalAcctName);
    }

    public void setBTDuration(long btId, long btDuration) {
        this.subCookies.put(EumSubCookie.BT_ID.toString(), Long.toString(btId));
        this.subCookies.put(EumSubCookie.BT_DURATION.toString(), Long.toString(btDuration));
    }

    public List<String> getMetadataForResponseHeaders() {
        return this.subCookies.entrySet().stream().map(entry -> this.getKeyValue((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    private String getKeyValue(String key, String value) {
        return key + ':' + value;
    }
}

