/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.correlation;

import com.appdynamics.serverless.tracers.aws.exit.TransactionExitPointType;
import java.util.Objects;

public class ComponentLink {
    private final String fromComponentID;
    private final String toComponentID;
    private final TransactionExitPointType exitPointType;
    private final String exitPointSubType;
    private volatile String latestThreadAddId;

    ComponentLink(String fromComponentID, String toComponentID, TransactionExitPointType exitPointType) {
        this.fromComponentID = fromComponentID;
        this.toComponentID = toComponentID;
        this.exitPointType = exitPointType;
        this.exitPointSubType = exitPointType == null ? null : exitPointType.name();
    }

    ComponentLink(String fromComponentID, String toComponentID, TransactionExitPointType exitPointType, String exitPointSubType) {
        this.fromComponentID = fromComponentID;
        this.toComponentID = toComponentID;
        this.exitPointType = exitPointType;
        this.exitPointSubType = exitPointSubType;
    }

    public String getLatestThreadAddId() {
        return this.latestThreadAddId;
    }

    public void setLatestThreadAddId(String latestThreadAddId) {
        this.latestThreadAddId = latestThreadAddId;
    }

    public String getFromComponentID() {
        return this.fromComponentID;
    }

    public String getToComponentID() {
        return this.toComponentID;
    }

    public TransactionExitPointType getExitPointType() {
        return this.exitPointType;
    }

    public String getExitPointSubType() {
        return this.exitPointSubType;
    }

    public int getMetricSegmentLength() {
        int len = 30 + this.fromComponentID.length() + (this.exitPointType != null ? this.exitPointType.name().length() : 0) + (this.toComponentID != null ? this.toComponentID.length() : 0);
        if (this.latestThreadAddId != null) {
            len += this.latestThreadAddId.length();
        }
        return len;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentLink that = (ComponentLink)o;
        return Objects.equals(this.fromComponentID, that.fromComponentID) && Objects.equals(this.toComponentID, that.toComponentID) && this.exitPointType == that.exitPointType && Objects.equals(this.exitPointSubType, that.exitPointSubType) && Objects.equals(this.latestThreadAddId, that.latestThreadAddId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fromComponentID, this.toComponentID, this.exitPointType, this.exitPointSubType, this.latestThreadAddId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Component From[").append(this.fromComponentID).append("] Thread Chains [");
        if (this.latestThreadAddId != null) {
            sb.append(this.latestThreadAddId);
        }
        sb.append("], Exit Type [").append((Object)this.exitPointType).append("] To [").append(this.toComponentID).append("]");
        return sb.toString();
    }
}

