/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.api;

import com.appdynamics.serverless.tracers.aws.api.AppDynamics;
import com.appdynamics.serverless.tracers.aws.api.Tracer;
import com.appdynamics.serverless.tracers.aws.exit.ExitCallIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.exit.RegisteredBackendInfo;
import com.appdynamics.serverless.tracers.aws.impl.NoOpTracer;
import com.appdynamics.serverless.tracers.aws.impl.TracerImpl;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.registration.AgentConfig;
import com.appdynamics.serverless.tracers.aws.registration.RegistrationResponse;
import com.appdynamics.serverless.tracers.aws.registration.RegistrationService;
import com.appdynamics.serverless.tracers.aws.transactions.BTIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.transactions.RegisteredBT;
import com.appdynamics.serverless.tracers.aws.transactions.TransactionMonitoringContext;
import com.appdynamics.serverless.tracers.aws.utils.PropertyUtil;
import com.appdynamics.serverless.tracers.dependencies.feign.FeignException;
import com.appdynamics.serverless.tracers.dependencies.feign.RetryableException;
import java.util.concurrent.Callable;

public class TracerBuilder
implements Callable<Tracer> {
    private final Tracer noOpTracer;
    private AppDynamics.Config config;
    private AWSLambdaLogger logger;
    private TransactionMonitoringContext txContext;
    private RegistrationService registrationService;

    public TracerBuilder(TransactionMonitoringContext txContext, RegistrationService registrationService, AppDynamics.Config config, AWSLambdaLogger logger) {
        this.config = config;
        this.logger = logger;
        this.noOpTracer = new NoOpTracer(logger);
        this.registrationService = registrationService;
        this.txContext = txContext;
    }

    @Override
    public Tracer call() {
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Starting call to build tracer.", new Object[0]);
        Tracer tracer = this.noOpTracer;
        try {
            tracer = this.buildTracer();
        }
        catch (RetryableException e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "ERROR registering tracer => Tracer was not able to connect as the URL defined in 'APPDYNAMICS_SERVERLESS_API_ENDPOINT' environment variable is not accessible or invalid: " + e, new Object[0]);
        }
        catch (FeignException e) {
            this.logger.log(AWSLambdaLogger.LogLevel.ERROR, "ERROR registering tracer => Tracer failed to authenticate. Try verifying the 'APPDYNAMICS_ACCOUNT_NAME', 'APPDYNAMICS_SERVERLESS_API_ENDPOINT', and 'APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY' environment variables." + e, new Object[0]);
        }
        catch (Throwable t) {
            this.logger.log(AWSLambdaLogger.LogLevel.WARN, "ERROR registering tracer => " + t, new Object[0]);
        }
        return tracer;
    }

    Tracer buildTracer() {
        RegistrationResponse response = this.getRegistrationResponse(this.config);
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Received registration response: %s", response);
        if (response.registeredIdsAvailable()) {
            this.txContext.getReadWriteLock().writeLock().lock();
            try {
                this.txContext.setAccountGUID(response.getAccountGuid());
                this.txContext.setControllerGUID(response.getControllerGuid());
                this.txContext.setApplicationId(response.getApplicationId());
                this.txContext.setGlobalAccountName(response.getGlobalAccountName());
                this.txContext.setTierId(response.getTierId());
                this.txContext.setTimeSkew(response.getTimeskew());
                this.txContext.setLagging(response.isLagging());
                this.txContext.setDefaultBtName(this.config.getDefaultBtName());
                this.handleRegisteredBackends(response, this.txContext);
                this.handleRegisteredBTs(response, this.txContext);
            }
            finally {
                this.txContext.getReadWriteLock().writeLock().unlock();
            }
            return new TracerImpl(this.txContext, this.config.getHeaderReadLimit());
        }
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Invalid registration response; returning no-op tracer", new Object[0]);
        return new NoOpTracer(this.logger);
    }

    RegistrationResponse getRegistrationResponse(AppDynamics.Config config) {
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Sending registration request...", new Object[0]);
        AgentConfig agentConfig = new AgentConfig(config);
        RegistrationResponse registrationResponse = this.registrationService.getConfig(agentConfig);
        this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Received registration response => %s", registrationResponse);
        return registrationResponse;
    }

    void handleRegisteredBackends(RegistrationResponse response, TransactionMonitoringContext txContext) {
        if (null != response.getRegisteredBackendInfos()) {
            response.getRegisteredBackendInfos().stream().forEach(registeredBackendInfo -> {
                ExitCallIdentifyingInfo exitCallIdentifyingInfo = new ExitCallIdentifyingInfo(registeredBackendInfo.getExitType(), registeredBackendInfo.getExitSubType(), PropertyUtil.toMap(registeredBackendInfo.getIdentifyingProperties()));
                txContext.getExitCallInfoToRegisteredInfoCache().put(exitCallIdentifyingInfo, (RegisteredBackendInfo)registeredBackendInfo);
            });
        }
    }

    void handleRegisteredBTs(RegistrationResponse response, TransactionMonitoringContext txContext) {
        if (null != response.getRegisteredBTs()) {
            response.getRegisteredBTs().stream().forEach(registeredBT -> {
                BTIdentifyingInfo btIdentifyingInfo = new BTIdentifyingInfo(registeredBT.getName(), registeredBT.getEntryPointType());
                txContext.getBtInfoToRegisteredInfoCache().put(btIdentifyingInfo, (RegisteredBT)registeredBT);
            });
        }
    }
}

