/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.api;

import com.appdynamics.serverless.tracers.dependencies.com.google.gson.Gson;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LambdaOutput<T> {
    private static final Gson gson = new GsonBuilder().serializeNulls().create();
    private boolean isBase64Encoded;
    private int statusCode;
    private Map<String, String> headers;
    private Map<String, List<String>> multiValueHeaders;
    private String body;
    private transient Class<T> classType;

    public LambdaOutput() {
        this.isBase64Encoded = false;
        this.statusCode = 200;
        this.headers = Collections.emptyMap();
        this.body = "{}";
    }

    public LambdaOutput(boolean isBase64Encoded, int statusCode, Map<String, String> headers, Map<String, List<String>> multiValueHeaders, String body) {
        this.isBase64Encoded = isBase64Encoded;
        this.statusCode = statusCode;
        this.headers = headers;
        this.multiValueHeaders = multiValueHeaders;
        this.classType = String.class;
        this.body = body;
    }

    public LambdaOutput(boolean isBase64Encoded, int statusCode, Map<String, String> headers, Map<String, List<String>> multiValueHeaders, T body) {
        this.isBase64Encoded = isBase64Encoded;
        this.statusCode = statusCode;
        this.headers = headers;
        this.multiValueHeaders = multiValueHeaders;
        if (body == null) {
            this.classType = null;
            this.body = null;
        } else {
            this.classType = body.getClass();
            this.body = gson.toJson(body, this.classType);
        }
    }

    public String toJsonString() {
        return gson.toJson(this);
    }

    public boolean getIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    public void setIsBase64Encoded(boolean isBase64Encoded) {
        this.isBase64Encoded = isBase64Encoded;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> getMultiValueHeaders() {
        return this.multiValueHeaders;
    }

    public void setMultiValueHeaders(Map<String, List<String>> multiValueHeaders) {
        this.multiValueHeaders = multiValueHeaders;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = gson.toJson(body, this.classType);
    }

    public T deserializeBody() {
        return gson.fromJson(this.body, this.classType);
    }
}

