/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.aws.api;

import com.appdynamics.serverless.tracers.aws.api.AppDynamicsBuilder;
import com.appdynamics.serverless.tracers.aws.api.Tracer;
import com.appdynamics.serverless.tracers.aws.api.TracerBuilder;
import com.appdynamics.serverless.tracers.aws.correlation.TransactionCorrelator;
import com.appdynamics.serverless.tracers.aws.errors.ErrorHelper;
import com.appdynamics.serverless.tracers.aws.exit.ExitCallIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.exit.RegisteredBackendInfo;
import com.appdynamics.serverless.tracers.aws.impl.NoOpTracer;
import com.appdynamics.serverless.tracers.aws.impl.TracerImpl;
import com.appdynamics.serverless.tracers.aws.logging.AWSLambdaLogger;
import com.appdynamics.serverless.tracers.aws.logging.CloudWatchLoggerFactory;
import com.appdynamics.serverless.tracers.aws.logging.SysOutLogger;
import com.appdynamics.serverless.tracers.aws.publish.EventManager;
import com.appdynamics.serverless.tracers.aws.registration.RegistrationService;
import com.appdynamics.serverless.tracers.aws.transactions.BTIdentifyingInfo;
import com.appdynamics.serverless.tracers.aws.transactions.RegisteredBT;
import com.appdynamics.serverless.tracers.aws.transactions.TransactionMonitoringContext;
import com.appdynamics.serverless.tracers.aws.utils.AWSLambdaContextUtil;
import com.appdynamics.serverless.tracers.aws.utils.EnvironmentVariableUtil;
import com.appdynamics.serverless.tracers.aws.utils.StringOperations;
import com.appdynamics.serverless.tracers.dependencies.feign.Util;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AppDynamics {
    private static final AWSLambdaLogger sysOutLogger = new SysOutLogger(AWSLambdaLogger.LogLevel.INFO);
    private static final Tracer noOpTracer = new NoOpTracer(sysOutLogger);
    private final AWSLambdaLogger logger;
    static final long AGENT_CONFIG_UNSET_TIMEOUT = -1L;
    static AppDynamics instance;
    ExecutorService executorService;
    Tracer tracer;
    Future<Tracer> tracerFuture;
    long lastConfigSuccess;
    long agentConfigUpdatePeriodMs;
    private final RegistrationService registrationService;
    private final Config config;
    private final Map<ExitCallIdentifyingInfo, RegisteredBackendInfo> exitCallInfoToRegisteredInfoCache;
    private final Map<BTIdentifyingInfo, RegisteredBT> btInfoToRegisteredInfoCache;
    private final EventManager eventManager;
    private final TransactionCorrelator transactionCorrelator;
    private final ErrorHelper errorHelper;
    private static final List<String> PROXY_REQUIRED_VARIABLES;
    private static final long AGENT_CONFIG_RETRY_TIMEOUT_MILLIS;
    private static final long AGENT_CONFIG_FUTURE_TIMEOUT;

    AppDynamics(RegistrationService registrationService, EventManager eventManager, TransactionCorrelator txCorrelator, ErrorHelper errorHelper, Config config, AWSLambdaLogger logger) {
        this.registrationService = registrationService;
        this.eventManager = eventManager;
        this.transactionCorrelator = txCorrelator;
        this.errorHelper = errorHelper;
        this.exitCallInfoToRegisteredInfoCache = new HashMap<ExitCallIdentifyingInfo, RegisteredBackendInfo>();
        this.btInfoToRegisteredInfoCache = new HashMap<BTIdentifyingInfo, RegisteredBT>();
        this.lastConfigSuccess = System.currentTimeMillis();
        this.agentConfigUpdatePeriodMs = -1L;
        this.config = config;
        this.logger = logger;
    }

    public static Tracer getTracer(Object context) {
        int controllerPort;
        String accountName = "";
        String appName = "";
        String controllerAccessKey = "";
        try {
            Util.checkNotNull(context, "Context passed into getTracer() was null. Returning a NoOpTracer.", new Object[0]);
            accountName = Util.checkNotNull(System.getenv("APPDYNAMICS_ACCOUNT_NAME"), "Environment variable 'APPDYNAMICS_ACCOUNT_NAME' was left null. Returning a NoOpTracer.", new Object[0]);
            appName = Util.checkNotNull(System.getenv("APPDYNAMICS_APPLICATION_NAME"), "Environment variable 'APPDYNAMICS_APPLICATION_NAME' was left null. Returning a NoOpTracer.", new Object[0]);
            controllerAccessKey = Util.checkNotNull(System.getenv("APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY"), "Environment variable 'APPDYNAMICS_AGENT_ACCOUNT_ACCESS_KEY' was left null. Returning a NoOpTracer.", new Object[0]);
            controllerPort = Integer.parseInt(System.getenv("APPDYNAMICS_CONTROLLER_PORT"));
        }
        catch (NullPointerException e) {
            sysOutLogger.log(AWSLambdaLogger.LogLevel.WARN, e.getMessage(), new Object[0]);
            return noOpTracer;
        }
        catch (NumberFormatException e) {
            sysOutLogger.log(AWSLambdaLogger.LogLevel.WARN, "Environment variable APPDYNAMICS_CONTROLLER_PORT does not have a valid integer for parsing. Defaulting to 443.", new Object[0]);
            controllerPort = 443;
        }
        String controllerHost = System.getenv("APPDYNAMICS_CONTROLLER_HOST");
        String tierName = System.getenv("APPDYNAMICS_TIER_NAME");
        String defaultBtName = System.getenv("APPDYNAMICS_DEFAULT_BT_NAME");
        int headerReadLimit = EnvironmentVariableUtil.getEnvInt("APPDYNAMICS_INPUT_STREAM_READ_LIMIT", 6);
        Config.Builder configBuilder = new Config.Builder();
        configBuilder.accountName(accountName).applicationName(appName).tierName(tierName).controllerHost(controllerHost).controllerPort(controllerPort).controllerAccessKey(controllerAccessKey).defaultBtName(defaultBtName).lambdaContext(context).headerReadLimit(headerReadLimit);
        return AppDynamics.getTracer(configBuilder.build());
    }

    public static synchronized Tracer getTracer(Config config) {
        block13: {
            sysOutLogger.log(AWSLambdaLogger.LogLevel.INFO, "Creating AppDynamics Tracer with version: '" + AppDynamics.getVersion() + "'.", new Object[0]);
            String isDisabled = System.getenv("APPDYNAMICS_DISABLE_AGENT");
            if (Boolean.valueOf(isDisabled).booleanValue()) {
                sysOutLogger.log(AWSLambdaLogger.LogLevel.WARN, "Failed to create a tracer: Instrumentation is disabled. Returning a NoOpTracer instance.", new Object[0]);
            } else if (config == null) {
                sysOutLogger.log(AWSLambdaLogger.LogLevel.ERROR, "Failed to create a tracer: Tracer configuration was null.", new Object[0]);
            } else if (config.isNoOpConfig()) {
                sysOutLogger.log(AWSLambdaLogger.LogLevel.ERROR, "Failed to create a tracer: Configuration headers were missing all necessary values.", new Object[0]);
            } else if (!AppDynamics.areAllProxyVariablesPresent()) {
                sysOutLogger.log(AWSLambdaLogger.LogLevel.WARN, String.format("Failed to create a tracer: not all required environment variables for proxying were present. Please ensure that either all (or none) of the following variables are defined: %s", PROXY_REQUIRED_VARIABLES), new Object[0]);
            } else {
                try {
                    if (instance == null) {
                        CloudWatchLoggerFactory cloudWatchLoggerFactory = new CloudWatchLoggerFactory(config);
                        instance = new AppDynamicsBuilder(cloudWatchLoggerFactory).build(config);
                    }
                    instance.createAndUpdateTracer();
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    sysOutLogger.log(AWSLambdaLogger.LogLevel.WARN, "ERROR registering tracer => Tracer instantiation threw exception when running in parallel: " + e, new Object[0]);
                }
                catch (NoSuchAlgorithmException e) {
                    sysOutLogger.log(AWSLambdaLogger.LogLevel.WARN, "ERROR registering tracer => AppDynamics cannot find SHA-256. Willreturn NoOpTracer.", new Object[0]);
                }
                catch (Throwable t) {
                    sysOutLogger.log(AWSLambdaLogger.LogLevel.ERROR, "ERROR registering tracer => " + t, new Object[0]);
                    if (!t.getMessage().contains("unable to find valid certification path") || !AppDynamics.areAllProxyVariablesPresent()) break block13;
                    sysOutLogger.log(AWSLambdaLogger.LogLevel.ERROR, "SSL Handshake with proxy server failed; please ensure that your proxy server's certificate is part of the deployment package and configured via the %s environment variable.%n", "APPDYNAMICS_HTTP_PROXY_SERVER_CERTIFICATE");
                }
            }
        }
        return AppDynamics.getCurrentTracer();
    }

    private static boolean areAllProxyVariablesPresent() {
        return PROXY_REQUIRED_VARIABLES.stream().allMatch(var -> System.getenv(var) == null) || PROXY_REQUIRED_VARIABLES.stream().allMatch(var -> System.getenv(var) != null);
    }

    public static void cleanup() {
        if (instance != null) {
            try {
                instance.extractTracerFromFuture();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                sysOutLogger.log(AWSLambdaLogger.LogLevel.DEBUG, "TracerBuilder encountered errors while shutting down: " + e, new Object[0]);
            }
            finally {
                if (AppDynamics.instance.executorService != null) {
                    AppDynamics.instance.executorService.shutdownNow();
                }
            }
        }
    }

    synchronized void createAndUpdateTracer() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.tracerFuture != null) {
            if (this.tracerFuture.isDone()) {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Tracer instantiation complete.", new Object[0]);
                this.extractTracerFromFuture();
            } else {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Tracer instantiation in progress. Will return existing tracer.", new Object[0]);
            }
        } else if (this.shouldGetTracerConfig()) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Tracer Registration period reached. Will refresh Tracer.", new Object[0]);
            this.submitTracerBuildTask();
        } else {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Tracer does not need to be fetched.", new Object[0]);
        }
    }

    synchronized void submitTracerBuildTask() {
        TransactionMonitoringContext txContext = new TransactionMonitoringContext(this.eventManager, this.transactionCorrelator, this.exitCallInfoToRegisteredInfoCache, this.btInfoToRegisteredInfoCache, this.logger, this.errorHelper);
        txContext.setDefaultBtName(this.config.getDefaultBtName());
        TracerBuilder tracerBuilder = new TracerBuilder(txContext, this.registrationService, this.config, this.logger);
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        this.tracerFuture = this.executorService.submit(tracerBuilder);
        if (this.tracer == null) {
            this.setTracer(new TracerImpl(txContext, this.config.getHeaderReadLimit()));
        }
    }

    synchronized void extractTracerFromFuture() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.tracerFuture != null) {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Getting tracer future.", new Object[0]);
            Tracer tracer = this.tracerFuture.get(AGENT_CONFIG_FUTURE_TIMEOUT, TimeUnit.MILLISECONDS);
            if (tracer instanceof TracerImpl) {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Future Call succeeded. Successfully instantiated Tracer.", new Object[0]);
                this.setTracer(tracer);
            } else {
                this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Future call failed. NoOpTracer created.", new Object[0]);
            }
            this.refreshLastConfigSuccess();
            this.tracerFuture = null;
        } else {
            this.logger.log(AWSLambdaLogger.LogLevel.DEBUG, "Tried to get tracer future but is null.", new Object[0]);
        }
    }

    void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    static Tracer getCurrentTracer() {
        if (instance == null || AppDynamics.instance.tracer == null) {
            return noOpTracer;
        }
        return AppDynamics.instance.tracer;
    }

    boolean shouldGetTracerConfig() {
        long now = System.currentTimeMillis();
        return this.agentConfigUpdatePeriodMs == -1L || now - this.lastConfigSuccess > this.agentConfigUpdatePeriodMs;
    }

    private void refreshLastConfigSuccess() {
        long now = System.currentTimeMillis();
        long agentConfigRetryTimeout = EnvironmentVariableUtil.getEnvLong("APPDYNAMICS_AGENT_CONFIG_RETRY_TIMEOUT", AGENT_CONFIG_RETRY_TIMEOUT_MILLIS);
        if (!(AppDynamics.getCurrentTracer() instanceof NoOpTracer) || this.agentConfigUpdatePeriodMs != -1L || now - this.lastConfigSuccess > agentConfigRetryTimeout) {
            this.lastConfigSuccess = now;
            this.agentConfigUpdatePeriodMs = EnvironmentVariableUtil.getEnvLong("APPDYNAMICS_AGENT_CONFIG_UPDATE_PERIOD_MS", 60000L);
        }
    }

    static String getVersion() {
        return AppDynamics.class.getPackage().getImplementationVersion();
    }

    static {
        PROXY_REQUIRED_VARIABLES = Arrays.asList("APPDYNAMICS_HTTP_PROXY_HOST", "APPDYNAMICS_HTTP_PROXY_PORT");
        AGENT_CONFIG_RETRY_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        AGENT_CONFIG_FUTURE_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    }

    public static class Config {
        private final String accountName;
        private final String applicationName;
        private final Object lambdaContext;
        private final String defaultBtName;
        private final String tierName;
        private final String controllerHost;
        private final Integer controllerPort;
        private final Object lambdaLogger;
        private final String functionName;
        private final String functionVersion;
        private final String invokedFunctionArn;
        private final String controllerAccessKey;
        private final String tracerVersion;
        private final boolean noOpConfig;
        private final int headerReadLimit;

        Config(String accountName, String applicationName, Object lambdaContext, String defaultBtName, String tierName, String controllerHost, Integer controllerPort, Object lambdaLogger, String functionName, String functionVersion, String invokedFunctionArn, String controllerAccessKey, int headerReadLimit) {
            this.accountName = accountName;
            this.applicationName = applicationName;
            this.lambdaContext = lambdaContext;
            this.defaultBtName = defaultBtName;
            this.tierName = tierName;
            this.controllerHost = controllerHost;
            this.controllerPort = controllerPort;
            this.lambdaLogger = lambdaLogger;
            this.functionName = functionName;
            this.functionVersion = functionVersion;
            this.invokedFunctionArn = invokedFunctionArn;
            this.controllerAccessKey = controllerAccessKey;
            this.tracerVersion = AppDynamics.getVersion();
            this.headerReadLimit = headerReadLimit;
            this.noOpConfig = false;
        }

        private Config() {
            this.accountName = "";
            this.applicationName = "";
            this.lambdaContext = "";
            this.defaultBtName = "";
            this.tierName = "";
            this.controllerHost = "";
            this.controllerPort = 0;
            this.lambdaLogger = "";
            this.functionName = "";
            this.functionVersion = "";
            this.invokedFunctionArn = "";
            this.controllerAccessKey = "";
            this.tracerVersion = AppDynamics.getVersion();
            this.headerReadLimit = 0;
            this.noOpConfig = true;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getFunctionVersion() {
            return this.functionVersion;
        }

        public Object getLambdaLogger() {
            return this.lambdaLogger;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public Object getLambdaContext() {
            return this.lambdaContext;
        }

        public String getDefaultBtName() {
            return this.defaultBtName;
        }

        public String getTierName() {
            return this.tierName;
        }

        public String getControllerHost() {
            return this.controllerHost;
        }

        public Integer getControllerPort() {
            return this.controllerPort;
        }

        public String getInvokedFunctionArn() {
            return this.invokedFunctionArn;
        }

        public String getControllerAccessKey() {
            return this.controllerAccessKey;
        }

        public String getTracerVersion() {
            return this.tracerVersion;
        }

        boolean isNoOpConfig() {
            return this.noOpConfig;
        }

        int getHeaderReadLimit() {
            return this.headerReadLimit;
        }

        public String toString() {
            return "Config{accountName='" + this.accountName + '\'' + ", applicationName='" + this.applicationName + '\'' + ", lambdaContext=" + this.lambdaContext + ", defaultBtName='" + this.defaultBtName + '\'' + ", tierName='" + this.tierName + '\'' + ", controllerHost='" + this.controllerHost + '\'' + ", controllerPort=" + this.controllerPort + ", lambdaLogger=" + this.lambdaLogger + ", functionName='" + this.functionName + '\'' + ", functionVersion='" + this.functionVersion + '\'' + ", invokedFunctionArn='" + this.invokedFunctionArn + '\'' + ", controllerAccessKey='************', tracerVersion='" + this.tracerVersion + '\'' + ", headerReadLimit=" + this.headerReadLimit + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return Objects.equals(this.accountName, config.accountName) && Objects.equals(this.applicationName, config.applicationName) && Objects.equals(this.defaultBtName, config.defaultBtName) && Objects.equals(this.tierName, config.tierName) && Objects.equals(this.controllerHost, config.controllerHost) && Objects.equals(this.controllerPort, config.controllerPort) && Objects.equals(this.lambdaLogger, config.lambdaLogger) && Objects.equals(this.functionName, config.functionName) && Objects.equals(this.functionVersion, config.functionVersion) && Objects.equals(this.invokedFunctionArn, config.invokedFunctionArn) && Objects.equals(this.controllerAccessKey, config.controllerAccessKey) && Objects.equals(this.tracerVersion, config.tracerVersion) && Objects.equals(this.headerReadLimit, config.headerReadLimit);
        }

        public int hashCode() {
            return Objects.hash(this.accountName, this.applicationName, this.lambdaContext, this.defaultBtName, this.tierName, this.controllerHost, this.controllerPort, this.lambdaLogger, this.functionName, this.functionVersion, this.invokedFunctionArn, this.controllerAccessKey, this.headerReadLimit);
        }

        public static class Builder {
            private String accountName;
            private String applicationName;
            private Object lambdaContext;
            private String defaultBtName;
            private String tierName;
            private String controllerHost;
            private Integer controllerPort;
            private String controllerAccessKey;
            private int headerReadLimit;

            public Builder accountName(String accountName) {
                if (accountName != null) {
                    accountName = accountName.trim().toLowerCase();
                }
                this.accountName = accountName;
                return this;
            }

            public Builder applicationName(String appName) {
                if (appName != null) {
                    appName = appName.trim();
                }
                this.applicationName = appName;
                return this;
            }

            public Builder tierName(String tierName) {
                if (tierName != null) {
                    tierName = tierName.trim();
                }
                this.tierName = tierName;
                return this;
            }

            public Builder lambdaContext(Object lambdaContext) {
                this.lambdaContext = lambdaContext;
                return this;
            }

            public Builder defaultBtName(String defaultBtName) {
                if (defaultBtName != null) {
                    defaultBtName = defaultBtName.trim();
                }
                this.defaultBtName = defaultBtName;
                return this;
            }

            public Builder controllerHost(String controllerHost) {
                if (controllerHost != null) {
                    controllerHost = controllerHost.trim().toLowerCase();
                    String httpPrefix = "http://";
                    String httpsPrefix = "https://";
                    if (controllerHost.startsWith("http://")) {
                        controllerHost = controllerHost.substring("http://".length());
                    } else if (controllerHost.startsWith("https://")) {
                        controllerHost = controllerHost.substring("https://".length());
                    }
                    if (controllerHost.endsWith("/")) {
                        controllerHost = controllerHost.substring(0, controllerHost.length() - 1);
                    }
                }
                this.controllerHost = controllerHost;
                return this;
            }

            public Builder controllerPort(int port) {
                this.controllerPort = port;
                return this;
            }

            public Builder controllerAccessKey(String controllerAccessKey) {
                if (controllerAccessKey != null) {
                    controllerAccessKey = controllerAccessKey.trim();
                }
                this.controllerAccessKey = controllerAccessKey;
                return this;
            }

            public Builder headerReadLimit(int headerReadLimit) {
                this.headerReadLimit = headerReadLimit;
                return this;
            }

            private String concatFunctionNameAndVersion(String fnName, String fnVersion) {
                return fnName + "-" + fnVersion;
            }

            public Config build() {
                try {
                    Util.checkArgument(null != this.lambdaContext, "Lambda context cannot be null", new Object[0]);
                    Util.checkArgument(StringOperations.isNotEmpty(this.accountName), "Account name cannot be empty or null", new Object[0]);
                    Util.checkArgument(StringOperations.isNotEmpty(this.applicationName), "App name cannot be empty or null", new Object[0]);
                    Util.checkArgument(StringOperations.isNotEmpty(this.controllerAccessKey), "Controller access key cannot be empty or null", new Object[0]);
                }
                catch (Exception e) {
                    sysOutLogger.log(AWSLambdaLogger.LogLevel.ERROR, "Will return empty config for NoOpTracer, hit error while validating fields: '" + e.getMessage() + "'", new Object[0]);
                    return new Config();
                }
                if (this.controllerHost == null) {
                    this.controllerHost = this.accountName + ".saas.appdynamics.com";
                }
                if (this.controllerPort == null || this.controllerPort <= 0) {
                    this.controllerPort = 443;
                }
                if (this.headerReadLimit <= 0) {
                    this.headerReadLimit = 6;
                }
                String fnName = AWSLambdaContextUtil.getFunctionName(this.lambdaContext, sysOutLogger);
                String fnVersion = AWSLambdaContextUtil.getFunctionVersion(this.lambdaContext, sysOutLogger);
                String fnArn = AWSLambdaContextUtil.getInvokedFunctionArn(this.lambdaContext, sysOutLogger);
                if (this.tierName == null) {
                    this.tierName = this.concatFunctionNameAndVersion(fnName, fnVersion);
                }
                if (this.defaultBtName == null) {
                    this.defaultBtName = this.concatFunctionNameAndVersion(fnName, fnVersion);
                }
                Object lambdaLogger = AWSLambdaContextUtil.getLambdaLogger(this.lambdaContext, sysOutLogger);
                return new Config(this.accountName, this.applicationName, this.lambdaContext, this.defaultBtName, this.tierName, this.controllerHost, this.controllerPort, lambdaLogger, fnName, fnVersion, fnArn, this.controllerAccessKey, this.headerReadLimit);
            }
        }
    }
}

