/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.eumagent.runtime;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import com.appdynamics.eumagent.runtime.Instrumentation;
import com.appdynamics.eumagent.runtime.private.ao;
import com.appdynamics.eumagent.runtime.private.ap;
import com.appdynamics.eumagent.runtime.private.aq;
import com.appdynamics.eumagent.runtime.private.az;
import com.appdynamics.eumagent.runtime.private.bb;
import com.appdynamics.eumagent.runtime.private.br;
import com.appdynamics.eumagent.runtime.private.bs;
import com.appdynamics.eumagent.runtime.private.bt;
import com.appdynamics.eumagent.runtime.private.bu;
import com.appdynamics.eumagent.runtime.private.bx;
import com.appdynamics.eumagent.runtime.private.cd;
import com.appdynamics.eumagent.runtime.private.w;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class InstrumentationCallbacks {
    public static WeakReference<Activity> currentActivity;

    public static void reportCrash(Throwable throwable) {
        try {
            w w2 = Instrumentation.b;
            if (w2 != null) {
                w2.a(Thread.currentThread(), throwable);
            }
            return;
        }
        catch (Throwable throwable2) {
            InstrumentationCallbacks.safeLog("Exception while reporting crash", throwable2);
            return;
        }
    }

    public static void onCreateCalled(Activity activity, Bundle bundle) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 0);
    }

    public static void onStartCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 1);
    }

    public static void onResumeCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 2);
        try {
            currentActivity = new WeakReference<Activity>(activity);
            bx bx2 = Instrumentation.d;
            if (activity.getWindow() != null && bx2 != null) {
                bx2.a(activity.getWindow().getDecorView());
            }
            if (Instrumentation.i != null) {
                activity = activity.getWindow().getDecorView().getRootView();
                Instrumentation.a.a(new bb((View)activity));
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while trying to watch root view", throwable);
            return;
        }
    }

    public static void onPauseCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 3);
    }

    public static void onStopCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 4);
    }

    public static void onDestroyCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 6);
    }

    public static void onRestartCalled(Activity activity) {
        InstrumentationCallbacks.reportActivityLifecycleEvent(activity, 5);
    }

    public static void onConfigurationChangedCalled(Activity activity, Configuration configuration) {
        try {
            if (Instrumentation.i != null) {
                activity = activity.getWindow().getDecorView().getRootView();
                Instrumentation.a.a(new bb((View)activity));
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while dispatching orientation changed event", throwable);
            return;
        }
    }

    public static void dispatchTouchEventCalled(Activity activity, MotionEvent motionEvent) {
        try {
            if (Instrumentation.i != null) {
                Instrumentation.a.a(MotionEvent.obtain((MotionEvent)motionEvent));
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while capturing touch", throwable);
            return;
        }
    }

    private static void reportActivityLifecycleEvent(Activity object, int n2) {
        try {
            object = object != null ? object.getClass().getName() : "null";
            object = new bs((String)object, n2);
            Instrumentation.a.a(object);
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while reporting Activity lifecycle event", throwable);
            return;
        }
    }

    public static void safeLog(String object, Throwable object2) {
        try {
            aq.a((String)object, (Throwable)object2);
            Object object3 = Instrumentation.i;
            if (object3 != null) {
                object3 = object2;
                object2 = object;
                object = ((Instrumentation)object3).l;
                long l2 = SystemClock.uptimeMillis();
                if (l2 > ((ao)object).b + 60000L) {
                    object2 = new ap((String)object2, (Throwable)object3, ((ao)object).c);
                    ((ao)object).d.a(object2);
                    ((ao)object).c = 0;
                    ((ao)object).b = l2;
                    return;
                }
                ++((ao)object).c;
            }
            return;
        }
        catch (Throwable throwable) {
            aq.a("Error sending log message", throwable);
            return;
        }
    }

    public static void requestAboutToBeSent(URLConnection uRLConnection) {
        try {
            aq.b("InstrumentationCallbacks.requestAboutToBeSent called");
            Instrumentation instrumentation = Instrumentation.i;
            if (instrumentation != null && instrumentation.j != null) {
                instrumentation.j.b(uRLConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception in pre-request handler", throwable);
            return;
        }
    }

    public static void requestSent(URLConnection uRLConnection) {
        try {
            aq.b("InstrumentationCallbacks.requestSent called");
            Instrumentation instrumentation = Instrumentation.i;
            if (instrumentation != null && instrumentation.j != null) {
                instrumentation.j.c(uRLConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception in post-request handler", throwable);
            return;
        }
    }

    public static void requestHarvestable(URLConnection uRLConnection) {
        try {
            aq.b("InstrumentationCallbacks.requestHarvestable called");
            Instrumentation instrumentation = Instrumentation.i;
            if (instrumentation != null && instrumentation.j != null) {
                instrumentation.j.a(uRLConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception in marking request as reportable", throwable);
            return;
        }
    }

    public static void networkError(URLConnection uRLConnection, IOException iOException) {
        try {
            aq.b("InstrumentationCallbacks.networkError called");
            Instrumentation instrumentation = Instrumentation.i;
            if (instrumentation != null && instrumentation.j != null) {
                instrumentation.j.a(uRLConnection, iOException);
            }
            return;
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception in network request handler", throwable);
            return;
        }
    }

    public static InputStream getInputStream(URLConnection uRLConnection) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.getInputStream called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).j != null) {
                URLConnection uRLConnection2 = uRLConnection;
                object = ((Instrumentation)object).j;
                return new az.a((az)object, uRLConnection2){
                    private /* synthetic */ URLConnection b;
                    {
                        this.b = uRLConnection;
                        super(az2, (byte)0);
                    }

                    final InputStream a() {
                        return this.b.getInputStream();
                    }
                }.a(uRLConnection2);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while fetching input stream", throwable);
        }
        try {
            return uRLConnection.getInputStream();
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static InputStream getErrorStream(HttpURLConnection httpURLConnection) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.getErrorStream called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).j != null) {
                HttpURLConnection httpURLConnection2 = httpURLConnection;
                object = ((Instrumentation)object).j;
                return new az.a((az)object, httpURLConnection2){
                    private /* synthetic */ HttpURLConnection b;
                    {
                        this.b = httpURLConnection;
                        super(az2, (byte)0);
                    }

                    final InputStream a() {
                        return this.b.getErrorStream();
                    }
                }.a(httpURLConnection2);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a();
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while fetching error stream", throwable);
        }
        try {
            return httpURLConnection.getErrorStream();
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpUriRequest);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest httpUriRequest, HttpContext httpContext) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest, HttpContext) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpUriRequest, httpContext);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpHost, httpRequest);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static HttpResponse execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest, HttpContext) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpHost, httpRequest, httpContext);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ResponseHandler responseHandler) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest, ResponseHandler) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpUriRequest, responseHandler);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest, responseHandler);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpUriRequest httpUriRequest, ResponseHandler responseHandler, HttpContext httpContext) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpUriRequest, ResponseHandler, HttpContext) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpUriRequest, responseHandler, httpContext);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpUriRequest, responseHandler, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler responseHandler) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest, ResponseHandler) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpHost, httpRequest, responseHandler);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest, responseHandler);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static Object execute(HttpClient httpClient, HttpHost httpHost, HttpRequest httpRequest, ResponseHandler responseHandler, HttpContext httpContext) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.execute(HttpClient, HttpHost, HttpRequest, ResponseHandler, HttpContext) called");
            object = Instrumentation.i;
            if (object != null && ((Instrumentation)object).k != null) {
                return ((Instrumentation)object).k.a(httpClient, httpHost, httpRequest, responseHandler, httpContext);
            }
        }
        catch (cd cd2) {
            object = cd2;
            InstrumentationCallbacks.strip(cd2.getCause());
            ((cd)object).a(IOException.class);
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while executing http request", throwable);
        }
        try {
            return httpClient.execute(httpHost, httpRequest, responseHandler, httpContext);
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
        catch (IOException iOException) {
            object = iOException;
            InstrumentationCallbacks.strip(iOException);
            throw object;
        }
    }

    public static void setOnHierarchyChangeListenerCalled(ViewGroup viewGroup, ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.OnSetOnHierarchyChangeListener(ViewGroup, OnHierarchyChangeListener) called");
            object = Instrumentation.d;
            if (Instrumentation.h && object != null) {
                ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener2 = onHierarchyChangeListener;
                ViewGroup viewGroup2 = viewGroup;
                if (!((bx)object).c.get().booleanValue()) {
                    ((bx)object).c.set(true);
                    if (onHierarchyChangeListener2 == ((bx)object).b) {
                        ((bx)object).c.set(false);
                        return;
                    }
                    if (onHierarchyChangeListener2 != null) {
                        ((bx)object).a.put((View)viewGroup2, onHierarchyChangeListener2);
                    } else {
                        ((bx)object).a.remove(viewGroup2);
                    }
                    viewGroup2.setOnHierarchyChangeListener(((bx)object).b);
                    ((bx)object).c.set(false);
                    return;
                }
                aq.c("setOnHierarchyChangeListener detected recursion.");
                return;
            }
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while setting hierarchy change listener on view group", throwable);
        }
        try {
            viewGroup.setOnHierarchyChangeListener(onHierarchyChangeListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static void setOnClickListenerCalled(View view, View.OnClickListener onClickListener) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.setOnClickListenerCalled(View, OnClickListener) called");
            object = Instrumentation.e;
            if (Instrumentation.h && view instanceof Button && object != null) {
                ((bt)object).a(view, onClickListener);
                return;
            }
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while setting click listener on view", throwable);
        }
        try {
            view.setOnClickListener(onClickListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static void setOnItemClickListenerCalled(AdapterView adapterView, AdapterView.OnItemClickListener onItemClickListener) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.setOnItemClickListenerCalled(AdapterView, OnItemClickListener) called");
            object = Instrumentation.f;
            if (Instrumentation.h && object != null) {
                ((br)object).a(adapterView, onItemClickListener);
                return;
            }
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while setting click listener on view", throwable);
        }
        try {
            adapterView.setOnItemClickListener(onItemClickListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    public static void setOnFocusChangeListenerCalled(View view, View.OnFocusChangeListener onFocusChangeListener) {
        Object object;
        try {
            aq.b("InstrumentationCallbacks.setOnFocusChangeListenerCalled(View, OnFocusChangeListener) called");
            object = Instrumentation.g;
            if (Instrumentation.h && view instanceof EditText && object != null) {
                ((bu)object).a(view, onFocusChangeListener);
                return;
            }
        }
        catch (Throwable throwable) {
            InstrumentationCallbacks.safeLog("Exception while setting focus change listener on view", throwable);
        }
        try {
            view.setOnFocusChangeListener(onFocusChangeListener);
            return;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            InstrumentationCallbacks.strip(runtimeException);
            throw object;
        }
    }

    private static void strip(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        try {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            boolean bl2 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement.getClassName() != null && stackTraceElement.getClassName().startsWith("com.appdynamics.eumagent.runtime")) {
                    bl2 = true;
                    continue;
                }
                arrayList.add(stackTraceElement);
            }
            if (bl2) {
                throwable.setStackTrace(arrayList.toArray(new StackTraceElement[arrayList.size()]));
            }
            return;
        }
        catch (Throwable throwable2) {
            InstrumentationCallbacks.safeLog("Failed to strip stacktrace", throwable2);
            return;
        }
    }
}

