/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.logging;

import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.util.BuildUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BCIRunSummary {
    private int classCount;
    private final Set<String> failedClasses = new HashSet<String>();
    private final HashMap<String, Set<String>> featureClasses = new HashMap();
    private static final BCIRunSummary summary = new BCIRunSummary();
    private static final HashMap<String, Feature> featureMap = new HashMap();
    public static final String APACHE_HTTP = "APACHE_HTTP";
    public static final String URL_HTTP = "URL_HTTP";
    public static final String ANR = "ANR";
    public static final String INFO_POINT = "INFO_POINT";
    public static final String DYNAMIC_INFO_POINTS = "DYNAMIC_INFO_POINTS";
    public static final String CRASH_REPORTING = "CRASH_REPORTING";
    public static final String JS_INJECTION = "JS_INJECTION";
    public static final String VIEW = "VIEW";
    public static final String VIEW_GROUP = "VIEW_GROUP";

    public static void addFeature(Feature.Type type, String name, String desc) {
        Feature f = new Feature(type, name, desc);
        featureMap.put(name, f);
    }

    public static BCIRunSummary getDefaultInstance() {
        return summary;
    }

    public void featureInjected(String f, String className) {
        Set<String> classes = this.featureClasses.get(f);
        if (classes == null) {
            classes = new HashSet<String>();
            this.featureClasses.put(f, classes);
        }
        classes.add(className.replaceAll("/", "."));
    }

    public void failedToInstrumentClass(String className) {
        this.failedClasses.add(className);
    }

    public void incrementClassCount() {
        ++this.classCount;
    }

    private int getTotalInstrumented() {
        HashSet<String> allClasses = new HashSet<String>();
        for (Set<String> classes : this.featureClasses.values()) {
            allClasses.addAll(classes);
        }
        return allClasses.size();
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public void printSummary() {
        boolean bl;
        BCILogger logger = BCILogger.getBciLogger();
        String header = "AppDynamics BCI Instrumentation summary";
        logger.info("\n\n\n\t\t\t\t%s", BuildUtils.encloseInBanner(header, '=').replaceAll("\n", "\n\t\t\t\t"));
        int totalFeatures = 0;
        for (String string : featureMap.keySet()) {
            Set<String> set = this.featureClasses.get(string);
            totalFeatures += this.isEmpty(set) ? 0 : 1;
        }
        StringBuilder summary = new StringBuilder();
        summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", "Total number of classes visited", this.classCount));
        summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", "Total number of classes instrumented", this.getTotalInstrumented()));
        summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", "Total number of classes failed to instrument", this.failedClasses.size()));
        summary.append(String.format("\n\t\t - %-70s(#%d)", "Total number of features discovered", totalFeatures));
        if (totalFeatures > 0) {
            summary.append("\n\n\tThe following features were discovered in your application by Appdynamics:");
            for (String string : featureMap.keySet()) {
                Set<String> values = this.featureClasses.get(string);
                if (this.isEmpty(values)) continue;
                summary.append(String.format("\n\t\t - %-70s(#%-5d classes)", featureMap.get(string).desc, values.size()));
            }
        } else {
            summary.append("\n\nNo features were discovered in your application!");
        }
        boolean bl2 = false;
        for (String feature : featureMap.keySet()) {
            Feature f = featureMap.get(feature);
            if (f.type != Feature.Type.NET || this.isEmpty((Collection)this.featureClasses.get(feature))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            summary.append("\n\n\t\t").append(BuildUtils.encloseInBanner("Warning: We did not detect any network calls in your application").replaceAll("\n", "\n\t\t"));
        }
        logger.info(summary.append("\n").toString(), new Object[0]);
        for (Map.Entry<String, Set<String>> entry : this.featureClasses.entrySet()) {
            StringBuilder featureInfo = new StringBuilder(String.format("\n\tPrinting out all the classes in which [%s] feature was discovered.", entry.getKey()));
            for (String clazz : entry.getValue()) {
                featureInfo.append("\n\t\t - ").append(clazz);
            }
            logger.debug(featureInfo.toString(), new Object[0]);
        }
        if (this.failedClasses.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder("\n\tWe failed to instrument the following classes:");
            for (String clazz : this.failedClasses) {
                stringBuilder.append("\n\t - ").append(clazz);
            }
            logger.info(stringBuilder.append("\n\n").toString(), new Object[0]);
        }
    }

    static {
        BCIRunSummary.addFeature(Feature.Type.NET, APACHE_HTTP, "Network calls using apache's HttpClient");
        BCIRunSummary.addFeature(Feature.Type.NET, URL_HTTP, "Network calls using java.net.HttpURLConnection");
        BCIRunSummary.addFeature(Feature.Type.OTHER, ANR, "Detect Application not responding");
        BCIRunSummary.addFeature(Feature.Type.OTHER, INFO_POINT, "Info points reported statically");
        BCIRunSummary.addFeature(Feature.Type.OTHER, DYNAMIC_INFO_POINTS, "Classes for which infopoints can be defined at runtime");
        BCIRunSummary.addFeature(Feature.Type.OTHER, CRASH_REPORTING, "Automatically report app crashes");
        BCIRunSummary.addFeature(Feature.Type.OTHER, JS_INJECTION, "Inject JS agent into WebView");
        BCIRunSummary.addFeature(Feature.Type.UI, VIEW, "Detect calls from View");
        BCIRunSummary.addFeature(Feature.Type.UI, VIEW_GROUP, "Detect calls from ViewGroup");
    }

    public static class Feature {
        private final String name;
        private final String desc;
        private final Type type;

        private Feature(Type type, String name, String desc) {
            this.name = name;
            this.desc = desc;
            this.type = type;
        }

        public static enum Type {
            NET,
            UI,
            OTHER;

        }
    }
}

