/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.AnnotationVisitor;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;

public class InfoPointInjector
extends BaseClassVisitor {
    private static final String INFO_POINT_ANNOTATION_CLASS = "Lcom/appdynamics/eumagent/runtime/InfoPoint;";
    private static final String EXCEPTION_CLASS = "java/lang/Exception";
    private static final Type INSTRUMENTATION = Type.getObjectType("com/appdynamics/eumagent/runtime/Instrumentation");
    private static final Method BEGIN_CALL = Method.getMethod("com.appdynamics.eumagent.runtime.CallTracker beginCall(boolean, String, String, Object[])");
    private static final Type CALLTRACKER = Type.getType("Lcom/appdynamics/eumagent/runtime/CallTracker;");
    private static final Method REPORT_CALL_ENDED = Method.getMethod("void reportCallEnded()");
    private static final Method REPORT_CALL_ENDED_WITH_RETURN_VALUE = Method.getMethod("void reportCallEndedWithReturnValue(Object)");
    private static final Method REPORT_CALL_ENDED_WITH_EXCEPTION = Method.getMethod("void reportCallEndedWithException(Exception)");

    public InfoPointInjector(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    @Override
    public MethodVisitor visitMethod(final int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        return new BaseClassVisitor.BaseMethodVisitor(super.visitMethod(access, methodName, methodDesc, signature, exceptions), access, methodName, methodDesc){
            private Label tryStartLabel;
            private Label tryEndLabel;
            private int trackerRef;
            private boolean infoPointMethod;
            {
                super(mv, access2, name, desc);
                this.infoPointMethod = false;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (!this.infoPointMethod) {
                    this.infoPointMethod = InfoPointInjector.INFO_POINT_ANNOTATION_CLASS.equals(desc);
                    if (this.infoPointMethod) {
                        this.tryStartLabel = new Label();
                        this.tryEndLabel = new Label();
                        BCIRunSummary.getDefaultInstance().featureInjected("INFO_POINT", InfoPointInjector.this.className);
                        InfoPointInjector.this.logInjectedWithLineNumber("%s.%s is annotated with @InfoPoint. InfoPoint calls will be injected into this method.", InfoPointInjector.this.className, this.methodName);
                    }
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public void visitCode() {
                super.visitCode();
                if (this.infoPointMethod) {
                    this.trackerRef = this.newLocal(CALLTRACKER);
                    int isStatic = (access & 8) != 0 ? 4 : 3;
                    this.mv.visitInsn(isStatic);
                    this.mv.visitLdcInsn(InfoPointInjector.this.className);
                    this.mv.visitLdcInsn(this.methodName);
                    this.loadArgArray();
                    this.invokeStatic(INSTRUMENTATION, BEGIN_CALL);
                    this.mv.visitVarInsn(58, this.trackerRef);
                    this.mv.visitLabel(this.tryStartLabel);
                    InfoPointInjector.this.logInjectedWithLineNumber("Injected: %s.%s at the beginning of %s.%s", INSTRUMENTATION, BEGIN_CALL, InfoPointInjector.this.className, this.methodName);
                }
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.infoPointMethod) {
                    this.mv.visitLabel(this.tryEndLabel);
                    Label afterIf = new Label();
                    this.mv.visitVarInsn(25, this.trackerRef);
                    this.mv.visitJumpInsn(198, afterIf);
                    this.mv.visitInsn(89);
                    this.mv.visitVarInsn(25, this.trackerRef);
                    this.mv.visitInsn(95);
                    this.invokeInterface(CALLTRACKER, REPORT_CALL_ENDED_WITH_EXCEPTION);
                    this.mv.visitLabel(afterIf);
                    this.mv.visitInsn(191);
                    InfoPointInjector.this.logInjectedWithLineNumber("Injected %s.%s in catch of %s.%s", CALLTRACKER, REPORT_CALL_ENDED_WITH_EXCEPTION, InfoPointInjector.this.className, this.methodName);
                }
                super.visitMaxs(maxStack, maxLocals);
            }

            @Override
            protected void onMethodExit(int opcode) {
                if (this.infoPointMethod && opcode != 191) {
                    Label afterIf = new Label();
                    this.mv.visitVarInsn(25, this.trackerRef);
                    this.mv.visitJumpInsn(198, afterIf);
                    Type returnType = Type.getReturnType(this.methodDesc);
                    if (Type.VOID_TYPE.equals(returnType)) {
                        this.mv.visitVarInsn(25, this.trackerRef);
                        this.invokeInterface(CALLTRACKER, REPORT_CALL_ENDED);
                        InfoPointInjector.this.logInjectedWithLineNumber("Injected: %s.%s at one exit of %s.%s", CALLTRACKER, REPORT_CALL_ENDED, InfoPointInjector.this.className, this.methodName);
                    } else {
                        if (InfoPointInjector.typeDoesRequireTwoWordsToReturn(returnType)) {
                            this.dup2();
                        } else {
                            this.dup();
                        }
                        this.box(returnType);
                        this.mv.visitVarInsn(25, this.trackerRef);
                        this.mv.visitInsn(95);
                        this.invokeInterface(CALLTRACKER, REPORT_CALL_ENDED_WITH_RETURN_VALUE);
                        InfoPointInjector.this.logInjectedWithLineNumber("Injected: %s.%s at one exit of %s.%s", CALLTRACKER, REPORT_CALL_ENDED_WITH_RETURN_VALUE, InfoPointInjector.this.className, this.methodName);
                    }
                    this.mv.visitLabel(afterIf);
                }
            }

            @Override
            public void visitEnd() {
                if (this.infoPointMethod) {
                    this.mv.visitTryCatchBlock(this.tryStartLabel, this.tryEndLabel, this.tryEndLabel, InfoPointInjector.EXCEPTION_CLASS);
                }
                super.visitEnd();
            }
        };
    }

    private static boolean typeDoesRequireTwoWordsToReturn(Type type) {
        return type == Type.LONG_TYPE || type == Type.DOUBLE_TYPE;
    }
}

